/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text;

import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.core.ElementChangedEvent;
import org.eclipse.wst.jsdt.core.IElementChangedListener;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.wst.jsdt.internal.ui.text.JavaCompositeReconcilingStrategy;

public class JavaReconciler
extends MonoReconciler {
    private ITextEditor fTextEditor;
    private IPartListener fPartListener;
    private ShellListener fActivationListener;
    private Object fMutex;
    private IElementChangedListener fJavaElementChangedListener;
    private volatile boolean fHasJavaModelChanged = true;
    private volatile boolean fIsEditorActive = true;
    private IResourceChangeListener fResourceChangeListener;
    private IPropertyChangeListener fPropertyChangeListener;
    private volatile boolean fIsReconciling = false;
    private boolean fIninitalProcessDone = false;

    public JavaReconciler(ITextEditor iTextEditor, JavaCompositeReconcilingStrategy javaCompositeReconcilingStrategy, boolean bl) {
        super((IReconcilingStrategy)javaCompositeReconcilingStrategy, bl);
        this.fTextEditor = iTextEditor;
        this.fMutex = iTextEditor instanceof CompilationUnitEditor ? ((CompilationUnitEditor)iTextEditor).getReconcilerLock() : new Object();
    }

    public void install(ITextViewer iTextViewer) {
        super.install(iTextViewer);
        this.fPartListener = new PartListener();
        IWorkbenchPartSite iWorkbenchPartSite = this.fTextEditor.getSite();
        IWorkbenchWindow iWorkbenchWindow = iWorkbenchPartSite.getWorkbenchWindow();
        iWorkbenchWindow.getPartService().addPartListener(this.fPartListener);
        this.fActivationListener = new ActivationListener((Control)iTextViewer.getTextWidget());
        Shell shell = iWorkbenchWindow.getShell();
        shell.addShellListener(this.fActivationListener);
        this.fJavaElementChangedListener = new ElementChangedListener();
        JavaCore.addElementChangedListener((IElementChangedListener)this.fJavaElementChangedListener);
        this.fResourceChangeListener = new ResourceChangeListener();
        IWorkspace iWorkspace = JavaPlugin.getWorkspace();
        iWorkspace.addResourceChangeListener(this.fResourceChangeListener);
        this.fPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("spellingEnabled".equals(propertyChangeEvent.getProperty()) || "spellingEngine".equals(propertyChangeEvent.getProperty())) {
                    JavaReconciler.this.forceReconciling();
                }
            }
        };
        JavaPlugin.getDefault().getCombinedPreferenceStore().addPropertyChangeListener(this.fPropertyChangeListener);
    }

    public void uninstall() {
        IWorkbenchPartSite iWorkbenchPartSite = this.fTextEditor.getSite();
        IWorkbenchWindow iWorkbenchWindow = iWorkbenchPartSite.getWorkbenchWindow();
        iWorkbenchWindow.getPartService().removePartListener(this.fPartListener);
        this.fPartListener = null;
        Shell shell = iWorkbenchWindow.getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.removeShellListener(this.fActivationListener);
        }
        this.fActivationListener = null;
        JavaCore.removeElementChangedListener((IElementChangedListener)this.fJavaElementChangedListener);
        this.fJavaElementChangedListener = null;
        IWorkspace iWorkspace = JavaPlugin.getWorkspace();
        iWorkspace.removeResourceChangeListener(this.fResourceChangeListener);
        this.fResourceChangeListener = null;
        JavaPlugin.getDefault().getCombinedPreferenceStore().removePropertyChangeListener(this.fPropertyChangeListener);
        this.fPropertyChangeListener = null;
        super.uninstall();
    }

    protected void forceReconciling() {
        if (!this.fIninitalProcessDone) {
            return;
        }
        super.forceReconciling();
        JavaCompositeReconcilingStrategy javaCompositeReconcilingStrategy = (JavaCompositeReconcilingStrategy)this.getReconcilingStrategy("__dftl_partition_content_type");
        javaCompositeReconcilingStrategy.notifyListeners(false);
    }

    protected void aboutToBeReconciled() {
        JavaCompositeReconcilingStrategy javaCompositeReconcilingStrategy = (JavaCompositeReconcilingStrategy)this.getReconcilingStrategy("__dftl_partition_content_type");
        javaCompositeReconcilingStrategy.aboutToBeReconciled();
    }

    protected void reconcilerReset() {
        super.reconcilerReset();
        JavaCompositeReconcilingStrategy javaCompositeReconcilingStrategy = (JavaCompositeReconcilingStrategy)this.getReconcilingStrategy("__dftl_partition_content_type");
        javaCompositeReconcilingStrategy.notifyListeners(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialProcess() {
        Object object = this.fMutex;
        synchronized (object) {
            super.initialProcess();
        }
        this.fIninitalProcessDone = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(DirtyRegion dirtyRegion) {
        Object object = this.fMutex;
        synchronized (object) {
            this.fIsReconciling = true;
            super.process(dirtyRegion);
            this.fIsReconciling = false;
        }
    }

    private synchronized boolean hasJavaModelChanged() {
        return this.fHasJavaModelChanged;
    }

    private synchronized void setJavaModelChanged(boolean bl) {
        this.fHasJavaModelChanged = bl;
    }

    private synchronized boolean isEditorActive() {
        return this.fIsEditorActive;
    }

    private synchronized void setEditorActive(boolean bl) {
        this.fIsEditorActive = bl;
    }

    private class ActivationListener
    extends ShellAdapter {
        private Control fControl;

        public ActivationListener(Control control) {
            Assert.isNotNull((Object)control);
            this.fControl = control;
        }

        public void shellActivated(ShellEvent shellEvent) {
            if (!this.fControl.isDisposed() && this.fControl.isVisible()) {
                if (JavaReconciler.this.hasJavaModelChanged()) {
                    JavaReconciler.this.forceReconciling();
                }
                JavaReconciler.this.setEditorActive(true);
            }
        }

        public void shellDeactivated(ShellEvent shellEvent) {
            if (!this.fControl.isDisposed() && this.fControl.getShell() == shellEvent.getSource()) {
                JavaReconciler.this.setJavaModelChanged(false);
                JavaReconciler.this.setEditorActive(false);
            }
        }
    }

    private class ElementChangedListener
    implements IElementChangedListener {
        private ElementChangedListener() {
        }

        public void elementChanged(ElementChangedEvent elementChangedEvent) {
            if (elementChangedEvent.getDelta().getFlags() == 524288) {
                return;
            }
            JavaReconciler.this.setJavaModelChanged(true);
            if (!JavaReconciler.this.fIsReconciling && JavaReconciler.this.isEditorActive()) {
                JavaReconciler.this.forceReconciling();
            }
        }
    }

    private class PartListener
    implements IPartListener {
        private PartListener() {
        }

        public void partActivated(IWorkbenchPart iWorkbenchPart) {
            if (iWorkbenchPart == JavaReconciler.this.fTextEditor) {
                if (JavaReconciler.this.hasJavaModelChanged()) {
                    JavaReconciler.this.forceReconciling();
                }
                JavaReconciler.this.setEditorActive(true);
            }
        }

        public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
        }

        public void partClosed(IWorkbenchPart iWorkbenchPart) {
        }

        public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
            if (iWorkbenchPart == JavaReconciler.this.fTextEditor) {
                JavaReconciler.this.setJavaModelChanged(false);
                JavaReconciler.this.setEditorActive(false);
            }
        }

        public void partOpened(IWorkbenchPart iWorkbenchPart) {
        }
    }

    class ResourceChangeListener
    implements IResourceChangeListener {
        ResourceChangeListener() {
        }

        private IResource getResource() {
            IEditorInput iEditorInput = JavaReconciler.this.fTextEditor.getEditorInput();
            if (iEditorInput instanceof IFileEditorInput) {
                IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
                return iFileEditorInput.getFile();
            }
            return null;
        }

        public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
            IResourceDelta iResourceDelta;
            IResourceDelta iResourceDelta2 = iResourceChangeEvent.getDelta();
            IResource iResource = this.getResource();
            if (iResourceDelta2 != null && iResource != null && (iResourceDelta = iResourceDelta2.findMember(iResource.getFullPath())) != null) {
                IMarkerDelta[] iMarkerDeltaArray = iResourceDelta.getMarkerDeltas();
                int n = iMarkerDeltaArray.length;
                while (--n >= 0) {
                    try {
                        if (!iMarkerDeltaArray[n].getMarker().isSubtypeOf("org.eclipse.core.resources.problemmarker")) continue;
                        JavaReconciler.this.forceReconciling();
                        return;
                    }
                    catch (CoreException coreException) {}
                }
            }
        }
    }
}

