/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.text.correction.AssistContext;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ICommandAccess;
import org.eclipse.wst.jsdt.internal.ui.text.correction.JavaCorrectionAssistant;
import org.eclipse.wst.jsdt.internal.ui.text.correction.JavaCorrectionProcessor;
import org.eclipse.wst.jsdt.internal.ui.text.correction.LinkedNamesAssistProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.wst.jsdt.ui.JavaUI;
import org.eclipse.wst.jsdt.ui.text.java.IInvocationContext;

public class CorrectionCommandHandler
extends AbstractHandler {
    private final JavaEditor fEditor;
    private final String fId;
    private final boolean fIsAssist;
    static /* synthetic */ Class class$0;

    public CorrectionCommandHandler(JavaEditor javaEditor, String string, boolean bl) {
        this.fEditor = javaEditor;
        this.fId = string;
        this.fIsAssist = bl;
    }

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        ISelection iSelection = this.fEditor.getSelectionProvider().getSelection();
        ICompilationUnit iCompilationUnit = JavaUI.getWorkingCopyManager().getWorkingCopy(this.fEditor.getEditorInput());
        IAnnotationModel iAnnotationModel = JavaUI.getDocumentProvider().getAnnotationModel((Object)this.fEditor.getEditorInput());
        if (iSelection instanceof ITextSelection && iCompilationUnit != null && iAnnotationModel != null) {
            if (!ActionUtil.isEditable(this.fEditor)) {
                return null;
            }
            ICompletionProposal iCompletionProposal = this.findCorrection(this.fId, this.fIsAssist, (ITextSelection)iSelection, iCompilationUnit, iAnnotationModel);
            if (iCompletionProposal != null) {
                this.invokeProposal(iCompletionProposal, ((ITextSelection)iSelection).getOffset());
            }
        }
        return null;
    }

    private ICompletionProposal findCorrection(String string, boolean bl, ITextSelection iTextSelection, ICompilationUnit iCompilationUnit, IAnnotationModel iAnnotationModel) {
        Object object;
        AssistContext assistContext = new AssistContext(iCompilationUnit, iTextSelection.getOffset(), iTextSelection.getLength());
        ArrayList arrayList = new ArrayList(10);
        if (bl) {
            if (string.equals("org.eclipse.wst.jsdt.ui.correction.renameInFile.assist")) {
                return this.getLocalRenameProposal(assistContext);
            }
            JavaCorrectionProcessor.collectAssists(assistContext, new ProblemLocation[0], arrayList);
        } else {
            try {
                boolean bl2 = iTextSelection.getLength() == 0;
                object = this.getAnnotations(iTextSelection.getOffset(), bl2);
                JavaCorrectionProcessor.collectProposals(assistContext, iAnnotationModel, object, true, false, arrayList);
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!(object instanceof ICommandAccess) || !string.equals(((ICommandAccess)object).getCommandId())) continue;
            return (ICompletionProposal)object;
        }
        return null;
    }

    private Annotation[] getAnnotations(int n, boolean bl) throws BadLocationException {
        ArrayList arrayList = new ArrayList();
        JavaCorrectionAssistant.collectQuickFixableAnnotations((ITextEditor)this.fEditor, n, bl, arrayList);
        return arrayList.toArray(new Annotation[arrayList.size()]);
    }

    private ICompletionProposal getLocalRenameProposal(IInvocationContext iInvocationContext) {
        ASTNode aSTNode = iInvocationContext.getCoveringNode();
        if (aSTNode instanceof SimpleName) {
            return new LinkedNamesAssistProposal(iInvocationContext.getCompilationUnit(), (SimpleName)aSTNode);
        }
        return null;
    }

    private IDocument getDocument() {
        return JavaUI.getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput());
    }

    private void invokeProposal(ICompletionProposal iCompletionProposal, int n) {
        ISourceViewer iSourceViewer;
        if (iCompletionProposal instanceof ICompletionProposalExtension2) {
            iSourceViewer = this.fEditor.getViewer();
            if (iSourceViewer != null) {
                ((ICompletionProposalExtension2)iCompletionProposal).apply((ITextViewer)iSourceViewer, '\u0000', 0, n);
                return;
            }
        } else if (iCompletionProposal instanceof ICompletionProposalExtension && (iSourceViewer = this.getDocument()) != null) {
            ((ICompletionProposalExtension)iCompletionProposal).apply((IDocument)iSourceViewer, '\u0000', n);
            return;
        }
        if ((iSourceViewer = this.getDocument()) != null) {
            iCompletionProposal.apply((IDocument)iSourceViewer);
        }
    }

    public static String getShortCutString(String string) {
        if (string != null) {
            TriggerSequence[] triggerSequenceArray;
            IBindingService iBindingService;
            IWorkbench iWorkbench = PlatformUI.getWorkbench();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.keys.IBindingService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iBindingService = (IBindingService)iWorkbench.getAdapter((Class)clazz)) != null && (triggerSequenceArray = iBindingService.getActiveBindingsFor(string)).length > 0) {
                return triggerSequenceArray[0].format();
            }
        }
        return null;
    }
}

