/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.EnumConstantDeclaration;
import org.eclipse.wst.jsdt.core.dom.EnumDeclaration;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.Javadoc;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.core.dom.TextElement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.wst.jsdt.internal.ui.text.correction.JavadocTagsSubProcessor;
import org.eclipse.wst.jsdt.internal.ui.text.correction.LinkedCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ModifierCorrectionSubProcessor;

public class NewVariableCompletionProposal
extends LinkedCorrectionProposal {
    public static final int LOCAL = 1;
    public static final int FIELD = 2;
    public static final int PARAM = 3;
    public static final int CONST_FIELD = 4;
    public static final int ENUM_CONST = 5;
    private static final String KEY_NAME = "name";
    private static final String KEY_TYPE = "type";
    private static final String KEY_INITIALIZER = "initializer";
    private final int fVariableKind;
    private final SimpleName fOriginalNode;
    private final ITypeBinding fSenderBinding;

    public NewVariableCompletionProposal(String string, ICompilationUnit iCompilationUnit, int n, SimpleName simpleName, ITypeBinding iTypeBinding, int n2, Image image) {
        super(string, iCompilationUnit, (ASTRewrite)null, n2, image);
        if (iTypeBinding == null) {
            Assert.isTrue((n == 3 || n == 1 ? 1 : 0) != 0);
        } else {
            Assert.isTrue((boolean)Bindings.isDeclarationBinding((IBinding)iTypeBinding));
        }
        this.fVariableKind = n;
        this.fOriginalNode = simpleName;
        this.fSenderBinding = iTypeBinding;
    }

    protected ASTRewrite getRewrite() throws CoreException {
        CompilationUnit compilationUnit = ASTResolving.findParentCompilationUnit((ASTNode)this.fOriginalNode);
        switch (this.fVariableKind) {
            case 3: {
                return this.doAddParam(compilationUnit);
            }
            case 2: 
            case 4: {
                return this.doAddField(compilationUnit);
            }
            case 1: {
                return this.doAddLocal(compilationUnit);
            }
            case 5: {
                return this.doAddEnumConst(compilationUnit);
            }
        }
        throw new IllegalArgumentException("Unsupported variable kind: " + this.fVariableKind);
    }

    private ASTRewrite doAddParam(CompilationUnit compilationUnit) throws CoreException {
        AST aST = compilationUnit.getAST();
        SimpleName simpleName = this.fOriginalNode;
        BodyDeclaration bodyDeclaration = ASTResolving.findParentBodyDeclaration((ASTNode)simpleName);
        if (bodyDeclaration instanceof MethodDeclaration) {
            MethodDeclaration methodDeclaration = (MethodDeclaration)bodyDeclaration;
            ASTRewrite aSTRewrite = ASTRewrite.create((AST)aST);
            ImportRewrite importRewrite = this.createImportRewrite((CompilationUnit)bodyDeclaration.getRoot());
            SingleVariableDeclaration singleVariableDeclaration = aST.newSingleVariableDeclaration();
            singleVariableDeclaration.setType(this.evaluateVariableType(aST, importRewrite, (IBinding)methodDeclaration.resolveBinding()));
            singleVariableDeclaration.setName(aST.newSimpleName(simpleName.getIdentifier()));
            ListRewrite listRewrite = aSTRewrite.getListRewrite((ASTNode)bodyDeclaration, MethodDeclaration.PARAMETERS_PROPERTY);
            listRewrite.insertLast((ASTNode)singleVariableDeclaration, null);
            this.addLinkedPosition(aSTRewrite.track((ASTNode)singleVariableDeclaration.getType()), false, KEY_TYPE);
            this.addLinkedPosition(aSTRewrite.track((ASTNode)simpleName), true, KEY_NAME);
            this.addLinkedPosition(aSTRewrite.track((ASTNode)singleVariableDeclaration.getName()), false, KEY_NAME);
            Javadoc javadoc = methodDeclaration.getJavadoc();
            if (javadoc != null) {
                SingleVariableDeclaration singleVariableDeclaration2;
                HashSet<String> hashSet = new HashSet<String>();
                SimpleName simpleName2 = methodDeclaration.parameters().iterator();
                while (simpleName2.hasNext()) {
                    singleVariableDeclaration2 = (SingleVariableDeclaration)simpleName2.next();
                    hashSet.add(singleVariableDeclaration2.getName().getIdentifier());
                }
                simpleName2 = aST.newSimpleName(simpleName.getIdentifier());
                singleVariableDeclaration2 = aST.newTagElement();
                singleVariableDeclaration2.setTagName("@param");
                singleVariableDeclaration2.fragments().add(simpleName2);
                TextElement textElement = aST.newTextElement();
                singleVariableDeclaration2.fragments().add(textElement);
                this.addLinkedPosition(aSTRewrite.track((ASTNode)simpleName2), true, KEY_NAME);
                this.addLinkedPosition(aSTRewrite.track((ASTNode)textElement), false, "comment_start");
                ListRewrite listRewrite2 = aSTRewrite.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY);
                JavadocTagsSubProcessor.insertTag(listRewrite2, (TagElement)singleVariableDeclaration2, hashSet);
            }
            return aSTRewrite;
        }
        return null;
    }

    private boolean isAssigned(Statement statement, SimpleName simpleName) {
        ExpressionStatement expressionStatement;
        if (statement instanceof ExpressionStatement && (expressionStatement = (ExpressionStatement)statement).getExpression() instanceof Assignment) {
            Assignment assignment = (Assignment)expressionStatement.getExpression();
            return assignment.getLeftHandSide() == simpleName;
        }
        return false;
    }

    private boolean isForStatementInit(Statement statement, SimpleName simpleName) {
        ForStatement forStatement;
        List list;
        if (statement instanceof ForStatement && (list = (forStatement = (ForStatement)statement).initializers()).size() == 1 && list.get(0) instanceof Assignment) {
            Assignment assignment = (Assignment)list.get(0);
            return assignment.getLeftHandSide() == simpleName;
        }
        return false;
    }

    private ASTRewrite doAddLocal(CompilationUnit compilationUnit) throws CoreException {
        SimpleName simpleName;
        Block block;
        AST aST = compilationUnit.getAST();
        BodyDeclaration bodyDeclaration = ASTResolving.findParentBodyDeclaration((ASTNode)this.fOriginalNode);
        IMethodBinding iMethodBinding = null;
        if (bodyDeclaration instanceof MethodDeclaration) {
            block = ((MethodDeclaration)bodyDeclaration).getBody();
            iMethodBinding = ((MethodDeclaration)bodyDeclaration).resolveBinding();
        } else if (bodyDeclaration instanceof Initializer) {
            block = ((Initializer)bodyDeclaration).getBody();
            iMethodBinding = Bindings.getBindingOfParentType((ASTNode)bodyDeclaration);
        } else {
            return null;
        }
        ASTRewrite aSTRewrite = ASTRewrite.create((AST)aST);
        ImportRewrite importRewrite = this.createImportRewrite((CompilationUnit)bodyDeclaration.getRoot());
        SimpleName[] simpleNameArray = this.getAllReferences(block);
        ASTNode aSTNode = this.getDominantNode(simpleNameArray);
        Statement statement = ASTResolving.findParentStatement(aSTNode);
        if (ASTNodes.isControlStatementBody(statement.getLocationInParent())) {
            statement = (Statement)statement.getParent();
        }
        if (this.isAssigned(statement, simpleName = simpleNameArray[0])) {
            Assignment assignment = (Assignment)simpleName.getParent();
            VariableDeclarationFragment variableDeclarationFragment = aST.newVariableDeclarationFragment();
            VariableDeclarationExpression variableDeclarationExpression = aST.newVariableDeclarationExpression(variableDeclarationFragment);
            variableDeclarationExpression.setType(this.evaluateVariableType(aST, importRewrite, (IBinding)iMethodBinding));
            Expression expression = (Expression)aSTRewrite.createCopyTarget((ASTNode)assignment.getRightHandSide());
            variableDeclarationFragment.setInitializer(expression);
            variableDeclarationFragment.setName(aST.newSimpleName(simpleName.getIdentifier()));
            aSTRewrite.replace((ASTNode)assignment, (ASTNode)variableDeclarationExpression, null);
            this.addLinkedPosition(aSTRewrite.track((ASTNode)variableDeclarationExpression.getType()), false, KEY_TYPE);
            this.addLinkedPosition(aSTRewrite.track((ASTNode)variableDeclarationFragment.getName()), true, KEY_NAME);
            this.setEndPosition(aSTRewrite.track(assignment.getParent()));
            return aSTRewrite;
        }
        if (aSTNode != statement && this.isForStatementInit(statement, simpleName)) {
            Assignment assignment = (Assignment)simpleName.getParent();
            VariableDeclarationFragment variableDeclarationFragment = aST.newVariableDeclarationFragment();
            VariableDeclarationExpression variableDeclarationExpression = aST.newVariableDeclarationExpression(variableDeclarationFragment);
            variableDeclarationFragment.setName(aST.newSimpleName(simpleName.getIdentifier()));
            Expression expression = (Expression)aSTRewrite.createCopyTarget((ASTNode)assignment.getRightHandSide());
            variableDeclarationFragment.setInitializer(expression);
            variableDeclarationExpression.setType(this.evaluateVariableType(aST, importRewrite, (IBinding)iMethodBinding));
            aSTRewrite.replace((ASTNode)assignment, (ASTNode)variableDeclarationExpression, null);
            this.addLinkedPosition(aSTRewrite.track((ASTNode)variableDeclarationExpression.getType()), false, KEY_TYPE);
            this.addLinkedPosition(aSTRewrite.track((ASTNode)variableDeclarationFragment.getName()), true, KEY_NAME);
            this.setEndPosition(aSTRewrite.track((ASTNode)variableDeclarationExpression));
            return aSTRewrite;
        }
        VariableDeclarationFragment variableDeclarationFragment = aST.newVariableDeclarationFragment();
        VariableDeclarationStatement variableDeclarationStatement = aST.newVariableDeclarationStatement(variableDeclarationFragment);
        variableDeclarationFragment.setName(aST.newSimpleName(simpleName.getIdentifier()));
        variableDeclarationStatement.setType(this.evaluateVariableType(aST, importRewrite, (IBinding)iMethodBinding));
        this.addLinkedPosition(aSTRewrite.track((ASTNode)variableDeclarationStatement.getType()), false, KEY_TYPE);
        this.addLinkedPosition(aSTRewrite.track((ASTNode)simpleName), true, KEY_NAME);
        this.addLinkedPosition(aSTRewrite.track((ASTNode)variableDeclarationFragment.getName()), false, KEY_NAME);
        Statement statement2 = statement;
        List list = ASTNodes.getContainingList((ASTNode)statement2);
        while (list == null && statement2.getParent() instanceof Statement) {
            statement2 = (Statement)statement2.getParent();
            list = ASTNodes.getContainingList((ASTNode)statement2);
        }
        if (list != null) {
            ASTNode aSTNode2 = statement2.getParent();
            StructuralPropertyDescriptor structuralPropertyDescriptor = statement2.getLocationInParent();
            if (structuralPropertyDescriptor.isChildListProperty()) {
                aSTRewrite.getListRewrite(aSTNode2, (ChildListPropertyDescriptor)structuralPropertyDescriptor).insertBefore((ASTNode)variableDeclarationStatement, (ASTNode)statement2, null);
                return aSTRewrite;
            }
            return null;
        }
        return aSTRewrite;
    }

    private SimpleName[] getAllReferences(Block block) {
        SimpleName[] simpleNameArray = LinkedNodeFinder.findByProblems((ASTNode)block, this.fOriginalNode);
        if (simpleNameArray == null) {
            return new SimpleName[]{this.fOriginalNode};
        }
        if (simpleNameArray.length > 1) {
            Arrays.sort(simpleNameArray, new Comparator(){

                public int compare(Object object, Object object2) {
                    return ((SimpleName)object).getStartPosition() - ((SimpleName)object2).getStartPosition();
                }
            });
        }
        return simpleNameArray;
    }

    private ASTNode getDominantNode(SimpleName[] simpleNameArray) {
        SimpleName simpleName = simpleNameArray[0];
        int n = 1;
        while (n < simpleNameArray.length) {
            SimpleName simpleName2 = simpleNameArray[n];
            if (simpleName2 != simpleName) {
                ASTNode aSTNode = this.getCommonParent((ASTNode)simpleName2, (ASTNode)simpleName);
                if (simpleName2.getStartPosition() < simpleName.getStartPosition()) {
                    simpleName = simpleName2;
                }
                while (simpleName.getParent() != aSTNode) {
                    simpleName = simpleName.getParent();
                }
            }
            ++n;
        }
        n = simpleName.getParent().getNodeType();
        if (n != 8 && n != 24 && n != 83) {
            return simpleName.getParent();
        }
        return simpleName;
    }

    private ASTNode getCommonParent(ASTNode aSTNode, ASTNode aSTNode2) {
        ASTNode aSTNode3 = aSTNode.getParent();
        while (aSTNode3 != null && !ASTNodes.isParent(aSTNode2, aSTNode3)) {
            aSTNode3 = aSTNode3.getParent();
        }
        return aSTNode3;
    }

    private ASTRewrite doAddField(CompilationUnit compilationUnit) throws CoreException {
        SimpleName simpleName = this.fOriginalNode;
        boolean bl = false;
        ASTNode aSTNode = compilationUnit.findDeclaringNode((IBinding)this.fSenderBinding);
        if (aSTNode == null) {
            compilationUnit = ASTResolving.createQuickFixAST(this.getCompilationUnit(), null);
            aSTNode = compilationUnit.findDeclaringNode(this.fSenderBinding.getKey());
            bl = true;
        }
        ImportRewrite importRewrite = this.createImportRewrite(compilationUnit);
        if (aSTNode != null) {
            AST aST = aSTNode.getAST();
            ASTRewrite aSTRewrite = ASTRewrite.create((AST)aST);
            VariableDeclarationFragment variableDeclarationFragment = aST.newVariableDeclarationFragment();
            variableDeclarationFragment.setName(aST.newSimpleName(simpleName.getIdentifier()));
            Type type = this.evaluateVariableType(aST, importRewrite, (IBinding)this.fSenderBinding);
            FieldDeclaration fieldDeclaration = aST.newFieldDeclaration(variableDeclarationFragment);
            fieldDeclaration.setType(type);
            fieldDeclaration.modifiers().addAll(ASTNodeFactory.newModifiers(aST, this.evaluateFieldModifiers(aSTNode)));
            if (this.fSenderBinding.isInterface() || this.fVariableKind == 4) {
                variableDeclarationFragment.setInitializer(ASTNodeFactory.newDefaultExpression(aST, type, 0));
            }
            ChildListPropertyDescriptor childListPropertyDescriptor = ASTNodes.getBodyDeclarationsProperty(aSTNode);
            List list = (List)aSTNode.getStructuralProperty((StructuralPropertyDescriptor)childListPropertyDescriptor);
            int n = bl ? -1 : simpleName.getStartPosition();
            int n2 = this.findFieldInsertIndex(list, fieldDeclaration, n);
            ListRewrite listRewrite = aSTRewrite.getListRewrite(aSTNode, childListPropertyDescriptor);
            listRewrite.insertAt((ASTNode)fieldDeclaration, n2, null);
            ModifierCorrectionSubProcessor.installLinkedVisibilityProposals(this.getLinkedProposalModel(), aSTRewrite, fieldDeclaration.modifiers(), this.fSenderBinding.isInterface());
            this.addLinkedPosition(aSTRewrite.track((ASTNode)fieldDeclaration.getType()), false, KEY_TYPE);
            if (!bl) {
                this.addLinkedPosition(aSTRewrite.track((ASTNode)simpleName), true, KEY_NAME);
            }
            this.addLinkedPosition(aSTRewrite.track((ASTNode)variableDeclarationFragment.getName()), false, KEY_NAME);
            if (variableDeclarationFragment.getInitializer() != null) {
                this.addLinkedPosition(aSTRewrite.track((ASTNode)variableDeclarationFragment.getInitializer()), false, KEY_INITIALIZER);
            }
            return aSTRewrite;
        }
        return null;
    }

    private int findFieldInsertIndex(List list, FieldDeclaration fieldDeclaration, int n) {
        if (n != -1) {
            int n2 = list.size() - 1;
            while (n2 >= 0) {
                ASTNode aSTNode = (ASTNode)list.get(n2);
                if (n > aSTNode.getStartPosition() + aSTNode.getLength()) {
                    return ASTNodes.getInsertionIndex((BodyDeclaration)fieldDeclaration, list.subList(0, n2 + 1));
                }
                --n2;
            }
            return 0;
        }
        return ASTNodes.getInsertionIndex((BodyDeclaration)fieldDeclaration, list);
    }

    private Type evaluateVariableType(AST aST, ImportRewrite importRewrite, IBinding iBinding) throws CoreException {
        ITypeBinding[] iTypeBindingArray;
        ITypeBinding iTypeBinding;
        if (this.fOriginalNode.getParent() instanceof MethodInvocation && (iTypeBinding = (MethodInvocation)this.fOriginalNode.getParent()).getExpression() == this.fOriginalNode && (iTypeBindingArray = ASTResolving.getQualifierGuess(this.fOriginalNode.getRoot(), iTypeBinding.getName().getIdentifier(), iTypeBinding.arguments(), iBinding)).length > 0) {
            int n = 0;
            while (n < iTypeBindingArray.length) {
                this.addLinkedPositionProposal(KEY_TYPE, iTypeBindingArray[n]);
                ++n;
            }
            return importRewrite.addImport(iTypeBindingArray[0], aST);
        }
        iTypeBinding = ASTResolving.guessBindingForReference((ASTNode)this.fOriginalNode);
        if (iTypeBinding != null) {
            if (iTypeBinding.isWildcardType() && (iTypeBinding = ASTResolving.normalizeWildcardType(iTypeBinding, this.isVariableAssigned(), aST)) == null) {
                iTypeBinding = aST.resolveWellKnownType("java.lang.Object");
            }
            if (this.isVariableAssigned()) {
                iTypeBindingArray = ASTResolving.getRelaxingTypes(aST, iTypeBinding);
                int n = 0;
                while (n < iTypeBindingArray.length) {
                    this.addLinkedPositionProposal(KEY_TYPE, iTypeBindingArray[n]);
                    ++n;
                }
            }
            return importRewrite.addImport(iTypeBinding, aST);
        }
        iTypeBindingArray = ASTResolving.guessTypeForReference(aST, (ASTNode)this.fOriginalNode);
        if (iTypeBindingArray != null) {
            return iTypeBindingArray;
        }
        if (this.fVariableKind == 4) {
            return aST.newSimpleType((Name)aST.newSimpleName("String"));
        }
        return aST.newSimpleType((Name)aST.newSimpleName("Object"));
    }

    private boolean isVariableAssigned() {
        ASTNode aSTNode = this.fOriginalNode.getParent();
        return aSTNode instanceof Assignment && this.fOriginalNode == ((Assignment)aSTNode).getLeftHandSide();
    }

    private int evaluateFieldModifiers(ASTNode aSTNode) {
        ASTNode aSTNode2;
        if (this.fSenderBinding.isAnnotation()) {
            return 0;
        }
        if (this.fSenderBinding.isInterface()) {
            FieldDeclaration[] fieldDeclarationArray = ((TypeDeclaration)aSTNode).getFields();
            if (fieldDeclarationArray.length > 0) {
                return fieldDeclarationArray[0].getModifiers();
            }
            return 0;
        }
        int n = 0;
        if (this.fVariableKind == 4) {
            n |= 0x18;
        } else {
            aSTNode2 = this.fOriginalNode.getParent();
            if (aSTNode2 instanceof QualifiedName) {
                IBinding iBinding = ((QualifiedName)aSTNode2).getQualifier().resolveBinding();
                if (iBinding instanceof ITypeBinding) {
                    n |= 8;
                }
            } else if (ASTResolving.isInStaticContext((ASTNode)this.fOriginalNode)) {
                n |= 8;
            }
        }
        aSTNode2 = ASTResolving.findParentType((ASTNode)this.fOriginalNode, true);
        n = aSTNode.equals((Object)aSTNode2) ? (n |= 2) : (aSTNode2 instanceof AnonymousClassDeclaration ? (n |= 4) : (n |= 1));
        return n;
    }

    private ASTRewrite doAddEnumConst(CompilationUnit compilationUnit) throws CoreException {
        SimpleName simpleName = this.fOriginalNode;
        ASTNode aSTNode = compilationUnit.findDeclaringNode((IBinding)this.fSenderBinding);
        if (aSTNode == null) {
            compilationUnit = ASTResolving.createQuickFixAST(this.getCompilationUnit(), null);
            aSTNode = compilationUnit.findDeclaringNode(this.fSenderBinding.getKey());
        }
        if (aSTNode != null) {
            AST aST = aSTNode.getAST();
            ASTRewrite aSTRewrite = ASTRewrite.create((AST)aST);
            EnumConstantDeclaration enumConstantDeclaration = aST.newEnumConstantDeclaration();
            enumConstantDeclaration.setName(aST.newSimpleName(simpleName.getIdentifier()));
            ListRewrite listRewrite = aSTRewrite.getListRewrite(aSTNode, EnumDeclaration.ENUM_CONSTANTS_PROPERTY);
            listRewrite.insertLast((ASTNode)enumConstantDeclaration, null);
            this.addLinkedPosition(aSTRewrite.track((ASTNode)enumConstantDeclaration.getName()), false, KEY_NAME);
            return aSTRewrite;
        }
        return null;
    }

    public int getVariableKind() {
        return this.fVariableKind;
    }
}

