/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.ParameterizedType;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.corext.fix.AbstractSerialVersionOperation;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.wst.jsdt.launching.IRuntimeClasspathEntry;
import org.eclipse.wst.jsdt.launching.JavaRuntime;

public final class SerialVersionHashOperation
extends AbstractSerialVersionOperation {
    private static final String SERIAL_SUPPORT_JAR = "serialsupport.jar";
    private final ICompilationUnit fCompilationUnit;

    public static String[] computeUserAndBootClasspath(IJavaProject iJavaProject) throws CoreException {
        IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = JavaRuntime.computeUnresolvedRuntimeClasspath(iJavaProject);
        ArrayList<String> arrayList = new ArrayList<String>(iRuntimeClasspathEntryArray.length);
        int n = 0;
        while (n < iRuntimeClasspathEntryArray.length) {
            IRuntimeClasspathEntry iRuntimeClasspathEntry = iRuntimeClasspathEntryArray[n];
            int n2 = iRuntimeClasspathEntry.getClasspathProperty();
            if (n2 == 3 || n2 == 2) {
                IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray2 = JavaRuntime.resolveRuntimeClasspathEntry(iRuntimeClasspathEntry, iJavaProject);
                int n3 = 0;
                while (n3 < iRuntimeClasspathEntryArray2.length) {
                    String string = iRuntimeClasspathEntryArray2[n3].getLocation();
                    if (string != null) {
                        arrayList.add(string);
                    }
                    ++n3;
                }
            }
            ++n;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static long[] calculateSerialVersionIds(String[] stringArray, IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws CoreException, IOException {
        return null;
    }

    private static void displayErrorMessage(final String string) {
        final Display display = PlatformUI.getWorkbench().getDisplay();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                public final void run() {
                    Shell shell;
                    if (!display.isDisposed() && (shell = display.getActiveShell()) != null && !shell.isDisposed()) {
                        MessageDialog.openError((Shell)shell, (String)CorrectionMessages.SerialVersionHashProposal_dialog_error_caption, (String)Messages.format(CorrectionMessages.SerialVersionHashProposal_dialog_error_message, string));
                    }
                }
            });
        }
    }

    private static void displayErrorMessage(Throwable throwable) {
        SerialVersionHashOperation.displayErrorMessage(throwable.getLocalizedMessage());
    }

    private static boolean displayYesNoMessage(final String string, final String string2) {
        final boolean[] blArray = new boolean[]{true};
        final Display display = PlatformUI.getWorkbench().getDisplay();
        if (display != null && !display.isDisposed()) {
            display.syncExec(new Runnable(){

                public final void run() {
                    Shell shell;
                    if (!display.isDisposed() && (shell = display.getActiveShell()) != null && !shell.isDisposed()) {
                        blArray[0] = MessageDialog.openQuestion((Shell)shell, (String)string, (String)string2);
                    }
                }
            });
        }
        return blArray[0];
    }

    public SerialVersionHashOperation(ICompilationUnit iCompilationUnit, ASTNode[] aSTNodeArray) {
        super(iCompilationUnit, aSTNodeArray);
        this.fCompilationUnit = iCompilationUnit;
    }

    protected boolean addInitializer(final VariableDeclarationFragment variableDeclarationFragment, final ASTNode aSTNode) throws CoreException {
        Assert.isNotNull((Object)variableDeclarationFragment);
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public final void run(IProgressMonitor iProgressMonitor) throws InterruptedException {
                    Assert.isNotNull((Object)iProgressMonitor);
                    String string = SerialVersionHashOperation.this.computeId(aSTNode, iProgressMonitor);
                    variableDeclarationFragment.setInitializer((Expression)variableDeclarationFragment.getAST().newNumberLiteral(string));
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            JavaPlugin.log(invocationTargetException);
        }
        catch (InterruptedException interruptedException) {}
        return true;
    }

    protected void addLinkedPositions(ASTRewrite aSTRewrite, VariableDeclarationFragment variableDeclarationFragment, LinkedProposalModel linkedProposalModel) {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String computeId(ASTNode aSTNode, IProgressMonitor iProgressMonitor) throws InterruptedException {
        Assert.isNotNull((Object)iProgressMonitor);
        Object object = 1L;
        try {
            try {
                Object object2;
                iProgressMonitor.beginTask(CorrectionMessages.SerialVersionHashProposal_computing_id, 200);
                IJavaProject iJavaProject = this.fCompilationUnit.getJavaProject();
                IPath iPath = this.fCompilationUnit.getResource().getFullPath();
                try {
                    FileBuffers.getTextFileBufferManager().connect(iPath, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 10));
                    if (iProgressMonitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    object2 = FileBuffers.getTextFileBufferManager().getTextFileBuffer(iPath, LocationKind.IFILE);
                    if (object2.isDirty() && object2.isStateValidated() && object2.isCommitable() && SerialVersionHashOperation.displayYesNoMessage(CorrectionMessages.SerialVersionHashProposal_save_caption, CorrectionMessages.SerialVersionHashProposal_save_message)) {
                        object2.commit((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 20), true);
                    } else {
                        iProgressMonitor.worked(20);
                    }
                    if (iProgressMonitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    FileBuffers.getTextFileBufferManager().disconnect(iPath, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 10));
                    throw throwable;
                }
                {
                    Object var8_11 = null;
                }
                FileBuffers.getTextFileBufferManager().disconnect(iPath, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 10));
                iJavaProject.getProject().build(10, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 60));
                if (iProgressMonitor.isCanceled()) {
                    throw new InterruptedException();
                }
                object2 = SerialVersionHashOperation.calculateSerialVersionIds(new String[]{this.getQualifiedName(aSTNode)}, iJavaProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
                if (((ITextFileBuffer)object2).length == 1) {
                    object = object2[0];
                }
            }
            catch (CoreException coreException) {
                SerialVersionHashOperation.displayErrorMessage(coreException);
            }
            catch (IOException iOException) {
                SerialVersionHashOperation.displayErrorMessage(iOException);
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var10_14 = null;
        }
        iProgressMonitor.done();
        return String.valueOf(object) + "L";
    }

    private String getQualifiedName(ASTNode aSTNode) {
        ITypeBinding iTypeBinding = null;
        if (aSTNode instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration abstractTypeDeclaration = (AbstractTypeDeclaration)aSTNode;
            iTypeBinding = abstractTypeDeclaration.resolveBinding();
        } else if (aSTNode instanceof AnonymousClassDeclaration) {
            AnonymousClassDeclaration anonymousClassDeclaration = (AnonymousClassDeclaration)aSTNode;
            ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)anonymousClassDeclaration.getParent();
            iTypeBinding = classInstanceCreation.resolveTypeBinding();
        } else if (aSTNode instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)aSTNode;
            iTypeBinding = parameterizedType.resolveBinding();
        }
        if (iTypeBinding != null) {
            return iTypeBinding.getBinaryName();
        }
        return null;
    }
}

