/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.HashSet;
import org.eclipse.wst.jsdt.core.CompletionProposal;
import org.eclipse.wst.jsdt.core.CompletionRequestor;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.Javadoc;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.util.TypeFilter;
import org.eclipse.wst.jsdt.internal.ui.text.correction.NameMatcher;
import org.eclipse.wst.jsdt.internal.ui.text.correction.SimilarElement;

public class SimilarElementsRequestor
extends CompletionRequestor {
    public static final int CLASSES = 2;
    public static final int INTERFACES = 4;
    public static final int ANNOTATIONS = 8;
    public static final int ENUMS = 16;
    public static final int VARIABLES = 32;
    public static final int PRIMITIVETYPES = 64;
    public static final int VOIDTYPE = 128;
    public static final int REF_TYPES = 30;
    public static final int REF_TYPES_AND_VAR = 62;
    public static final int ALL_TYPES = 126;
    private static final String[] PRIM_TYPES = new String[]{"boolean", "byte", "char", "short", "int", "long", "float", "double"};
    private int fKind;
    private String fName;
    private HashSet fResult;

    public static SimilarElement[] findSimilarElement(ICompilationUnit iCompilationUnit, Name name, int n) throws JavaModelException {
        SimilarElement[] similarElementArray;
        block3: {
            int n2 = name.getStartPosition();
            int n3 = -1;
            String string = ASTNodes.getSimpleNameIdentifier(name);
            String string2 = null;
            ICompilationUnit iCompilationUnit2 = null;
            try {
                n2 = name.getStartPosition() + 1;
                Javadoc javadoc = (Javadoc)ASTNodes.getParent((ASTNode)name, 29);
                if (javadoc != null) {
                    iCompilationUnit = iCompilationUnit2 = SimilarElementsRequestor.createPreparedCU(iCompilationUnit, javadoc, name.getStartPosition());
                }
                SimilarElementsRequestor similarElementsRequestor = new SimilarElementsRequestor(string, n, n3, string2);
                similarElementsRequestor.setIgnored(1, true);
                similarElementsRequestor.setIgnored(3, true);
                similarElementsRequestor.setIgnored(4, true);
                similarElementsRequestor.setIgnored(7, true);
                similarElementsRequestor.setIgnored(8, true);
                similarElementsRequestor.setIgnored(10, true);
                similarElementsRequestor.setIgnored(6, true);
                similarElementsRequestor.setIgnored(2, true);
                similarElementsRequestor.setIgnored(5, true);
                similarElementsRequestor.setIgnored(10, true);
                similarElementsRequestor.setIgnored(10, true);
                similarElementsRequestor.setIgnored(11, true);
                similarElementsRequestor.setIgnored(12, true);
                similarElementArray = similarElementsRequestor.process(iCompilationUnit, n2);
                Object var10_11 = null;
                if (iCompilationUnit2 == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var10_12 = null;
                    if (iCompilationUnit2 == null) break block4;
                    iCompilationUnit2.discardWorkingCopy();
                }
                throw throwable;
            }
            iCompilationUnit2.discardWorkingCopy();
        }
        return similarElementArray;
    }

    private static ICompilationUnit createPreparedCU(ICompilationUnit iCompilationUnit, Javadoc javadoc, int n) throws JavaModelException {
        int n2 = javadoc.getStartPosition();
        boolean bl = javadoc.getParent().getParent() instanceof CompilationUnit;
        char[] cArray = (char[])iCompilationUnit.getBuffer().getCharacters().clone();
        if (bl && n + 6 < cArray.length) {
            cArray[n2++] = 105;
            cArray[n2++] = 109;
            cArray[n2++] = 112;
            cArray[n2++] = 111;
            cArray[n2++] = 114;
            cArray[n2++] = 116;
        }
        if (n < cArray.length) {
            int n3 = n2;
            while (n3 < n) {
                cArray[n3] = 32;
                ++n3;
            }
        }
        ICompilationUnit iCompilationUnit2 = iCompilationUnit.getWorkingCopy(null);
        iCompilationUnit2.getBuffer().setContents(cArray);
        return iCompilationUnit2;
    }

    private SimilarElementsRequestor(String string, int n, int n2, String string2) {
        this.fName = string;
        this.fKind = n;
        this.fResult = new HashSet();
    }

    private void addResult(SimilarElement similarElement) {
        this.fResult.add(similarElement);
    }

    private SimilarElement[] process(ICompilationUnit iCompilationUnit, int n) throws JavaModelException {
        try {
            iCompilationUnit.codeComplete(n, (CompletionRequestor)this);
            this.processKeywords();
            SimilarElement[] similarElementArray = this.fResult.toArray(new SimilarElement[this.fResult.size()]);
            Object var3_4 = null;
            this.fResult.clear();
            return similarElementArray;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.fResult.clear();
            throw throwable;
        }
    }

    private boolean isKind(int n) {
        return (this.fKind & n) != 0;
    }

    private void processKeywords() {
        String string;
        if (this.isKind(64)) {
            int n = 0;
            while (n < PRIM_TYPES.length) {
                if (NameMatcher.isSimilarName(this.fName, PRIM_TYPES[n])) {
                    this.addResult(new SimilarElement(64, PRIM_TYPES[n], 50));
                }
                ++n;
            }
        }
        if (this.isKind(128) && NameMatcher.isSimilarName(this.fName, string = "void")) {
            this.addResult(new SimilarElement(64, string, 50));
        }
    }

    private static final int getKind(int n, char[] cArray) {
        if (Signature.getTypeSignatureKind((char[])cArray) == 3) {
            return 32;
        }
        if (Flags.isAnnotation((int)n)) {
            return 8;
        }
        if (Flags.isInterface((int)n)) {
            return 4;
        }
        if (Flags.isEnum((int)n)) {
            return 16;
        }
        return 2;
    }

    private void addType(char[] cArray, int n, int n2) {
        int n3 = SimilarElementsRequestor.getKind(n, cArray);
        if (!this.isKind(n3)) {
            return;
        }
        String string = new String(Signature.toCharArray((char[])Signature.getTypeErasure((char[])cArray)));
        if (TypeFilter.isFiltered(string)) {
            return;
        }
        if (NameMatcher.isSimilarName(this.fName, Signature.getSimpleName((String)string))) {
            this.addResult(new SimilarElement(n3, string, n2));
        }
    }

    public void accept(CompletionProposal completionProposal) {
        if (completionProposal.getKind() == 9) {
            this.addType(completionProposal.getSignature(), completionProposal.getFlags(), completionProposal.getRelevance());
        }
    }
}

