/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.java.CompletionProposalComputerDescriptor;
import org.eclipse.wst.jsdt.internal.ui.text.java.CompletionProposalComputerRegistry;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaTextMessages;
import org.eclipse.wst.jsdt.ui.text.java.ContentAssistInvocationContext;
import org.osgi.framework.Bundle;

public final class CompletionProposalCategory {
    private static final String ICON = "icon";
    private final String fId;
    private final String fName;
    private final IConfigurationElement fElement;
    private final ImageDescriptor fImage;
    private boolean fIsSeparateCommand = true;
    private boolean fIsEnabled = true;
    private boolean fIsIncluded = true;
    private final CompletionProposalComputerRegistry fRegistry;
    private int fSortOrder = 65536;
    private String fLastError = null;

    CompletionProposalCategory(IConfigurationElement iConfigurationElement, CompletionProposalComputerRegistry completionProposalComputerRegistry) {
        Bundle bundle;
        this.fElement = iConfigurationElement;
        this.fRegistry = completionProposalComputerRegistry;
        IExtension iExtension = (IExtension)iConfigurationElement.getParent();
        this.fId = iExtension.getUniqueIdentifier();
        this.checkNotNull(this.fId, "id");
        String string = iExtension.getLabel();
        this.fName = string == null ? this.fId : string;
        String string2 = iConfigurationElement.getAttribute(ICON);
        ImageDescriptor imageDescriptor = null;
        if (string2 != null && (bundle = this.getBundle()) != null) {
            Path path = new Path(string2);
            URL uRL = FileLocator.find((Bundle)bundle, (IPath)path, null);
            imageDescriptor = ImageDescriptor.createFromURL((URL)uRL);
        }
        this.fImage = imageDescriptor;
    }

    CompletionProposalCategory(String string, String string2, CompletionProposalComputerRegistry completionProposalComputerRegistry) {
        this.fRegistry = completionProposalComputerRegistry;
        this.fId = string;
        this.fName = string2;
        this.fElement = null;
        this.fImage = null;
    }

    private Bundle getBundle() {
        String string = this.fElement.getDeclaringExtension().getContributor().getName();
        Bundle bundle = Platform.getBundle((String)string);
        return bundle;
    }

    private void checkNotNull(Object object, String string) throws InvalidRegistryObjectException {
        if (object == null) {
            Object[] objectArray = new Object[]{this.getId(), this.fElement.getContributor().getName(), string};
            String string2 = Messages.format(JavaTextMessages.CompletionProposalComputerDescriptor_illegal_attribute_message, objectArray);
            Status status = new Status(2, JavaPlugin.getPluginId(), 0, string2, null);
            JavaPlugin.log((IStatus)status);
            throw new InvalidRegistryObjectException();
        }
    }

    public String getId() {
        return this.fId;
    }

    public String getName() {
        return this.fName;
    }

    public String getDisplayName() {
        return LegacyActionTools.removeMnemonics((String)this.fName);
    }

    public ImageDescriptor getImageDescriptor() {
        return this.fImage;
    }

    public void setSeparateCommand(boolean bl) {
        this.fIsSeparateCommand = bl;
    }

    public boolean isSeparateCommand() {
        return this.fIsSeparateCommand;
    }

    public void setIncluded(boolean bl) {
        this.fIsIncluded = bl;
    }

    public boolean isIncluded() {
        return this.fIsIncluded;
    }

    public boolean isEnabled() {
        return this.fIsEnabled;
    }

    public void setEnabled(boolean bl) {
        this.fIsEnabled = bl;
    }

    public boolean hasComputers() {
        List list = this.fRegistry.getProposalComputerDescriptors();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CompletionProposalComputerDescriptor completionProposalComputerDescriptor = (CompletionProposalComputerDescriptor)iterator.next();
            if (completionProposalComputerDescriptor.getCategory() != this) continue;
            return true;
        }
        return false;
    }

    public boolean hasComputers(String string) {
        List list = this.fRegistry.getProposalComputerDescriptors(string);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CompletionProposalComputerDescriptor completionProposalComputerDescriptor = (CompletionProposalComputerDescriptor)iterator.next();
            if (completionProposalComputerDescriptor.getCategory() != this) continue;
            return true;
        }
        return false;
    }

    public int getSortOrder() {
        return this.fSortOrder;
    }

    public void setSortOrder(int n) {
        this.fSortOrder = n;
    }

    public List computeCompletionProposals(ContentAssistInvocationContext contentAssistInvocationContext, String string, SubProgressMonitor subProgressMonitor) {
        this.fLastError = null;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList(this.fRegistry.getProposalComputerDescriptors(string));
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            CompletionProposalComputerDescriptor completionProposalComputerDescriptor = (CompletionProposalComputerDescriptor)iterator.next();
            if (completionProposalComputerDescriptor.getCategory() == this) {
                arrayList.addAll(completionProposalComputerDescriptor.computeCompletionProposals(contentAssistInvocationContext, (IProgressMonitor)subProgressMonitor));
            }
            if (this.fLastError != null) continue;
            this.fLastError = completionProposalComputerDescriptor.getErrorMessage();
        }
        return arrayList;
    }

    public List computeContextInformation(ContentAssistInvocationContext contentAssistInvocationContext, String string, SubProgressMonitor subProgressMonitor) {
        this.fLastError = null;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList(this.fRegistry.getProposalComputerDescriptors(string));
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            CompletionProposalComputerDescriptor completionProposalComputerDescriptor = (CompletionProposalComputerDescriptor)iterator.next();
            if (completionProposalComputerDescriptor.getCategory() == this) {
                arrayList.addAll(completionProposalComputerDescriptor.computeContextInformation(contentAssistInvocationContext, (IProgressMonitor)subProgressMonitor));
            }
            if (this.fLastError != null) continue;
            this.fLastError = completionProposalComputerDescriptor.getErrorMessage();
        }
        return arrayList;
    }

    public String getErrorMessage() {
        return this.fLastError;
    }

    public void sessionStarted() {
        ArrayList arrayList = new ArrayList(this.fRegistry.getProposalComputerDescriptors());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            CompletionProposalComputerDescriptor completionProposalComputerDescriptor = (CompletionProposalComputerDescriptor)iterator.next();
            if (completionProposalComputerDescriptor.getCategory() == this) {
                completionProposalComputerDescriptor.sessionStarted();
            }
            if (this.fLastError != null) continue;
            this.fLastError = completionProposalComputerDescriptor.getErrorMessage();
        }
    }

    public void sessionEnded() {
        ArrayList arrayList = new ArrayList(this.fRegistry.getProposalComputerDescriptors());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            CompletionProposalComputerDescriptor completionProposalComputerDescriptor = (CompletionProposalComputerDescriptor)iterator.next();
            if (completionProposalComputerDescriptor.getCategory() == this) {
                completionProposalComputerDescriptor.sessionEnded();
            }
            if (this.fLastError != null) continue;
            this.fLastError = completionProposalComputerDescriptor.getErrorMessage();
        }
    }
}

