/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaUIException;
import org.eclipse.wst.jsdt.internal.ui.JavaUIStatus;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaTextMessages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class ContentAssistHistory {
    private static final RHSHistory EMPTY_HISTORY = new RHSHistory(null);
    private static final int DEFAULT_TRACKED_LHS = 100;
    private static final int DEFAULT_TRACKED_RHS = 10;
    private static final Set UNCACHEABLE;
    private final LinkedHashMap fLHSCache;
    private final int fMaxLHS;
    private final int fMaxRHS;

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("java.lang.Object");
        hashSet.add("java.lang.Comparable");
        hashSet.add("java.io.Serializable");
        hashSet.add("java.io.Externalizable");
        UNCACHEABLE = Collections.unmodifiableSet(hashSet);
    }

    public ContentAssistHistory(int n, int n2) {
        Assert.isLegal((n > 0 ? 1 : 0) != 0);
        Assert.isLegal((n2 > 0 ? 1 : 0) != 0);
        this.fMaxLHS = n;
        this.fMaxRHS = n2;
        this.fLHSCache = new MRUMap(this.fMaxLHS);
    }

    public ContentAssistHistory() {
        this(100, 10);
    }

    public void remember(IType iType, IType iType2) {
        Assert.isLegal((iType != null ? 1 : 0) != 0);
        Assert.isLegal((iType2 != null ? 1 : 0) != 0);
        try {
            if (!this.isCacheableRHS(iType2)) {
                return;
            }
            ITypeHierarchy iTypeHierarchy = iType2.newSupertypeHierarchy(this.getProgressMonitor());
            if (iTypeHierarchy.contains(iType)) {
                IType[] iTypeArray = iTypeHierarchy.getAllSupertypes(iType);
                int n = 0;
                while (n < iTypeArray.length) {
                    this.rememberInternal(iTypeArray[n], iType2);
                    ++n;
                }
                this.rememberInternal(iType, iType2);
            }
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
        }
    }

    public RHSHistory getHistory(String string) {
        MRUSet mRUSet = (MRUSet)this.fLHSCache.get(string);
        if (mRUSet != null) {
            int n = mRUSet.size();
            LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>((int)((double)n / 0.75));
            int n2 = 1;
            Iterator iterator = mRUSet.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                linkedHashMap.put(string2, new Integer(n2));
                ++n2;
            }
            return new RHSHistory(linkedHashMap);
        }
        return EMPTY_HISTORY;
    }

    public Map getEntireHistory() {
        HashMap<String, RHSHistory> hashMap = new HashMap<String, RHSHistory>((int)((double)this.fLHSCache.size() / 0.75));
        Iterator iterator = this.fLHSCache.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            hashMap.put(string, this.getHistory(string));
        }
        return Collections.unmodifiableMap(hashMap);
    }

    private void rememberInternal(IType iType, IType iType2) throws JavaModelException {
        if (this.isCacheableLHS(iType)) {
            this.getCache(iType.getFullyQualifiedName()).add(iType2.getFullyQualifiedName());
        }
    }

    private boolean isCacheableLHS(IType iType) throws JavaModelException {
        return !Flags.isFinal((int)iType.getFlags()) && !UNCACHEABLE.contains(iType.getFullyQualifiedName());
    }

    private boolean isCacheableRHS(IType iType) throws JavaModelException {
        return !iType.isInterface() && !Flags.isAbstract((int)iType.getFlags());
    }

    private Set getCache(String string) {
        MRUSet mRUSet = (MRUSet)this.fLHSCache.get(string);
        if (mRUSet == null) {
            mRUSet = new MRUSet(this.fMaxRHS);
            this.fLHSCache.put(string, mRUSet);
        }
        return mRUSet;
    }

    private IProgressMonitor getProgressMonitor() {
        return new NullProgressMonitor();
    }

    public static void store(ContentAssistHistory contentAssistHistory, Preferences preferences, String string) throws CoreException {
        StringWriter stringWriter = new StringWriter();
        new ReaderWriter().store(contentAssistHistory, new StreamResult(stringWriter));
        preferences.setValue(string, stringWriter.toString());
    }

    public static ContentAssistHistory load(Preferences preferences, String string) throws CoreException {
        String string2 = preferences.getString(string);
        if (string2 != null && string2.length() > 0) {
            return new ReaderWriter().load(new InputSource(new StringReader(string2)));
        }
        return null;
    }

    private static final class MRUMap
    extends LinkedHashMap {
        private static final long serialVersionUID = 1L;
        private final int fMaxSize;

        public MRUMap(int n) {
            Assert.isLegal((n > 0 ? 1 : 0) != 0);
            this.fMaxSize = n;
        }

        public Object put(Object object, Object object2) {
            Object v = this.remove(object);
            super.put(object, object2);
            return v;
        }

        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > this.fMaxSize;
        }
    }

    private static final class MRUSet
    extends LinkedHashSet {
        private static final long serialVersionUID = 1L;
        private final int fMaxSize;

        public MRUSet(int n) {
            Assert.isLegal((n > 0 ? 1 : 0) != 0);
            this.fMaxSize = n;
        }

        public boolean add(Object object) {
            if (this.remove(object)) {
                super.add(object);
                return false;
            }
            if (this.size() >= this.fMaxSize) {
                this.remove(this.iterator().next());
            }
            super.add(object);
            return true;
        }
    }

    public static final class RHSHistory {
        private final LinkedHashMap fHistory;
        private List fList;

        RHSHistory(LinkedHashMap linkedHashMap) {
            this.fHistory = linkedHashMap;
        }

        public float getRank(String string) {
            if (this.fHistory == null) {
                return 0.0f;
            }
            Integer n = (Integer)this.fHistory.get(string);
            return n == null ? 0.0f : n.floatValue() / (float)this.fHistory.size();
        }

        public int size() {
            return this.fHistory == null ? 0 : this.fHistory.size();
        }

        public List getTypes() {
            if (this.fHistory == null) {
                return Collections.EMPTY_LIST;
            }
            if (this.fList == null) {
                this.fList = Collections.unmodifiableList(new ArrayList(this.fHistory.keySet()));
            }
            return this.fList;
        }
    }

    private static final class ReaderWriter {
        private static final String NODE_ROOT = "history";
        private static final String NODE_LHS = "lhs";
        private static final String NODE_RHS = "rhs";
        private static final String ATTRIBUTE_NAME = "name";
        private static final String ATTRIBUTE_MAX_LHS = "maxLHS";
        private static final String ATTRIBUTE_MAX_RHS = "maxRHS";

        private ReaderWriter() {
        }

        public void store(ContentAssistHistory contentAssistHistory, StreamResult streamResult) throws CoreException {
            try {
                Object object;
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.newDocument();
                Element element = document.createElement(NODE_ROOT);
                element.setAttribute(ATTRIBUTE_MAX_LHS, Integer.toString(contentAssistHistory.fMaxLHS));
                element.setAttribute(ATTRIBUTE_MAX_RHS, Integer.toString(contentAssistHistory.fMaxRHS));
                document.appendChild(element);
                Object object2 = contentAssistHistory.fLHSCache.keySet().iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    Element element2 = document.createElement(NODE_LHS);
                    element2.setAttribute(ATTRIBUTE_NAME, (String)object);
                    element.appendChild(element2);
                    Set set = (Set)contentAssistHistory.fLHSCache.get(object);
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        Element element3 = document.createElement(NODE_RHS);
                        element3.setAttribute(ATTRIBUTE_NAME, string);
                        element2.appendChild(element3);
                    }
                }
                object2 = TransformerFactory.newInstance().newTransformer();
                ((Transformer)object2).setOutputProperty("method", "xml");
                ((Transformer)object2).setOutputProperty("encoding", "UTF-8");
                ((Transformer)object2).setOutputProperty("indent", "no");
                object = new DOMSource(document);
                ((Transformer)object2).transform((Source)object, streamResult);
            }
            catch (TransformerException transformerException) {
                throw this.createException(transformerException, JavaTextMessages.ContentAssistHistory_serialize_error);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw this.createException(parserConfigurationException, JavaTextMessages.ContentAssistHistory_serialize_error);
            }
        }

        public ContentAssistHistory load(InputSource inputSource) throws CoreException {
            Element element;
            try {
                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                element = documentBuilder.parse(inputSource).getDocumentElement();
            }
            catch (SAXException sAXException) {
                throw this.createException(sAXException, JavaTextMessages.ContentAssistHistory_deserialize_error);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw this.createException(parserConfigurationException, JavaTextMessages.ContentAssistHistory_deserialize_error);
            }
            catch (IOException iOException) {
                throw this.createException(iOException, JavaTextMessages.ContentAssistHistory_deserialize_error);
            }
            if (element == null || !element.getNodeName().equalsIgnoreCase(NODE_ROOT)) {
                return null;
            }
            int n = this.parseNaturalInt(element.getAttribute(ATTRIBUTE_MAX_LHS), 100);
            int n2 = this.parseNaturalInt(element.getAttribute(ATTRIBUTE_MAX_RHS), 10);
            ContentAssistHistory contentAssistHistory = new ContentAssistHistory(n, n2);
            NodeList nodeList = element.getChildNodes();
            int n3 = nodeList.getLength();
            int n4 = 0;
            while (n4 < n3) {
                String string;
                Element element2;
                Node node = nodeList.item(n4);
                if (node.getNodeType() == 1 && (element2 = (Element)node).getNodeName().equalsIgnoreCase(NODE_LHS) && (string = element2.getAttribute(ATTRIBUTE_NAME)) != null) {
                    Set set = contentAssistHistory.getCache(string);
                    NodeList nodeList2 = element2.getChildNodes();
                    int n5 = nodeList2.getLength();
                    int n6 = 0;
                    while (n6 < n5) {
                        String string2;
                        Element element3;
                        Node node2 = nodeList2.item(n6);
                        if (node2.getNodeType() == 1 && (element3 = (Element)node2).getNodeName().equalsIgnoreCase(NODE_RHS) && (string2 = element3.getAttribute(ATTRIBUTE_NAME)) != null) {
                            set.add(string2);
                        }
                        ++n6;
                    }
                }
                ++n4;
            }
            return contentAssistHistory;
        }

        private int parseNaturalInt(String string, int n) {
            try {
                int n2 = Integer.parseInt(string);
                if (n2 > 0) {
                    return n2;
                }
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                return n;
            }
        }

        private JavaUIException createException(Exception exception, String string) {
            return new JavaUIException(JavaUIStatus.createError(4, string, exception));
        }
    }
}

