/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.wst.jsdt.internal.ui.text.AbstractJavaScanner;
import org.eclipse.wst.jsdt.internal.ui.text.CombinedWordRule;
import org.eclipse.wst.jsdt.internal.ui.text.ISourceVersionDependent;
import org.eclipse.wst.jsdt.internal.ui.text.JavaWhitespaceDetector;
import org.eclipse.wst.jsdt.internal.ui.text.JavaWordDetector;
import org.eclipse.wst.jsdt.ui.text.IColorManager;

public final class JavaCodeScanner
extends AbstractJavaScanner {
    private static final String SOURCE_VERSION = "org.eclipse.wst.jsdt.core.compiler.source";
    static String[] fgKeywords = new String[]{"abstract", "break", "case", "catch", "class", "const", "continue", "default", "delete", "debugger", "do", "else", "export", "extends", "final", "finally", "for", "function", "goto", "if", "implements", "in", "instanceof", "interface", "new", "package", "private", "protected", "public", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "typeof", "var", "volatile", "while"};
    private static final String INTERFACE = "interface";
    private static final String RETURN = "return";
    private static String[] fgJava14Keywords = new String[0];
    private static String[] fgJava15Keywords = new String[]{"enum"};
    private static String[] fgTypes = new String[0];
    private static String[] fgConstants = new String[]{"false", "null", "true", "undefined"};
    private static final String ANNOTATION_BASE_KEY = "semanticHighlighting.annotation";
    private static final String ANNOTATION_COLOR_KEY = "semanticHighlighting.annotation.color";
    private static String[] fgTokenProperties = new String[]{"java_keyword", "java_string", "java_default", "java_keyword_return", "java_operator", "java_bracket", "semanticHighlighting.annotation.color"};
    private List fVersionDependentRules = new ArrayList(3);

    public JavaCodeScanner(IColorManager iColorManager, IPreferenceStore iPreferenceStore) {
        super(iColorManager, iPreferenceStore);
        this.initialize();
    }

    protected String[] getTokenProperties() {
        return fgTokenProperties;
    }

    protected List createRules() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Token token = this.getToken("java_string");
        arrayList.add(new SingleLineRule("'", "'", (IToken)token, '\\'));
        arrayList.add(new WhitespaceRule((IWhitespaceDetector)new JavaWhitespaceDetector()));
        String string = this.getPreferenceStore().getString(SOURCE_VERSION);
        JavaWordDetector javaWordDetector = new JavaWordDetector();
        token = this.getToken("java_default");
        CombinedWordRule combinedWordRule = new CombinedWordRule((IWordDetector)javaWordDetector, (IToken)token);
        token = this.getToken("java_default");
        VersionedWordMatcher versionedWordMatcher = new VersionedWordMatcher((IToken)token, "1.4", string);
        token = this.getToken("java_keyword");
        int n = 0;
        while (n < fgJava14Keywords.length) {
            versionedWordMatcher.addWord(fgJava14Keywords[n], (IToken)token);
            ++n;
        }
        combinedWordRule.addWordMatcher(versionedWordMatcher);
        this.fVersionDependentRules.add(versionedWordMatcher);
        token = this.getToken("java_default");
        VersionedWordMatcher versionedWordMatcher2 = new VersionedWordMatcher((IToken)token, "1.5", string);
        token = this.getToken("java_keyword");
        int n2 = 0;
        while (n2 < fgJava15Keywords.length) {
            versionedWordMatcher2.addWord(fgJava15Keywords[n2], (IToken)token);
            ++n2;
        }
        combinedWordRule.addWordMatcher(versionedWordMatcher2);
        this.fVersionDependentRules.add(versionedWordMatcher2);
        token = this.getToken("java_operator");
        arrayList.add(new OperatorRule((IToken)token));
        token = this.getToken("java_bracket");
        arrayList.add(new BracketRule((IToken)token));
        CombinedWordRule.WordMatcher wordMatcher = new CombinedWordRule.WordMatcher();
        token = this.getToken("java_keyword_return");
        wordMatcher.addWord(RETURN, (IToken)token);
        combinedWordRule.addWordMatcher(wordMatcher);
        CombinedWordRule.WordMatcher wordMatcher2 = new CombinedWordRule.WordMatcher();
        token = this.getToken("java_keyword");
        int n3 = 0;
        while (n3 < fgKeywords.length) {
            wordMatcher2.addWord(fgKeywords[n3], (IToken)token);
            ++n3;
        }
        n3 = 0;
        while (n3 < fgTypes.length) {
            wordMatcher2.addWord(fgTypes[n3], (IToken)token);
            ++n3;
        }
        n3 = 0;
        while (n3 < fgConstants.length) {
            wordMatcher2.addWord(fgConstants[n3], (IToken)token);
            ++n3;
        }
        combinedWordRule.addWordMatcher(wordMatcher2);
        arrayList.add(combinedWordRule);
        this.setDefaultReturnToken((IToken)this.getToken("java_default"));
        return arrayList;
    }

    protected String getBoldKey(String string) {
        if (ANNOTATION_COLOR_KEY.equals(string)) {
            return "semanticHighlighting.annotation.bold";
        }
        return super.getBoldKey(string);
    }

    protected String getItalicKey(String string) {
        if (ANNOTATION_COLOR_KEY.equals(string)) {
            return "semanticHighlighting.annotation.italic";
        }
        return super.getItalicKey(string);
    }

    protected String getStrikethroughKey(String string) {
        if (ANNOTATION_COLOR_KEY.equals(string)) {
            return "semanticHighlighting.annotation.strikethrough";
        }
        return super.getStrikethroughKey(string);
    }

    protected String getUnderlineKey(String string) {
        if (ANNOTATION_COLOR_KEY.equals(string)) {
            return "semanticHighlighting.annotation.underline";
        }
        return super.getUnderlineKey(string);
    }

    public boolean affectsBehavior(PropertyChangeEvent propertyChangeEvent) {
        return propertyChangeEvent.getProperty().equals(SOURCE_VERSION) || super.affectsBehavior(propertyChangeEvent);
    }

    public void adaptToPreferenceChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().equals(SOURCE_VERSION)) {
            Object object = propertyChangeEvent.getNewValue();
            if (object instanceof String) {
                String string = (String)object;
                Iterator iterator = this.fVersionDependentRules.iterator();
                while (iterator.hasNext()) {
                    ISourceVersionDependent iSourceVersionDependent = (ISourceVersionDependent)iterator.next();
                    iSourceVersionDependent.setSourceVersion(string);
                }
            }
        } else if (super.affectsBehavior(propertyChangeEvent)) {
            super.adaptToPreferenceChange(propertyChangeEvent);
        }
    }

    private static final class BracketRule
    implements IRule {
        private final char[] JAVA_BRACKETS = new char[]{'(', ')', '{', '}', '[', ']'};
        private final IToken fToken;

        public BracketRule(IToken iToken) {
            this.fToken = iToken;
        }

        public boolean isBracket(char c) {
            int n = 0;
            while (n < this.JAVA_BRACKETS.length) {
                if (this.JAVA_BRACKETS[n] == c) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public IToken evaluate(ICharacterScanner iCharacterScanner) {
            int n = iCharacterScanner.read();
            if (this.isBracket((char)n)) {
                while (this.isBracket((char)(n = iCharacterScanner.read()))) {
                }
                iCharacterScanner.unread();
                return this.fToken;
            }
            iCharacterScanner.unread();
            return Token.UNDEFINED;
        }
    }

    private static final class OperatorRule
    implements IRule {
        private final char[] JAVA_OPERATORS = new char[]{';', '.', '=', '/', '\\', '+', '-', '*', '<', '>', ':', '?', '!', ',', '|', '&', '^', '%', '~'};
        private final IToken fToken;

        public OperatorRule(IToken iToken) {
            this.fToken = iToken;
        }

        public boolean isOperator(char c) {
            int n = 0;
            while (n < this.JAVA_OPERATORS.length) {
                if (this.JAVA_OPERATORS[n] == c) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public IToken evaluate(ICharacterScanner iCharacterScanner) {
            int n = iCharacterScanner.read();
            if (this.isOperator((char)n)) {
                while (this.isOperator((char)(n = iCharacterScanner.read()))) {
                }
                iCharacterScanner.unread();
                return this.fToken;
            }
            iCharacterScanner.unread();
            return Token.UNDEFINED;
        }
    }

    private static class VersionedWordMatcher
    extends CombinedWordRule.WordMatcher
    implements ISourceVersionDependent {
        private final IToken fDefaultToken;
        private final String fVersion;
        private boolean fIsVersionMatch;

        public VersionedWordMatcher(IToken iToken, String string, String string2) {
            this.fDefaultToken = iToken;
            this.fVersion = string;
            this.setSourceVersion(string2);
        }

        public void setSourceVersion(String string) {
            this.fIsVersionMatch = this.fVersion.compareTo(string) <= 0;
        }

        public IToken evaluate(ICharacterScanner iCharacterScanner, CombinedWordRule.CharacterBuffer characterBuffer) {
            IToken iToken = super.evaluate(iCharacterScanner, characterBuffer);
            if (this.fIsVersionMatch || iToken.isUndefined()) {
                return iToken;
            }
            return this.fDefaultToken;
        }
    }
}

