/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.wst.jsdt.core.CompletionProposal;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.util.QualifiedTypeNameHistory;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.text.java.LazyJavaCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.ProposalContextInformation;
import org.eclipse.wst.jsdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.wst.jsdt.internal.ui.text.java.TypeProposalInfo;
import org.eclipse.wst.jsdt.ui.text.java.JavaContentAssistInvocationContext;

public class LazyJavaTypeCompletionProposal
extends LazyJavaCompletionProposal {
    protected static final char[] TYPE_TRIGGERS = new char[]{'.', '\t', '[', '(', ' '};
    protected static final char[] JDOC_TYPE_TRIGGERS = new char[]{'#', '}', ' ', '.'};
    protected final ICompilationUnit fCompilationUnit;
    private String fQualifiedName;
    private String fSimpleName;
    private ImportRewrite fImportRewrite;
    private ContextSensitiveImportRewriteContext fImportContext;

    public LazyJavaTypeCompletionProposal(CompletionProposal completionProposal, JavaContentAssistInvocationContext javaContentAssistInvocationContext) {
        super(completionProposal, javaContentAssistInvocationContext);
        this.fCompilationUnit = javaContentAssistInvocationContext.getCompilationUnit();
        this.fQualifiedName = null;
    }

    public final String getQualifiedTypeName() {
        if (this.fQualifiedName == null) {
            this.fQualifiedName = String.valueOf(Signature.toCharArray((char[])Signature.getTypeErasure((char[])this.fProposal.getSignature())));
        }
        return this.fQualifiedName;
    }

    protected final String getSimpleTypeName() {
        if (this.fSimpleName == null) {
            this.fSimpleName = Signature.getSimpleName((String)this.getQualifiedTypeName());
        }
        return this.fSimpleName;
    }

    protected String computeReplacementString() {
        String string = super.computeReplacementString();
        return string;
    }

    protected final boolean isImportCompletion() {
        char[] cArray = this.fProposal.getCompletion();
        if (cArray.length == 0) {
            return false;
        }
        char c = cArray[cArray.length - 1];
        return c == ';' || c == '.';
    }

    private ImportRewrite createImportRewrite() {
        if (this.fCompilationUnit != null && this.allowAddingImports()) {
            try {
                CompilationUnit compilationUnit = this.getASTRoot(this.fCompilationUnit);
                if (compilationUnit == null) {
                    ImportRewrite importRewrite = StubUtility.createImportRewrite(this.fCompilationUnit, true);
                    this.fImportContext = null;
                    return importRewrite;
                }
                ImportRewrite importRewrite = StubUtility.createImportRewrite(compilationUnit, true);
                this.fImportContext = new ContextSensitiveImportRewriteContext(compilationUnit, this.fInvocationContext.getInvocationOffset(), importRewrite);
                return importRewrite;
            }
            catch (CoreException coreException) {
                JavaPlugin.log(coreException);
            }
        }
        return null;
    }

    private CompilationUnit getASTRoot(ICompilationUnit iCompilationUnit) {
        return JavaPlugin.getDefault().getASTProvider().getAST((IJavaElement)iCompilationUnit, ASTProvider.WAIT_NO, (IProgressMonitor)new NullProgressMonitor());
    }

    public void apply(IDocument iDocument, char c, int n) {
        try {
            boolean bl;
            boolean bl2 = bl = c == '(' && this.autocloseBrackets();
            if (bl) {
                StringBuffer stringBuffer = new StringBuffer(this.getReplacementString());
                this.updateReplacementWithParentheses(stringBuffer);
                this.setReplacementString(stringBuffer.toString());
                c = '\u0000';
            }
            super.apply(iDocument, c, n);
            if (this.fImportRewrite != null && this.fImportRewrite.hasRecordedChanges()) {
                int n2 = iDocument.getLength();
                this.fImportRewrite.rewriteImports((IProgressMonitor)new NullProgressMonitor()).apply(iDocument, 2);
                this.setReplacementOffset(this.getReplacementOffset() + iDocument.getLength() - n2);
            }
            if (bl) {
                this.setUpLinkedMode(iDocument, ')');
            }
            this.rememberSelection();
        }
        catch (CoreException coreException) {
            JavaPlugin.log(coreException);
        }
        catch (BadLocationException badLocationException) {
            JavaPlugin.log(badLocationException);
        }
    }

    protected void updateReplacementWithParentheses(StringBuffer stringBuffer) {
        LazyJavaCompletionProposal.FormatterPrefs formatterPrefs = this.getFormatterPrefs();
        if (formatterPrefs.beforeOpeningParen) {
            stringBuffer.append(" ");
        }
        stringBuffer.append("(");
        if (formatterPrefs.afterOpeningParen) {
            stringBuffer.append(" ");
        }
        this.setCursorPosition(stringBuffer.length());
        if (formatterPrefs.afterOpeningParen) {
            stringBuffer.append(" ");
        }
        stringBuffer.append(")");
    }

    protected final void rememberSelection() throws JavaModelException {
        IType iType = this.fInvocationContext.getExpectedType();
        IType iType2 = (IType)this.getJavaElement();
        if (iType != null && iType2 != null) {
            JavaPlugin.getDefault().getContentAssistHistory().remember(iType, iType2);
        }
        QualifiedTypeNameHistory.remember(this.getQualifiedTypeName());
    }

    protected boolean allowAddingImports() {
        if (this.isInJavadoc()) {
            if (this.fProposal.getKind() == 9 && this.fInvocationContext.getCoreContext().isInJavadocText()) {
                return false;
            }
            if (!this.isJavadocProcessingEnabled()) {
                return false;
            }
        }
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        return iPreferenceStore.getBoolean("content_assist_add_import");
    }

    private boolean isJavadocProcessingEnabled() {
        IJavaProject iJavaProject = this.fCompilationUnit.getJavaProject();
        boolean bl = iJavaProject == null ? "enabled".equals(JavaCore.getOption((String)"org.eclipse.wst.jsdt.core.compiler.doc.comment.support")) : "enabled".equals(iJavaProject.getOption("org.eclipse.wst.jsdt.core.compiler.doc.comment.support", true));
        return bl;
    }

    protected boolean isValidPrefix(String string) {
        return this.isPrefix(string, this.getSimpleTypeName()) || this.isPrefix(string, this.getQualifiedTypeName());
    }

    public CharSequence getPrefixCompletionText(IDocument iDocument, int n) {
        String string = this.getPrefix(iDocument, n);
        String string2 = string.indexOf(46) != -1 ? this.getQualifiedTypeName() : this.getSimpleTypeName();
        if (this.isCamelCaseMatching()) {
            return this.getCamelCaseCompound(string, string2);
        }
        return string2;
    }

    protected char[] computeTriggerCharacters() {
        return this.isInJavadoc() ? JDOC_TYPE_TRIGGERS : TYPE_TRIGGERS;
    }

    protected ProposalInfo computeProposalInfo() {
        IJavaProject iJavaProject;
        if (this.fCompilationUnit != null && (iJavaProject = this.fCompilationUnit.getJavaProject()) != null) {
            return new TypeProposalInfo(iJavaProject, this.fProposal);
        }
        return super.computeProposalInfo();
    }

    protected String computeSortString() {
        return String.valueOf(this.getSimpleTypeName()) + '\u0000' + this.getQualifiedTypeName();
    }

    protected int computeRelevance() {
        float f = this.fInvocationContext.getHistoryRelevance(this.getQualifiedTypeName());
        float f2 = QualifiedTypeNameHistory.getDefault().getNormalizedPosition(this.getQualifiedTypeName());
        int n = Math.round((f + f2) * 5.0f);
        int n2 = f > 0.0f ? 50 : 0;
        int n3 = super.computeRelevance();
        return n3 + n2 + n;
    }

    protected IContextInformation computeContextInformation() {
        char[] cArray = this.fProposal.getSignature();
        char[][] cArray2 = Signature.getTypeArguments((char[])cArray);
        if (cArray2.length == 0) {
            return super.computeContextInformation();
        }
        ProposalContextInformation proposalContextInformation = new ProposalContextInformation(this.fProposal);
        if (this.fContextInformationPosition != 0 && this.fProposal.getCompletion().length == 0) {
            proposalContextInformation.setContextInformationPosition(this.fContextInformationPosition);
        }
        return proposalContextInformation;
    }
}

