/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaConventions;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.wst.jsdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaTextMessages;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaTypeCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.wst.jsdt.ui.CodeGeneration;
import org.eclipse.wst.jsdt.ui.JavaElementImageDescriptor;

public class MethodDeclarationCompletionProposal
extends JavaTypeCompletionProposal
implements ICompletionProposalExtension4 {
    private final IType fType;
    private final String fReturnTypeSig;
    private final String fMethodName;

    public static void evaluateProposals(IType iType, String string, int n, int n2, int n3, Set set, Collection collection) throws CoreException {
        String string2;
        IMethod[] iMethodArray = iType.getMethods();
        if (!iType.isInterface() && (string2 = iType.getElementName()).length() > 0 && string2.startsWith(string) && !MethodDeclarationCompletionProposal.hasMethod(iMethodArray, string2) && set.add(string2)) {
            collection.add(new MethodDeclarationCompletionProposal(iType, string2, null, n, n2, n3 + 500));
        }
        if (string.length() > 0 && !"main".equals(string) && !MethodDeclarationCompletionProposal.hasMethod(iMethodArray, string) && set.add(string) && !JavaConventions.validateMethodName((String)string).matches(4)) {
            collection.add(new MethodDeclarationCompletionProposal(iType, string, "V", n, n2, n3));
        }
    }

    private static boolean hasMethod(IMethod[] iMethodArray, String string) {
        int n = 0;
        while (n < iMethodArray.length) {
            IMethod iMethod = iMethodArray[n];
            if (iMethod.getElementName().equals(string) && iMethod.getParameterTypes().length == 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public MethodDeclarationCompletionProposal(IType iType, String string, String string2, int n, int n2, int n3) {
        super("", iType.getCompilationUnit(), n, n2, null, MethodDeclarationCompletionProposal.getDisplayName(string, string2), n3);
        Assert.isNotNull((Object)iType);
        Assert.isNotNull((Object)string);
        this.fType = iType;
        this.fMethodName = string;
        this.fReturnTypeSig = string2;
        if (string2 == null) {
            this.setProposalInfo(new ProposalInfo((IMember)iType));
            JavaElementImageDescriptor javaElementImageDescriptor = new JavaElementImageDescriptor(JavaPluginImages.DESC_MISC_PUBLIC, 512, JavaElementImageProvider.SMALL_SIZE);
            this.setImage(JavaPlugin.getImageDescriptorRegistry().get((ImageDescriptor)javaElementImageDescriptor));
        } else {
            this.setImage(JavaPluginImages.get("org.eclipse.wst.jsdt.ui.methpri_obj.gif"));
        }
    }

    private static String getDisplayName(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append('(');
        stringBuffer.append(')');
        if (string2 != null) {
            stringBuffer.append("  ");
            stringBuffer.append(Signature.toString((String)string2));
            stringBuffer.append(" - ");
            stringBuffer.append(JavaTextMessages.MethodCompletionProposal_method_label);
        } else {
            stringBuffer.append(" - ");
            stringBuffer.append(JavaTextMessages.MethodCompletionProposal_constructor_label);
        }
        return stringBuffer.toString();
    }

    protected boolean updateReplacementString(IDocument iDocument, char c, int n, ImportRewrite importRewrite) throws CoreException, BadLocationException {
        String string;
        CodeGenerationSettings codeGenerationSettings = JavaPreferencesSettings.getCodeGenerationSettings(this.fType.getJavaProject());
        boolean bl = codeGenerationSettings.createComments;
        String[] stringArray = new String[]{};
        String string2 = TextUtilities.getDefaultLineDelimiter((IDocument)iDocument);
        String string3 = this.fType.getTypeQualifiedName('.');
        boolean bl2 = this.fType.isInterface();
        StringBuffer stringBuffer = new StringBuffer();
        if (bl && (string = CodeGeneration.getMethodComment(this.fType.getCompilationUnit(), string3, this.fMethodName, stringArray, stringArray, this.fReturnTypeSig, stringArray, null, string2)) != null) {
            stringBuffer.append(string);
            stringBuffer.append(string2);
        }
        if (this.fReturnTypeSig != null) {
            if (!bl2) {
                stringBuffer.append("private ");
            }
        } else {
            stringBuffer.append("public ");
        }
        if (this.fReturnTypeSig != null) {
            stringBuffer.append(Signature.toString((String)this.fReturnTypeSig));
        }
        stringBuffer.append(' ');
        stringBuffer.append(this.fMethodName);
        if (bl2) {
            stringBuffer.append("();");
            stringBuffer.append(string2);
        } else {
            stringBuffer.append("() {");
            stringBuffer.append(string2);
            string = CodeGeneration.getMethodBodyContent(this.fType.getCompilationUnit(), string3, this.fMethodName, this.fReturnTypeSig == null, "", string2);
            if (string != null) {
                stringBuffer.append(string);
                stringBuffer.append(string2);
            }
            stringBuffer.append("}");
            stringBuffer.append(string2);
        }
        string = stringBuffer.toString();
        IRegion iRegion = iDocument.getLineInformationOfOffset(this.getReplacementOffset());
        int n2 = iRegion.getOffset();
        int n3 = Strings.computeIndentUnits(iDocument.get(n2, this.getReplacementOffset() - n2), codeGenerationSettings.tabWidth, codeGenerationSettings.indentWidth);
        String string4 = CodeFormatterUtil.format(4, string, n3, null, string2, this.fType.getJavaProject());
        if (string4.endsWith(string2)) {
            string4 = string4.substring(0, string4.length() - string2.length());
        }
        this.setReplacementString(Strings.trimLeadingTabsAndSpaces(string4));
        return true;
    }

    public CharSequence getPrefixCompletionText(IDocument iDocument, int n) {
        return new String();
    }

    public boolean isAutoInsertable() {
        return false;
    }
}

