/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java.hover;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.java.hover.AbstractJavaEditorTextHover;
import org.eclipse.wst.jsdt.internal.ui.text.java.hover.JavaEditorTextHoverDescriptor;
import org.eclipse.wst.jsdt.ui.text.java.hover.IJavaEditorTextHover;

public class BestMatchHover
extends AbstractJavaEditorTextHover
implements ITextHoverExtension,
IInformationProviderExtension2 {
    private List fTextHoverSpecifications;
    private List fInstantiatedTextHovers;
    private ITextHover fBestHover;

    public BestMatchHover() {
        this.installTextHovers();
    }

    public BestMatchHover(IEditorPart iEditorPart) {
        this();
        this.setEditor(iEditorPart);
    }

    private void installTextHovers() {
        this.fTextHoverSpecifications = new ArrayList(2);
        this.fInstantiatedTextHovers = new ArrayList(2);
        JavaEditorTextHoverDescriptor[] javaEditorTextHoverDescriptorArray = JavaPlugin.getDefault().getJavaEditorTextHoverDescriptors();
        int n = 0;
        while (n < javaEditorTextHoverDescriptorArray.length) {
            if (!"org.eclipse.wst.jsdt.ui.BestMatchHover".equals(javaEditorTextHoverDescriptorArray[n].getId())) {
                this.fTextHoverSpecifications.add(javaEditorTextHoverDescriptorArray[n]);
            }
            ++n;
        }
    }

    private void checkTextHovers() {
        if (this.fTextHoverSpecifications.size() == 0) {
            return;
        }
        Iterator iterator = new ArrayList(this.fTextHoverSpecifications).iterator();
        while (iterator.hasNext()) {
            JavaEditorTextHoverDescriptor javaEditorTextHoverDescriptor = (JavaEditorTextHoverDescriptor)iterator.next();
            IJavaEditorTextHover iJavaEditorTextHover = javaEditorTextHoverDescriptor.createTextHover();
            if (iJavaEditorTextHover == null) continue;
            iJavaEditorTextHover.setEditor(this.getEditor());
            this.addTextHover(iJavaEditorTextHover);
            this.fTextHoverSpecifications.remove(javaEditorTextHoverDescriptor);
        }
    }

    protected void addTextHover(ITextHover iTextHover) {
        if (!this.fInstantiatedTextHovers.contains(iTextHover)) {
            this.fInstantiatedTextHovers.add(iTextHover);
        }
    }

    public String getHoverInfo(ITextViewer iTextViewer, IRegion iRegion) {
        this.checkTextHovers();
        this.fBestHover = null;
        if (this.fInstantiatedTextHovers == null) {
            return null;
        }
        Iterator iterator = this.fInstantiatedTextHovers.iterator();
        while (iterator.hasNext()) {
            ITextHover iTextHover = (ITextHover)iterator.next();
            String string = iTextHover.getHoverInfo(iTextViewer, iRegion);
            if (string == null || string.trim().length() <= 0) continue;
            this.fBestHover = iTextHover;
            return string;
        }
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.fBestHover instanceof ITextHoverExtension) {
            return ((ITextHoverExtension)this.fBestHover).getHoverControlCreator();
        }
        return null;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fBestHover instanceof IInformationProviderExtension2) {
            return ((IInformationProviderExtension2)this.fBestHover).getInformationPresenterControlCreator();
        }
        return null;
    }
}

