/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.spelling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.SpellCheckEngine;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.ISpellCheckEngine;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.ISpellChecker;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.RankedWordProposal;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;
import org.eclipse.wst.jsdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposalComputer;

public final class WordCompletionProposalComputer
implements IJavaCompletionProposalComputer {
    private static final int PREFIX_RANK_SHIFT = 500;

    public List computeCompletionProposals(ContentAssistInvocationContext contentAssistInvocationContext, IProgressMonitor iProgressMonitor) {
        if (this.contributes()) {
            try {
                ISpellCheckEngine iSpellCheckEngine;
                ISpellChecker iSpellChecker;
                IDocument iDocument = contentAssistInvocationContext.getDocument();
                final int n = contentAssistInvocationContext.getInvocationOffset();
                IRegion iRegion = iDocument.getLineInformationOfOffset(n);
                String string = iDocument.get(iRegion.getOffset(), iRegion.getLength());
                int n2 = n - iRegion.getOffset() - 1;
                while (n2 >= 0 && Character.isLetter(string.charAt(n2))) {
                    --n2;
                }
                int n3 = iRegion.getOffset() + n2 + 1;
                String string2 = string.substring(n2 + 1, n - iRegion.getOffset());
                if (string2.length() > 0 && (iSpellChecker = (iSpellCheckEngine = SpellCheckEngine.getInstance()).getSpellChecker()) != null) {
                    ArrayList arrayList = new ArrayList(iSpellChecker.getProposals(string2, Character.isUpperCase(string2.charAt(0))));
                    ArrayList<1> arrayList2 = new ArrayList<1>(arrayList.size());
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        RankedWordProposal rankedWordProposal = (RankedWordProposal)iterator.next();
                        String string3 = rankedWordProposal.getText();
                        if (string3.startsWith(string2)) {
                            rankedWordProposal.setRank(rankedWordProposal.getRank() + 500);
                        }
                        arrayList2.add(new JavaCompletionProposal(string3, n3, string2.length(), JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_rename.gif"), string3, rankedWordProposal.getRank()){

                            public boolean validate(IDocument iDocument, int n2, DocumentEvent documentEvent) {
                                return n == n2;
                            }
                        });
                    }
                    return arrayList2;
                }
            }
            catch (BadLocationException badLocationException) {
                JavaPlugin.log(badLocationException);
            }
        }
        return Collections.EMPTY_LIST;
    }

    private boolean contributes() {
        return PreferenceConstants.getPreferenceStore().getBoolean("spelling_enable_contentassist");
    }

    public List computeContextInformation(ContentAssistInvocationContext contentAssistInvocationContext, IProgressMonitor iProgressMonitor) {
        return Collections.EMPTY_LIST;
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionStarted() {
    }

    public void sessionEnded() {
    }
}

