/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.spelling.engine;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.DefaultPhoneticDistanceAlgorithm;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.DefaultPhoneticHashProvider;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.IPhoneticDistanceAlgorithm;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.IPhoneticHashProvider;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.ISpellDictionary;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.RankedWordProposal;

public abstract class AbstractSpellDictionary
implements ISpellDictionary {
    protected static final int BUCKET_CAPACITY = 4;
    protected static final int BUFFER_CAPACITY = 32;
    protected static final int DISTANCE_THRESHOLD = 160;
    protected static final int HASH_CAPACITY = 22528;
    private IPhoneticDistanceAlgorithm fDistanceAlgorithm = new DefaultPhoneticDistanceAlgorithm();
    private final Map fHashBuckets = new HashMap(22528);
    private IPhoneticHashProvider fHashProvider = new DefaultPhoneticHashProvider();
    private boolean fLoaded = false;
    private boolean fMustLoad = true;
    boolean fIsStrippingNonLetters = true;

    protected final Object getCandidates(String string) {
        return this.fHashBuckets.get(string);
    }

    protected final Set getCandidates(String string, boolean bl, ArrayList arrayList) {
        int n = 0;
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer(32);
        HashSet<RankedWordProposal> hashSet = new HashSet<RankedWordProposal>(4 * arrayList.size());
        int n2 = 0;
        while (n2 < arrayList.size()) {
            string2 = (String)arrayList.get(n2);
            Object object = this.getCandidates(string2);
            if (object != null) {
                Object object2;
                if (object instanceof String) {
                    object2 = (String)object;
                    n = this.fDistanceAlgorithm.getDistance(string, (String)object2);
                    if (n < 160) {
                        stringBuffer.setLength(0);
                        stringBuffer.append((String)object2);
                        if (bl) {
                            stringBuffer.setCharAt(0, Character.toUpperCase(stringBuffer.charAt(0)));
                        }
                        hashSet.add(new RankedWordProposal(stringBuffer.toString(), -n));
                    }
                } else {
                    object2 = (ArrayList)object;
                    int n3 = 0;
                    while (n3 < ((ArrayList)object2).size()) {
                        String string3 = (String)((ArrayList)object2).get(n3);
                        n = this.fDistanceAlgorithm.getDistance(string, string3);
                        if (n < 160) {
                            stringBuffer.setLength(0);
                            stringBuffer.append(string3);
                            if (bl) {
                                stringBuffer.setCharAt(0, Character.toUpperCase(stringBuffer.charAt(0)));
                            }
                            hashSet.add(new RankedWordProposal(stringBuffer.toString(), -n));
                        }
                        ++n3;
                    }
                }
            }
            ++n2;
        }
        return hashSet;
    }

    protected final void getCandidates(String string, boolean bl, Set set) {
        int n = 0;
        int n2 = Integer.MAX_VALUE;
        StringBuffer stringBuffer = new StringBuffer(32);
        Object object = this.getCandidates(this.fHashProvider.getHash(string));
        if (object == null) {
            return;
        }
        if (object instanceof String) {
            String string2 = (String)object;
            n = this.fDistanceAlgorithm.getDistance(string, string2);
            stringBuffer.append(string2);
            if (bl) {
                stringBuffer.setCharAt(0, Character.toUpperCase(stringBuffer.charAt(0)));
            }
            set.add(new RankedWordProposal(stringBuffer.toString(), -n));
            return;
        }
        ArrayList arrayList = (ArrayList)object;
        ArrayList<RankedWordProposal> arrayList2 = new ArrayList<RankedWordProposal>(arrayList.size());
        int n3 = 0;
        while (n3 < arrayList.size()) {
            String string3 = (String)arrayList.get(n3);
            n = this.fDistanceAlgorithm.getDistance(string, string3);
            if (n <= n2) {
                if (n < n2) {
                    arrayList2.clear();
                }
                stringBuffer.setLength(0);
                stringBuffer.append(string3);
                if (bl) {
                    stringBuffer.setCharAt(0, Character.toUpperCase(stringBuffer.charAt(0)));
                }
                arrayList2.add(new RankedWordProposal(stringBuffer.toString(), -n));
                n2 = n;
            }
            ++n3;
        }
        set.addAll(arrayList2);
    }

    protected boolean isEmpty() {
        return this.fHashBuckets.size() == 0;
    }

    protected final IPhoneticDistanceAlgorithm getDistanceAlgorithm() {
        return this.fDistanceAlgorithm;
    }

    protected final IPhoneticHashProvider getHashProvider() {
        return this.fHashProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getProposals(String string, boolean bl) {
        int n;
        int n2;
        Object object;
        block14: {
            try {
                if (this.fLoaded) break block14;
                object = this;
                synchronized (object) {
                    this.fLoaded = this.load(this.getURL());
                    if (this.fLoaded) {
                        this.compact();
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {}
        }
        object = this.fHashProvider.getHash(string);
        char[] cArray = this.fHashProvider.getMutators();
        ArrayList<Object> arrayList = new ArrayList<Object>((string.length() + 1) * (cArray.length + 2));
        arrayList.add(object);
        Set set = this.getCandidates(string, bl, arrayList);
        arrayList.clear();
        char c = '\u0000';
        char c2 = '\u0000';
        char[] cArray2 = string.toCharArray();
        int n3 = 0;
        while (n3 < string.length() - 1) {
            c2 = cArray2[n3];
            cArray2[n3] = c = cArray2[n3 + 1];
            cArray2[n3 + 1] = c2;
            arrayList.add(this.fHashProvider.getHash(new String(cArray2)));
            cArray2[n3] = c2;
            cArray2[n3 + 1] = c;
            ++n3;
        }
        String string2 = String.valueOf(string) + " ";
        cArray2 = string2.toCharArray();
        int n4 = cArray2.length - 1;
        while (true) {
            n2 = 0;
            while (n2 < cArray.length) {
                cArray2[n4] = cArray[n2];
                arrayList.add(this.fHashProvider.getHash(new String(cArray2)));
                ++n2;
            }
            if (n4 == 0) break;
            cArray2[n4] = cArray2[n4 - 1];
            --n4;
        }
        n2 = 0;
        cArray2 = string.toCharArray();
        int n5 = 0;
        while (n5 < string.length()) {
            n2 = cArray2[n5];
            n = 0;
            while (n < cArray.length) {
                cArray2[n5] = cArray[n];
                arrayList.add(this.fHashProvider.getHash(new String(cArray2)));
                ++n;
            }
            cArray2[n5] = n2;
            ++n5;
        }
        cArray2 = string.toCharArray();
        char[] cArray3 = new char[cArray2.length - 1];
        n = 0;
        while (n < cArray3.length) {
            cArray3[n] = cArray2[n];
            ++n;
        }
        c2 = cArray2[cArray2.length - 1];
        n4 = cArray3.length;
        while (true) {
            arrayList.add(this.fHashProvider.getHash(new String(cArray2)));
            if (n4 == 0) break;
            c = c2;
            c2 = cArray3[n4 - 1];
            cArray3[n4 - 1] = c;
            --n4;
        }
        arrayList.remove(object);
        Set set2 = this.getCandidates(string, bl, arrayList);
        if (set2.size() == 0 && set.size() == 0) {
            this.getCandidates(string, bl, set);
        }
        set.addAll(set2);
        return set;
    }

    protected abstract URL getURL() throws MalformedURLException;

    protected final void hashWord(String string) {
        String string2 = this.fHashProvider.getHash(string);
        Object v = this.fHashBuckets.get(string2);
        if (v == null) {
            this.fHashBuckets.put(string2, string);
        } else if (v instanceof ArrayList) {
            ((ArrayList)v).add(string);
        } else {
            ArrayList<Object> arrayList = new ArrayList<Object>(4);
            arrayList.add(v);
            arrayList.add(string);
            this.fHashBuckets.put(string2, arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCorrect(String string) {
        Object object;
        block8: {
            string = this.stripNonLetters(string);
            try {
                if (this.fLoaded) break block8;
                object = this;
                synchronized (object) {
                    this.fLoaded = this.load(this.getURL());
                    if (this.fLoaded) {
                        this.compact();
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {}
        }
        object = this.getCandidates(this.fHashProvider.getHash(string));
        if (object == null) {
            return false;
        }
        if (object instanceof String) {
            String string2 = (String)object;
            return string2.equals(string) || string2.equals(string.toLowerCase());
        }
        ArrayList arrayList = (ArrayList)object;
        return arrayList.contains(string) || arrayList.contains(string.toLowerCase());
    }

    public void setStripNonLetters(boolean bl) {
        this.fIsStrippingNonLetters = bl;
    }

    /*
     * Unable to fully structure code
     */
    protected String stripNonLetters(String var1_1) {
        if (!this.fIsStrippingNonLetters) {
            return var1_1;
        }
        var2_2 = 0;
        var3_3 = var1_1.length() - 1;
        while (var2_2 <= var3_3 && !Character.isLetter(var1_1.charAt(var2_2))) {
            ++var2_2;
        }
        if (var2_2 <= var3_3) ** GOTO lbl11
        return "";
lbl-1000:
        // 1 sources

        {
            --var3_3;
lbl11:
            // 2 sources

            ** while (var3_3 > var2_2 && !Character.isLetter((char)var1_1.charAt((int)var3_3)))
        }
lbl12:
        // 1 sources

        return var1_1.substring(var2_2, var3_3 + 1);
    }

    public final synchronized boolean isLoaded() {
        return this.fLoaded || this.fHashBuckets.size() > 0;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized boolean load(URL uRL) {
        if (!this.fMustLoad) {
            return this.fLoaded;
        }
        if (uRL == null) return false;
        InputStream inputStream = null;
        int n = 0;
        try {
            block20: {
                inputStream = uRL.openStream();
                if (inputStream == null) break block20;
                String string = null;
                CharsetDecoder charsetDecoder = Charset.forName(this.getEncoding()).newDecoder();
                charsetDecoder.onMalformedInput(CodingErrorAction.REPORT);
                charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPORT);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, charsetDecoder));
                boolean bl = true;
                while (true) {
                    if (!bl) {
                        Object var11_18 = null;
                        this.fMustLoad = false;
                        break;
                    }
                    try {
                        string = bufferedReader.readLine();
                    }
                    catch (MalformedInputException malformedInputException) {
                        charsetDecoder.onMalformedInput(CodingErrorAction.REPLACE);
                        charsetDecoder.reset();
                        string = bufferedReader.readLine();
                        charsetDecoder.onMalformedInput(CodingErrorAction.REPORT);
                        String string2 = Messages.format(JavaUIMessages.AbstractSpellingDictionary_encodingError, new String[]{string, charsetDecoder.replacement(), uRL.toString()});
                        Status status = new Status(4, "org.eclipse.wst.jsdt.ui", 0, string2, (Throwable)malformedInputException);
                        JavaPlugin.log((IStatus)status);
                        bl = string != null;
                        continue;
                    }
                    bl = string != null;
                    if (!bl) continue;
                    this.hashWord(string);
                }
                try {
                    if (inputStream == null) return true;
                    inputStream.close();
                    return true;
                }
                catch (IOException iOException) {}
                return true;
                catch (FileNotFoundException fileNotFoundException) {
                    boolean bl2;
                    String string3 = uRL.toString();
                    String string4 = string3.toLowerCase();
                    if (string3.equals(string4)) {
                        JavaPlugin.log(fileNotFoundException);
                        break block20;
                    }
                    try {
                        bl2 = this.load(new URL(string4));
                    }
                    catch (MalformedURLException malformedURLException) {
                        JavaPlugin.log(malformedURLException);
                        break block20;
                    }
                    Object var11_19 = null;
                    this.fMustLoad = false;
                    try {}
                    catch (IOException iOException) {}
                    if (inputStream == null) return bl2;
                    inputStream.close();
                    return bl2;
                }
                catch (IOException iOException) {
                    if (n > 0) {
                        String string5 = Messages.format(JavaUIMessages.AbstractSpellingDictionary_encodingError, new Object[]{new Integer(n), uRL.toString()});
                        Status status = new Status(4, "org.eclipse.wst.jsdt.ui", 0, string5, (Throwable)iOException);
                        JavaPlugin.log((IStatus)status);
                        break block20;
                    }
                    JavaPlugin.log(iOException);
                }
            }
            Object var11_21 = null;
            this.fMustLoad = false;
        }
        catch (Throwable throwable) {
            Object var11_20 = null;
            this.fMustLoad = false;
            try {}
            catch (IOException iOException) {}
            if (inputStream == null) throw throwable;
            inputStream.close();
            throw throwable;
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            return false;
        }
        if (inputStream == null) return false;
        inputStream.close();
        return false;
    }

    private void compact() {
        Iterator iterator = this.fHashBuckets.values().iterator();
        while (iterator.hasNext()) {
            Object v = iterator.next();
            if (!(v instanceof ArrayList)) continue;
            ((ArrayList)v).trimToSize();
        }
    }

    protected final void setDistanceAlgorithm(IPhoneticDistanceAlgorithm iPhoneticDistanceAlgorithm) {
        this.fDistanceAlgorithm = iPhoneticDistanceAlgorithm;
    }

    protected final void setHashProvider(IPhoneticHashProvider iPhoneticHashProvider) {
        this.fHashProvider = iPhoneticHashProvider;
    }

    public synchronized void unload() {
        this.fLoaded = false;
        this.fMustLoad = true;
        this.fHashBuckets.clear();
    }

    public boolean acceptsWords() {
        return false;
    }

    public void addWord(String string) {
    }

    protected String getEncoding() {
        String string = JavaPlugin.getDefault().getPreferenceStore().getString("spelling_user_dictionary_encoding");
        if (string == null || string.length() == 0) {
            string = ResourcesPlugin.getEncoding();
        }
        return string;
    }
}

