/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.template.contentassist;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;
import org.eclipse.wst.jsdt.internal.corext.template.java.CompilationUnitContext;
import org.eclipse.wst.jsdt.internal.corext.template.java.CompilationUnitContextType;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.correction.AssistContext;
import org.eclipse.wst.jsdt.internal.ui.text.correction.SurroundWith;
import org.eclipse.wst.jsdt.internal.ui.text.template.contentassist.TemplateContentAssistMessages;
import org.eclipse.wst.jsdt.internal.ui.text.template.contentassist.TemplateProposal;
import org.eclipse.wst.jsdt.ui.text.java.IInvocationContext;

public class SurroundWithTemplateProposal
extends TemplateProposal {
    private final IRegion fRegion;
    private final ICompilationUnit fCompilationUnit;
    private final CompilationUnitContext fContext;
    private final Template fTemplate;
    private final Statement[] fSelectedStatements;
    private TemplateProposal fProposal;
    private IRegion fSelectedRegion;
    static /* synthetic */ Class class$0;

    public SurroundWithTemplateProposal(ICompilationUnit iCompilationUnit, Template template, CompilationUnitContext compilationUnitContext, IRegion iRegion, Image image, Statement[] statementArray) {
        super(template, (TemplateContext)compilationUnitContext, iRegion, image);
        this.fCompilationUnit = iCompilationUnit;
        this.fTemplate = template;
        this.fContext = compilationUnitContext;
        this.fRegion = iRegion;
        this.fSelectedStatements = statementArray;
    }

    public String getPreviewContent() {
        TemplateBuffer templateBuffer;
        Document document = new Document(this.fCompilationUnit.getBuffer().getContents());
        CompilationUnitContext compilationUnitContext = this.createNewContext((IDocument)document);
        int n = compilationUnitContext.getCompletionOffset();
        int n2 = compilationUnitContext.getStart();
        int n3 = compilationUnitContext.getEnd();
        Region region = new Region(n2, n3 - n2);
        compilationUnitContext.setReadOnly(false);
        try {
            templateBuffer = compilationUnitContext.evaluate(this.fTemplate);
        }
        catch (TemplateException templateException) {
            JavaPlugin.log(templateException);
            return null;
        }
        try {
            n2 = region.getOffset();
            n3 = region.getOffset() + region.getLength();
            n3 = Math.max(n3, n);
            String string = templateBuffer.getString();
            document.replace(n2, n3 - n2, string);
            return document.get();
        }
        catch (MalformedTreeException malformedTreeException) {
            JavaPlugin.log(malformedTreeException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JavaPlugin.log(illegalArgumentException);
        }
        catch (BadLocationException badLocationException) {
            JavaPlugin.log(badLocationException);
        }
        catch (CoreException coreException) {
            JavaPlugin.log(coreException);
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void apply(ITextViewer iTextViewer, char c, int n, int n2) {
        try {
            try {
                this.setRedraw(iTextViewer, false);
                IDocument iDocument = iTextViewer.getDocument();
                CompilationUnitContext compilationUnitContext = this.createNewContext(iDocument);
                int n3 = compilationUnitContext.getStart();
                int n4 = compilationUnitContext.getEnd();
                Region region = new Region(n3, n4 - n3);
                this.fProposal = new TemplateProposal(this.fTemplate, (TemplateContext)compilationUnitContext, (IRegion)region, null);
                this.fProposal.apply(iTextViewer, c, n, compilationUnitContext.getCompletionOffset());
            }
            catch (MalformedTreeException malformedTreeException) {
                this.handleException(iTextViewer, (Exception)((Object)malformedTreeException), this.fRegion);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.handleException(iTextViewer, illegalArgumentException, this.fRegion);
            }
            catch (BadLocationException badLocationException) {
                this.handleException(iTextViewer, (Exception)((Object)badLocationException), this.fRegion);
            }
            catch (CoreException coreException) {
                this.handleException(iTextViewer, (Exception)((Object)coreException), this.fRegion);
            }
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            this.setRedraw(iTextViewer, true);
            throw throwable;
        }
        {
            Object var10_16 = null;
            this.setRedraw(iTextViewer, true);
            return;
        }
    }

    private void setRedraw(ITextViewer iTextViewer, boolean bl) {
        if (iTextViewer instanceof ITextViewerExtension) {
            ITextViewerExtension iTextViewerExtension = (ITextViewerExtension)iTextViewer;
            IRewriteTarget iRewriteTarget = iTextViewerExtension.getRewriteTarget();
            iRewriteTarget.setRedraw(bl);
        }
    }

    public Point getSelection(IDocument iDocument) {
        if (this.fSelectedRegion != null) {
            return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
        }
        if (this.fProposal != null) {
            return this.fProposal.getSelection(iDocument);
        }
        return null;
    }

    private CompilationUnitContext createNewContext(IDocument iDocument) throws CoreException, BadLocationException {
        AssistContext assistContext = new AssistContext(this.fCompilationUnit, this.fContext.getStart(), this.fContext.getEnd() - this.fContext.getStart());
        SurroundWithTemplate surroundWithTemplate = new SurroundWithTemplate(assistContext, this.fSelectedStatements, this.fTemplate);
        Map map = this.fCompilationUnit.getJavaProject().getOptions(true);
        surroundWithTemplate.getRewrite().rewriteAST(iDocument, map).apply(iDocument);
        int n = surroundWithTemplate.getBodyStart();
        int n2 = surroundWithTemplate.getBodyLength();
        String string = iDocument.get(n, n2);
        CompilationUnitContextType compilationUnitContextType = (CompilationUnitContextType)JavaPlugin.getDefault().getTemplateContextRegistry().getContextType("javaScript");
        CompilationUnitContext compilationUnitContext = compilationUnitContextType.createContext(iDocument, n, string.length(), this.fCompilationUnit);
        compilationUnitContext.setVariable("selection", string);
        compilationUnitContext.setForceEvaluation(true);
        return compilationUnitContext;
    }

    private void handleException(ITextViewer iTextViewer, Exception exception, IRegion iRegion) {
        JavaPlugin.log(exception);
        this.openErrorDialog(iTextViewer.getTextWidget().getShell(), exception);
        this.fSelectedRegion = iRegion;
    }

    private void openErrorDialog(Shell shell, Exception exception) {
        MessageDialog.openError((Shell)shell, (String)TemplateContentAssistMessages.TemplateEvaluator_error_title, (String)exception.getMessage());
    }

    public boolean validate(IDocument iDocument, int n, DocumentEvent documentEvent) {
        return false;
    }

    private static class SurroundWithTemplate
    extends SurroundWith {
        private static final String $_LINE_SELECTION = "${line_selection}";
        private final Template fTemplate;
        private final IJavaProject fCurrentProject;
        private ASTNode fTemplateNode;

        public SurroundWithTemplate(IInvocationContext iInvocationContext, Statement[] statementArray, Template template) {
            super(iInvocationContext.getASTRoot(), statementArray);
            this.fTemplate = template;
            this.fCurrentProject = iInvocationContext.getCompilationUnit().getJavaProject();
        }

        protected List getVariableDeclarationReadsInside(Statement[] statementArray, int n) {
            if (this.isNewContext()) {
                return super.getVariableDeclarationReadsInside(statementArray, n);
            }
            return new ArrayList();
        }

        protected boolean isNewContext() {
            String string = this.fTemplate.getPattern();
            int n = string.indexOf($_LINE_SELECTION);
            int n2 = -1;
            while (n != -1) {
                n2 = n;
                string = string.replaceFirst("\\$\\{[^\\}]*\\}", "");
                n = string.indexOf($_LINE_SELECTION);
            }
            string = string.replaceAll("\\$\\{[^\\}]*\\}", "");
            AST aST = this.getAst();
            ASTParser aSTParser = ASTParser.newParser((int)aST.apiLevel());
            aSTParser.setSource(string.toCharArray());
            aSTParser.setProject(this.fCurrentProject);
            aSTParser.setKind(2);
            ASTNode aSTNode = aSTParser.createAST(null);
            if (((Block)aSTNode).statements().isEmpty()) {
                aSTParser = ASTParser.newParser((int)aST.apiLevel());
                aSTParser.setSource(string.toCharArray());
                aSTParser.setProject(this.fCurrentProject);
                aSTParser.setKind(1);
                aSTNode = aSTParser.createAST(null);
            }
            int n3 = n2;
            aSTNode.accept((ASTVisitor)new GenericVisitor(this, n3){
                final /* synthetic */ SurroundWithTemplate this$1;
                private final /* synthetic */ int val$lineSelectionPosition;
                {
                    this.this$1 = surroundWithTemplate;
                    this.val$lineSelectionPosition = n;
                }

                public void endVisit(Block block) {
                    super.endVisit(block);
                    if (SurroundWithTemplate.access$0(this.this$1) == null && block.getStartPosition() <= this.val$lineSelectionPosition && block.getLength() + block.getStartPosition() >= this.val$lineSelectionPosition) {
                        SurroundWithTemplate.access$1(this.this$1, (ASTNode)block);
                    }
                }
            });
            if (this.fTemplateNode != null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.MethodDeclaration");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (ASTNodes.getParent(this.fTemplateNode, clazz) != null) {
                    return true;
                }
            }
            return false;
        }

        static /* synthetic */ ASTNode access$0(SurroundWithTemplate surroundWithTemplate) {
            return surroundWithTemplate.fTemplateNode;
        }

        static /* synthetic */ void access$1(SurroundWithTemplate surroundWithTemplate, ASTNode aSTNode) {
            surroundWithTemplate.fTemplateNode = aSTNode;
        }
    }
}

