/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.template.preferences;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.template.preferences.TemplatePreferencesMessages;

public class TemplateVariableProposal
implements ICompletionProposal {
    private TemplateVariableResolver fResolver;
    private int fOffset;
    private int fLength;
    private ITextViewer fViewer;
    private Point fSelection;
    private final boolean fIncludeBrace;

    public TemplateVariableProposal(TemplateVariableResolver templateVariableResolver, int n, int n2, ITextViewer iTextViewer, boolean bl) {
        this.fResolver = templateVariableResolver;
        this.fOffset = n;
        this.fLength = n2;
        this.fViewer = iTextViewer;
        this.fIncludeBrace = bl;
    }

    public void apply(IDocument iDocument) {
        try {
            String string = this.fResolver.getType();
            String string2 = string.equals("dollar") ? "$$" : (this.fIncludeBrace ? "${" + string + '}' : string);
            iDocument.replace(this.fOffset, this.fLength, string2);
            this.fSelection = new Point(this.fOffset + string2.length(), 0);
        }
        catch (BadLocationException badLocationException) {
            JavaPlugin.log(badLocationException);
            Shell shell = this.fViewer.getTextWidget().getShell();
            MessageDialog.openError((Shell)shell, (String)TemplatePreferencesMessages.TemplateVariableProposal_error_title, (String)badLocationException.getMessage());
        }
    }

    public Point getSelection(IDocument iDocument) {
        return this.fSelection;
    }

    public String getAdditionalProposalInfo() {
        return this.fResolver.getDescription();
    }

    public String getDisplayString() {
        return this.fResolver.getType();
    }

    public Image getImage() {
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }
}

