/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.typehierarchy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.filters.SyntheticMembersFilter;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.HierarchyViewerSorter;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.MethodsContentProvider;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.MethodsLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.ShowInheritedMembersAction;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.SortByDefiningTypeAction;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.wst.jsdt.internal.ui.util.JavaUIHelp;
import org.eclipse.wst.jsdt.internal.ui.util.SelectionUtil;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredViewersManager;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ProblemTableViewer;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;
import org.eclipse.wst.jsdt.ui.actions.MemberFilterActionGroup;
import org.eclipse.wst.jsdt.ui.actions.OpenAction;

public class MethodsViewer
extends ProblemTableViewer {
    private static final String TAG_SHOWINHERITED = "showinherited";
    private static final String TAG_SORTBYDEFININGTYPE = "sortbydefiningtype";
    private static final String TAG_VERTICAL_SCROLL = "mv_vertical_scroll";
    private MethodsLabelProvider fLabelProvider;
    private MemberFilterActionGroup fMemberFilterActionGroup;
    private OpenAction fOpen;
    private ShowInheritedMembersAction fShowInheritedMembersAction;
    private SortByDefiningTypeAction fSortByDefiningTypeAction;

    public MethodsViewer(Composite composite, TypeHierarchyLifeCycle typeHierarchyLifeCycle, IWorkbenchPart iWorkbenchPart) {
        super(new Table(composite, 2));
        this.addFilter(new SyntheticMembersFilter());
        this.fLabelProvider = new MethodsLabelProvider(typeHierarchyLifeCycle, this);
        this.setLabelProvider((IBaseLabelProvider)new DecoratingJavaLabelProvider(this.fLabelProvider, true));
        this.setContentProvider((IContentProvider)new MethodsContentProvider(typeHierarchyLifeCycle));
        HierarchyViewerSorter hierarchyViewerSorter = new HierarchyViewerSorter(typeHierarchyLifeCycle);
        hierarchyViewerSorter.setSortByDefiningType(false);
        this.setComparator(hierarchyViewerSorter);
        this.fOpen = new OpenAction((IWorkbenchSite)iWorkbenchPart.getSite());
        this.addOpenListener(new IOpenListener(){

            public void open(OpenEvent openEvent) {
                MethodsViewer.this.fOpen.run();
            }
        });
        this.fMemberFilterActionGroup = new MemberFilterActionGroup((StructuredViewer)this, "HierarchyMethodView", false, 7);
        this.fShowInheritedMembersAction = new ShowInheritedMembersAction(this, false);
        this.fSortByDefiningTypeAction = new SortByDefiningTypeAction(this, false);
        this.showInheritedMethodsNoRedraw(false);
        this.sortByDefiningTypeNoRedraw(false);
        ColoredViewersManager.install((StructuredViewer)this);
        JavaUIHelp.setHelp((StructuredViewer)this, "org.eclipse.wst.jsdt.ui.type_hierarchy_view_context");
    }

    private void showInheritedMethodsNoRedraw(boolean bl) {
        MethodsContentProvider methodsContentProvider = (MethodsContentProvider)this.getContentProvider();
        methodsContentProvider.showInheritedMethods(bl);
        this.fShowInheritedMembersAction.setChecked(bl);
        if (bl) {
            this.fLabelProvider.setTextFlags(this.fLabelProvider.getTextFlags() | JavaElementLabels.ALL_POST_QUALIFIED);
        } else {
            this.fLabelProvider.setTextFlags(this.fLabelProvider.getTextFlags() & (JavaElementLabels.ALL_POST_QUALIFIED ^ 0xFFFFFFFFFFFFFFFFL));
        }
        if (bl) {
            this.sortByDefiningTypeNoRedraw(false);
        }
        this.fSortByDefiningTypeAction.setEnabled(!bl);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void showInheritedMethods(boolean bl) {
        if (bl == this.isShowInheritedMethods()) {
            return;
        }
        try {
            this.getTable().setRedraw(false);
            this.showInheritedMethodsNoRedraw(bl);
            this.refresh();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.getTable().setRedraw(true);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.getTable().setRedraw(true);
    }

    private void sortByDefiningTypeNoRedraw(boolean bl) {
        this.fSortByDefiningTypeAction.setChecked(bl);
        this.fLabelProvider.setShowDefiningType(bl);
        ((HierarchyViewerSorter)this.getComparator()).setSortByDefiningType(bl);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sortByDefiningType(boolean bl) {
        if (bl == this.isShowDefiningTypes()) {
            return;
        }
        try {
            this.getTable().setRedraw(false);
            this.sortByDefiningTypeNoRedraw(bl);
            this.refresh();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.getTable().setRedraw(true);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.getTable().setRedraw(true);
    }

    protected void inputChanged(Object object, Object object2) {
        super.inputChanged(object, object2);
    }

    public boolean isShowInheritedMethods() {
        return ((MethodsContentProvider)this.getContentProvider()).isShowInheritedMethods();
    }

    public boolean isShowDefiningTypes() {
        return this.fLabelProvider.isShowDefiningType();
    }

    public void saveState(IMemento iMemento) {
        this.fMemberFilterActionGroup.saveState(iMemento);
        iMemento.putString(TAG_SHOWINHERITED, String.valueOf(this.isShowInheritedMethods()));
        iMemento.putString(TAG_SORTBYDEFININGTYPE, String.valueOf(this.isShowDefiningTypes()));
        ScrollBar scrollBar = this.getTable().getVerticalBar();
        int n = scrollBar != null ? scrollBar.getSelection() : 0;
        iMemento.putString(TAG_VERTICAL_SCROLL, String.valueOf(n));
    }

    public void restoreState(IMemento iMemento) {
        Integer n;
        this.fMemberFilterActionGroup.restoreState(iMemento);
        this.getControl().setRedraw(false);
        this.refresh();
        this.getControl().setRedraw(true);
        boolean bl = Boolean.valueOf(iMemento.getString(TAG_SHOWINHERITED));
        this.showInheritedMethods(bl);
        boolean bl2 = Boolean.valueOf(iMemento.getString(TAG_SORTBYDEFININGTYPE));
        this.sortByDefiningType(bl2);
        ScrollBar scrollBar = this.getTable().getVerticalBar();
        if (scrollBar != null && (n = iMemento.getInteger(TAG_VERTICAL_SCROLL)) != null) {
            scrollBar.setSelection(n.intValue());
        }
    }

    public void initContextMenu(IMenuListener iMenuListener, String string, IWorkbenchPartSite iWorkbenchPartSite) {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(iMenuListener);
        Menu menu = menuManager.createContextMenu((Control)this.getTable());
        this.getTable().setMenu(menu);
        iWorkbenchPartSite.registerContextMenu(string, menuManager, (ISelectionProvider)this);
    }

    public void contributeToContextMenu(IMenuManager iMenuManager) {
    }

    public void contributeToToolBar(ToolBarManager toolBarManager) {
        toolBarManager.add((IAction)this.fShowInheritedMembersAction);
        toolBarManager.add((IAction)this.fSortByDefiningTypeAction);
        toolBarManager.add((IContributionItem)new Separator());
        this.fMemberFilterActionGroup.contributeToToolBar((IToolBarManager)toolBarManager);
    }

    public void dispose() {
        if (this.fMemberFilterActionGroup != null) {
            this.fMemberFilterActionGroup.dispose();
            this.fMemberFilterActionGroup = null;
        }
    }

    protected void handleInvalidSelection(ISelection iSelection, ISelection iSelection2) {
        List list = SelectionUtil.toList(iSelection);
        List list2 = SelectionUtil.toList(iSelection2);
        if (!list.isEmpty()) {
            ArrayList<IMethod> arrayList = new ArrayList<IMethod>(list2);
            try {
                Object[] objectArray = this.getFilteredChildren(this.getInput());
                int n = 0;
                while (n < list.size()) {
                    IMethod iMethod;
                    IMethod iMethod2;
                    Object e = list.get(n);
                    if (e instanceof IMethod && !list2.contains(e) && (iMethod2 = (IMethod)e).exists() && (iMethod = this.findSimilarMethod(iMethod2, objectArray)) != null) {
                        arrayList.add(iMethod);
                    }
                    ++n;
                }
                if (!arrayList.isEmpty()) {
                    iSelection2 = new StructuredSelection(arrayList);
                } else if (objectArray.length > 0) {
                    iSelection2 = new StructuredSelection(objectArray[0]);
                }
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
            }
        }
        this.setSelection(iSelection2);
        this.updateSelection(iSelection2);
    }

    private IMethod findSimilarMethod(IMethod iMethod, Object[] objectArray) throws JavaModelException {
        String string = iMethod.getElementName();
        String[] stringArray = iMethod.getParameterTypes();
        boolean bl = iMethod.isConstructor();
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            if (object instanceof IMethod && JavaModelUtil.isSameMethodSignature(string, stringArray, bl, (IMethod)object)) {
                return (IMethod)object;
            }
            ++n;
        }
        return null;
    }
}

