/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.typehierarchy;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.HierarchyLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.HierarchyViewerSorter;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.TypeHierarchyContentProvider;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.wst.jsdt.internal.ui.util.JavaUIHelp;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredViewersManager;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ProblemTreeViewer;
import org.eclipse.wst.jsdt.ui.actions.OpenAction;

public abstract class TypeHierarchyViewer
extends ProblemTreeViewer {
    private OpenAction fOpen;
    private HierarchyLabelProvider fLabelProvider;

    public TypeHierarchyViewer(Composite composite, IContentProvider iContentProvider, TypeHierarchyLifeCycle typeHierarchyLifeCycle, IWorkbenchPart iWorkbenchPart) {
        super(new Tree(composite, 4));
        this.fLabelProvider = new HierarchyLabelProvider(typeHierarchyLifeCycle);
        this.setLabelProvider((IBaseLabelProvider)new DecoratingJavaLabelProvider(this.fLabelProvider, true));
        this.setUseHashlookup(true);
        this.setContentProvider(iContentProvider);
        this.setComparator(new HierarchyViewerSorter(typeHierarchyLifeCycle));
        this.fOpen = new OpenAction((IWorkbenchSite)iWorkbenchPart.getSite());
        this.addOpenListener(new IOpenListener(){

            public void open(OpenEvent openEvent) {
                TypeHierarchyViewer.this.fOpen.run();
            }
        });
        ColoredViewersManager.install((StructuredViewer)this);
        JavaUIHelp.setHelp((StructuredViewer)this, "org.eclipse.wst.jsdt.ui.type_hierarchy_view_context");
    }

    public void setQualifiedTypeName(boolean bl) {
        if (bl) {
            this.fLabelProvider.setTextFlags(this.fLabelProvider.getTextFlags() | 0x100000L);
        } else {
            this.fLabelProvider.setTextFlags(this.fLabelProvider.getTextFlags() & 0xFFFFFFFFFFEFFFFFL);
        }
        this.refresh();
    }

    public void initContextMenu(IMenuListener iMenuListener, String string, IWorkbenchPartSite iWorkbenchPartSite) {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(iMenuListener);
        Menu menu = menuManager.createContextMenu((Control)this.getTree());
        this.getTree().setMenu(menu);
        iWorkbenchPartSite.registerContextMenu(string, menuManager, (ISelectionProvider)this);
    }

    public void contributeToContextMenu(IMenuManager iMenuManager) {
    }

    public void setMemberFilter(IMember[] iMemberArray) {
        TypeHierarchyContentProvider typeHierarchyContentProvider = this.getHierarchyContentProvider();
        if (typeHierarchyContentProvider != null) {
            typeHierarchyContentProvider.setMemberFilter(iMemberArray);
        }
    }

    public boolean isMethodFiltering() {
        TypeHierarchyContentProvider typeHierarchyContentProvider = this.getHierarchyContentProvider();
        if (typeHierarchyContentProvider != null) {
            return typeHierarchyContentProvider.getMemberFilter() != null;
        }
        return false;
    }

    public void setWorkingSetFilter(ViewerFilter viewerFilter) {
        this.fLabelProvider.setFilter(viewerFilter);
        TypeHierarchyContentProvider typeHierarchyContentProvider = this.getHierarchyContentProvider();
        if (typeHierarchyContentProvider != null) {
            typeHierarchyContentProvider.setWorkingSetFilter(viewerFilter);
        }
    }

    public Object containsElements() {
        Object[] objectArray;
        TypeHierarchyContentProvider typeHierarchyContentProvider = this.getHierarchyContentProvider();
        if (typeHierarchyContentProvider != null && (objectArray = typeHierarchyContentProvider.getElements(null)).length > 0) {
            return objectArray[0];
        }
        return null;
    }

    public IType getTreeRootType() {
        Object[] objectArray;
        TypeHierarchyContentProvider typeHierarchyContentProvider = this.getHierarchyContentProvider();
        if (typeHierarchyContentProvider != null && (objectArray = typeHierarchyContentProvider.getElements(null)).length > 0 && objectArray[0] instanceof IType) {
            return (IType)objectArray[0];
        }
        return null;
    }

    public boolean isElementShown(Object object) {
        return this.findItem(object) != null;
    }

    public abstract void updateContent(boolean var1);

    public abstract String getTitle();

    public void setContentProvider(IContentProvider iContentProvider) {
        Assert.isTrue((boolean)(iContentProvider instanceof TypeHierarchyContentProvider));
        super.setContentProvider(iContentProvider);
    }

    protected TypeHierarchyContentProvider getHierarchyContentProvider() {
        return (TypeHierarchyContentProvider)this.getContentProvider();
    }
}

