/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.util;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.util.JavadocHelpContext;

public class JavaUIHelp {
    public static void setHelp(StructuredViewer structuredViewer, String string) {
        JavaUIHelpListener javaUIHelpListener = new JavaUIHelpListener(structuredViewer, string);
        structuredViewer.getControl().addHelpListener((HelpListener)javaUIHelpListener);
    }

    public static void setHelp(JavaEditor javaEditor, StyledText styledText, String string) {
        JavaUIHelpListener javaUIHelpListener = new JavaUIHelpListener(javaEditor, string);
        styledText.addHelpListener((HelpListener)javaUIHelpListener);
    }

    public static IContextProvider getHelpContextProvider(IWorkbenchPart iWorkbenchPart, String string) {
        IStructuredSelection iStructuredSelection;
        try {
            iStructuredSelection = SelectionConverter.getStructuredSelection(iWorkbenchPart);
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
            iStructuredSelection = StructuredSelection.EMPTY;
        }
        Object[] objectArray = iStructuredSelection.toArray();
        return new JavaUIHelpContextProvider(string, objectArray);
    }

    private static class JavaUIHelpContextProvider
    implements IContextProvider {
        private String fId;
        private Object[] fSelected;

        public JavaUIHelpContextProvider(String string, Object[] objectArray) {
            this.fId = string;
            this.fSelected = objectArray;
        }

        public int getContextChangeMask() {
            return 1;
        }

        public IContext getContext(Object object) {
            Object object2;
            block3: {
                object2 = HelpSystem.getContext((String)this.fId);
                if (this.fSelected != null && this.fSelected.length > 0) {
                    try {
                        object2 = new JavadocHelpContext((IContext)object2, this.fSelected);
                    }
                    catch (JavaModelException javaModelException) {
                        if (javaModelException.isDoesNotExist()) break block3;
                        JavaPlugin.log(javaModelException);
                    }
                }
            }
            return object2;
        }

        public String getSearchExpression(Object object) {
            return null;
        }
    }

    private static class JavaUIHelpListener
    implements HelpListener {
        private StructuredViewer fViewer;
        private String fContextId;
        private JavaEditor fEditor;

        public JavaUIHelpListener(StructuredViewer structuredViewer, String string) {
            this.fViewer = structuredViewer;
            this.fContextId = string;
        }

        public JavaUIHelpListener(JavaEditor javaEditor, String string) {
            this.fContextId = string;
            this.fEditor = javaEditor;
        }

        public void helpRequested(HelpEvent helpEvent) {
            try {
                IJavaElement iJavaElement;
                Object[] objectArray = null;
                if (this.fViewer != null) {
                    ISelection iSelection = this.fViewer.getSelection();
                    if (iSelection instanceof IStructuredSelection) {
                        objectArray = ((IStructuredSelection)iSelection).toArray();
                    }
                } else if (this.fEditor != null && ActionUtil.isOnBuildPath(iJavaElement = SelectionConverter.getInput(this.fEditor))) {
                    objectArray = SelectionConverter.codeResolve(this.fEditor);
                }
                JavadocHelpContext.displayHelp(this.fContextId, objectArray);
            }
            catch (CoreException coreException) {
                JavaPlugin.log(coreException);
            }
        }
    }
}

