/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.util;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.SearchUtils;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;

public class MainMethodSearchEngine {
    public IType[] searchMainMethods(IProgressMonitor iProgressMonitor, IJavaSearchScope iJavaSearchScope, int n) throws CoreException {
        ArrayList arrayList = new ArrayList(200);
        SearchPattern searchPattern = SearchPattern.createPattern((String)"main(String[]) void", (int)1, (int)0, (int)8);
        MethodCollector methodCollector = new MethodCollector(arrayList, n);
        new SearchEngine().search(searchPattern, SearchUtils.getDefaultSearchParticipants(), iJavaSearchScope, (SearchRequestor)methodCollector, iProgressMonitor);
        return arrayList.toArray(new IType[arrayList.size()]);
    }

    public IType[] searchMainMethods(IRunnableContext iRunnableContext, final IJavaSearchScope iJavaSearchScope, final int n) throws InvocationTargetException, InterruptedException {
        int n2 = 24;
        Assert.isTrue(((n | n2) == n2 ? 1 : 0) != 0);
        final IType[][] iTypeArrayArray = new IType[1][];
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                try {
                    iTypeArrayArray[0] = MainMethodSearchEngine.this.searchMainMethods(iProgressMonitor, iJavaSearchScope, n);
                }
                catch (CoreException coreException) {
                    throw new InvocationTargetException(coreException);
                }
            }
        };
        iRunnableContext.run(true, true, iRunnableWithProgress);
        return iTypeArrayArray[0];
    }

    private static class MethodCollector
    extends SearchRequestor {
        private List fResult;
        private int fStyle;

        public MethodCollector(List list, int n) {
            Assert.isNotNull((Object)list);
            this.fResult = list;
            this.fStyle = n;
        }

        private boolean considerExternalJars() {
            return (this.fStyle & 0x10) != 0;
        }

        private boolean considerBinaries() {
            return (this.fStyle & 8) != 0;
        }

        public void acceptSearchMatch(SearchMatch searchMatch) throws CoreException {
            Object object = searchMatch.getElement();
            if (object instanceof IMethod) {
                try {
                    IMethod iMethod = (IMethod)object;
                    if (iMethod.isMainMethod()) {
                        IPackageFragmentRoot iPackageFragmentRoot;
                        if (!this.considerExternalJars() && ((iPackageFragmentRoot = JavaModelUtil.getPackageFragmentRoot((IJavaElement)iMethod)) == null || iPackageFragmentRoot.isArchive())) {
                            return;
                        }
                        if (!this.considerBinaries() && iMethod.isBinary()) {
                            return;
                        }
                        this.fResult.add(iMethod.getDeclaringType());
                    }
                }
                catch (JavaModelException javaModelException) {
                    JavaPlugin.log(javaModelException.getStatus());
                }
            }
        }
    }
}

