/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Control;

public class RowLayouter {
    public int spanHorizontalAlignment = -1;
    public int spanGrabExcessHorizontalSpace = -1;
    public int spanHorizontalSpan = -1;
    public int spanHorizontalIndent = -1;
    public int spanWidthHint = -1;
    public int spanVerticalAlignment = -1;
    public int spanGrabExcessVerticalSpace = -1;
    public int spanVerticalSpan = -1;
    public int spanHeightHint = -1;
    private int fNumColumns;
    private boolean fOrder;
    private Control fLastControl;
    private GridData[] fDefaultGridDatas = new GridData[4];

    public RowLayouter(int n) {
        this(n, false);
    }

    public RowLayouter(int n, boolean bl) {
        this.fNumColumns = n;
        this.fOrder = bl;
    }

    public void setDefaultSpan() {
        this.spanHorizontalAlignment = 4;
        this.spanGrabExcessHorizontalSpace = 1;
    }

    public void perform(Control control) {
        this.perform(new Control[]{control}, 0);
    }

    public void perform(Control control, Control control2, int n) {
        this.perform(new Control[]{control, control2}, n);
    }

    public void perform(Control control, Control control2, Control control3, int n) {
        this.perform(new Control[]{control, control2, control3}, n);
    }

    public void perform(Control[] controlArray, int n) {
        int n2 = this.numColumns();
        Assert.isTrue((controlArray.length <= n2 ? 1 : 0) != 0);
        this.order(controlArray);
        int n3 = 0;
        int n4 = 0;
        while (n4 < controlArray.length) {
            Control control = controlArray[n4];
            GridData gridData = (GridData)control.getLayoutData();
            if (gridData == null) {
                gridData = this.getGridData(n3);
            }
            if (n4 == n) {
                int n5 = n2 - (controlArray.length - 1);
                n3 += n5;
                if (gridData == null) {
                    gridData = new GridData();
                }
                this.applyDelta(gridData);
                gridData.horizontalSpan = n5;
            } else {
                ++n3;
            }
            control.setLayoutData((Object)gridData);
            ++n4;
        }
    }

    private void applyDelta(GridData gridData) {
        if (this.spanHorizontalAlignment != -1) {
            gridData.horizontalAlignment = this.spanHorizontalAlignment;
        }
        if (this.spanGrabExcessHorizontalSpace != -1) {
            gridData.grabExcessHorizontalSpace = this.spanGrabExcessHorizontalSpace != 0;
        }
        if (this.spanHorizontalSpan != -1) {
            gridData.horizontalSpan = this.spanHorizontalSpan;
        }
        if (this.spanHorizontalIndent != -1) {
            gridData.horizontalIndent = this.spanHorizontalIndent;
        }
        if (this.spanWidthHint != -1) {
            gridData.widthHint = this.spanWidthHint;
        }
        if (this.spanVerticalAlignment != -1) {
            gridData.verticalAlignment = this.spanVerticalAlignment;
        }
        if (this.spanGrabExcessVerticalSpace != -1) {
            gridData.grabExcessVerticalSpace = this.spanGrabExcessVerticalSpace != 0;
        }
        if (this.spanVerticalSpan != -1) {
            gridData.verticalSpan = this.spanVerticalSpan;
        }
        if (this.spanHeightHint != -1) {
            gridData.heightHint = this.spanHeightHint;
        }
    }

    public void setDefaultGridData(GridData gridData, int n) {
        if (n >= this.fDefaultGridDatas.length) {
            GridData[] gridDataArray = new GridData[n + 4];
            System.arraycopy(this.fDefaultGridDatas, 0, gridDataArray, 0, this.fDefaultGridDatas.length);
            this.fDefaultGridDatas = gridDataArray;
        }
        this.fDefaultGridDatas[n] = gridData;
    }

    public GridData getGridData(int n) {
        if (n > this.fDefaultGridDatas.length) {
            return null;
        }
        return this.cloneGridData(this.fDefaultGridDatas[n]);
    }

    public int numColumns() {
        return this.fNumColumns;
    }

    protected void order(Control[] controlArray) {
        if (!this.fOrder) {
            return;
        }
        int n = 0;
        while (n < controlArray.length) {
            Control control = controlArray[n];
            control.moveBelow(this.fLastControl);
            this.fLastControl = control;
            ++n;
        }
    }

    protected GridData cloneGridData(GridData gridData) {
        if (gridData == null) {
            return null;
        }
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = gridData.horizontalAlignment;
        gridData2.grabExcessHorizontalSpace = gridData.grabExcessHorizontalSpace;
        gridData2.horizontalSpan = gridData.horizontalSpan;
        gridData2.horizontalIndent = gridData.horizontalIndent;
        gridData2.widthHint = gridData.widthHint;
        gridData2.verticalAlignment = gridData.verticalAlignment;
        gridData2.grabExcessVerticalSpace = gridData.grabExcessVerticalSpace;
        gridData2.verticalSpan = gridData.verticalSpan;
        gridData2.heightHint = gridData.heightHint;
        return gridData2;
    }
}

