/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.util;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.search.TypeNameMatch;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public class TypeNameMatchLabelProvider
extends LabelProvider {
    public static final int SHOW_FULLYQUALIFIED = 1;
    public static final int SHOW_PACKAGE_POSTFIX = 2;
    public static final int SHOW_PACKAGE_ONLY = 4;
    public static final int SHOW_ROOT_POSTFIX = 8;
    public static final int SHOW_TYPE_ONLY = 16;
    public static final int SHOW_TYPE_CONTAINER_ONLY = 32;
    public static final int SHOW_POST_QUALIFIED = 64;
    private static final Image CLASS_ICON = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.class_obj.gif");
    private static final Image ANNOTATION_ICON = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.annotation_obj.gif");
    private static final Image INTERFACE_ICON = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.int_obj.gif");
    private static final Image ENUM_ICON = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.enum_obj.gif");
    private static final Image PKG_ICON = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.package_obj.gif");
    private int fFlags;

    public TypeNameMatchLabelProvider(int n) {
        this.fFlags = n;
    }

    private boolean isSet(int n) {
        return (this.fFlags & n) != 0;
    }

    private String getPackageName(String string) {
        if (string.length() == 0) {
            return JavaUIMessages.TypeInfoLabelProvider_default_package;
        }
        return string;
    }

    public String getText(Object object) {
        String string;
        if (!(object instanceof TypeNameMatch)) {
            return super.getText(object);
        }
        TypeNameMatch typeNameMatch = (TypeNameMatch)object;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isSet(16)) {
            stringBuffer.append(typeNameMatch.getSimpleTypeName());
        } else if (this.isSet(32)) {
            string = typeNameMatch.getTypeContainerName();
            stringBuffer.append(this.getPackageName(string));
        } else if (this.isSet(4)) {
            string = typeNameMatch.getPackageName();
            stringBuffer.append(this.getPackageName(string));
        } else {
            if (this.isSet(1)) {
                stringBuffer.append(typeNameMatch.getFullyQualifiedName());
            } else if (this.isSet(64)) {
                stringBuffer.append(typeNameMatch.getSimpleTypeName());
                string = typeNameMatch.getTypeContainerName();
                if (string != null && string.length() > 0) {
                    stringBuffer.append(JavaElementLabels.CONCAT_STRING);
                    stringBuffer.append(string);
                }
            } else {
                stringBuffer.append(typeNameMatch.getTypeQualifiedName());
            }
            if (this.isSet(2)) {
                stringBuffer.append(JavaElementLabels.CONCAT_STRING);
                string = typeNameMatch.getPackageName();
                stringBuffer.append(this.getPackageName(string));
            }
        }
        if (this.isSet(8)) {
            stringBuffer.append(JavaElementLabels.CONCAT_STRING);
            string = typeNameMatch.getPackageFragmentRoot();
            JavaElementLabels.getPackageFragmentRootLabel((IPackageFragmentRoot)string, 0x20000000000L, stringBuffer);
        }
        return stringBuffer.toString();
    }

    public Image getImage(Object object) {
        if (!(object instanceof TypeNameMatch)) {
            return super.getImage(object);
        }
        if (this.isSet(32)) {
            TypeNameMatch typeNameMatch = (TypeNameMatch)object;
            if (typeNameMatch.getPackageName().equals(typeNameMatch.getTypeContainerName())) {
                return PKG_ICON;
            }
            return CLASS_ICON;
        }
        if (this.isSet(4)) {
            return PKG_ICON;
        }
        int n = ((TypeNameMatch)object).getModifiers();
        if (Flags.isAnnotation((int)n)) {
            return ANNOTATION_ICON;
        }
        if (Flags.isEnum((int)n)) {
            return ENUM_ICON;
        }
        if (Flags.isInterface((int)n)) {
            return INTERFACE_ICON;
        }
        return CLASS_ICON;
    }
}

