/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.viewsupport;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaWorkbenchAdapter;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.wst.jsdt.ui.JavaElementImageDescriptor;

public class JavaElementImageProvider {
    public static final int OVERLAY_ICONS = 1;
    public static final int SMALL_ICONS = 2;
    public static final int LIGHT_TYPE_ICONS = 4;
    public static final Point SMALL_SIZE = new Point(16, 16);
    public static final Point BIG_SIZE = new Point(22, 16);
    private static ImageDescriptor DESC_OBJ_PROJECT_CLOSED;
    private static ImageDescriptor DESC_OBJ_PROJECT;
    private ImageDescriptorRegistry fRegistry;
    static /* synthetic */ Class class$0;

    public JavaElementImageProvider() {
        ISharedImages iSharedImages = JavaPlugin.getDefault().getWorkbench().getSharedImages();
        DESC_OBJ_PROJECT_CLOSED = iSharedImages.getImageDescriptor("IMG_OBJ_PROJECT_CLOSED");
        DESC_OBJ_PROJECT = iSharedImages.getImageDescriptor("IMG_OBJ_PROJECT");
        this.fRegistry = null;
    }

    public Image getImageLabel(Object object, int n) {
        return this.getImageLabel(this.computeDescriptor(object, n));
    }

    private Image getImageLabel(ImageDescriptor imageDescriptor) {
        if (imageDescriptor == null) {
            return null;
        }
        return this.getRegistry().get(imageDescriptor);
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = JavaPlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    private ImageDescriptor computeDescriptor(Object object, int n) {
        if (object instanceof IJavaElement) {
            return this.getJavaImageDescriptor((IJavaElement)object, n);
        }
        if (object instanceof IFile) {
            IFile iFile = (IFile)object;
            if (JavaCore.isJavaLikeFileName((String)iFile.getName())) {
                return this.getCUResourceImageDescriptor(iFile, n);
            }
            return this.getWorkbenchImageDescriptor((IAdaptable)iFile, n);
        }
        if (object instanceof IAdaptable) {
            return this.getWorkbenchImageDescriptor((IAdaptable)object, n);
        }
        return null;
    }

    private static boolean showOverlayIcons(int n) {
        return (n & 1) != 0;
    }

    private static boolean useSmallSize(int n) {
        return (n & 2) != 0;
    }

    private static boolean useLightIcons(int n) {
        return (n & 4) != 0;
    }

    public ImageDescriptor getCUResourceImageDescriptor(IFile iFile, int n) {
        Point point = JavaElementImageProvider.useSmallSize(n) ? SMALL_SIZE : BIG_SIZE;
        return new JavaElementImageDescriptor(JavaPluginImages.DESC_OBJS_CUNIT_RESOURCE, 0, point);
    }

    public ImageDescriptor getJavaImageDescriptor(IJavaElement iJavaElement, int n) {
        Point point = JavaElementImageProvider.useSmallSize(n) ? SMALL_SIZE : BIG_SIZE;
        ImageDescriptor imageDescriptor = this.getBaseImageDescriptor(iJavaElement, n);
        if (imageDescriptor != null) {
            int n2 = this.computeJavaAdornmentFlags(iJavaElement, n);
            return new JavaElementImageDescriptor(imageDescriptor, n2, point);
        }
        return new JavaElementImageDescriptor(JavaPluginImages.DESC_OBJS_GHOST, 0, point);
    }

    public ImageDescriptor getWorkbenchImageDescriptor(IAdaptable iAdaptable, int n) {
        IWorkbenchAdapter iWorkbenchAdapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iWorkbenchAdapter = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz)) == null) {
            return null;
        }
        ImageDescriptor imageDescriptor = iWorkbenchAdapter.getImageDescriptor((Object)iAdaptable);
        if (imageDescriptor == null) {
            return null;
        }
        Point point = JavaElementImageProvider.useSmallSize(n) ? SMALL_SIZE : BIG_SIZE;
        return new JavaElementImageDescriptor(imageDescriptor, 0, point);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ImageDescriptor getBaseImageDescriptor(IJavaElement iJavaElement, int n) {
        try {
            ImageDescriptor imageDescriptor;
            IWorkbenchAdapter iWorkbenchAdapter;
            switch (iJavaElement.getElementType()) {
                case 10: {
                    return JavaPluginImages.DESC_MISC_PRIVATE;
                }
                case 9: {
                    IMethod iMethod = (IMethod)iJavaElement;
                    IType iType = iMethod.getDeclaringType();
                    int n2 = iMethod.getFlags();
                    return JavaElementImageProvider.getMethodImageDescriptor(JavaModelUtil.isInterfaceOrAnnotation(iType), n2);
                }
                case 8: {
                    IMember iMember = (IMember)iJavaElement;
                    IType iType = iMember.getDeclaringType();
                    return JavaElementImageProvider.getFieldImageDescriptor(JavaModelUtil.isInterfaceOrAnnotation(iType), iMember.getFlags());
                }
                case 14: {
                    return JavaPluginImages.DESC_OBJS_LOCAL_VARIABLE;
                }
                case 11: {
                    return JavaPluginImages.DESC_OBJS_PACKDECL;
                }
                case 13: {
                    return JavaPluginImages.DESC_OBJS_IMPDECL;
                }
                case 12: {
                    return JavaPluginImages.DESC_OBJS_IMPCONT;
                }
                case 7: {
                    IType iType = (IType)iJavaElement;
                    IType iType2 = iType.getDeclaringType();
                    boolean bl = iType2 != null;
                    boolean bl2 = bl && JavaModelUtil.isInterfaceOrAnnotation(iType2);
                    return JavaElementImageProvider.getTypeImageDescriptor(bl, bl2, iType.getFlags(), JavaElementImageProvider.useLightIcons(n));
                }
                case 3: {
                    IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iJavaElement;
                    if (!iPackageFragmentRoot.isArchive()) return JavaPluginImages.DESC_OBJS_PACKFRAG_ROOT;
                    IPath iPath = iPackageFragmentRoot.getSourceAttachmentPath();
                    if (iPackageFragmentRoot.isExternal()) {
                        if (iPath != null) return JavaPluginImages.DESC_OBJS_EXTJAR_WSRC;
                        return JavaPluginImages.DESC_OBJS_EXTJAR;
                    }
                    if (iPath != null) return JavaPluginImages.DESC_OBJS_JAR_WSRC;
                    return JavaPluginImages.DESC_OBJS_JAR;
                }
                case 4: {
                    return this.getPackageFragmentIcon(iJavaElement, n);
                }
                case 5: {
                    return JavaPluginImages.DESC_OBJS_CUNIT;
                }
                case 6: {
                    return JavaPluginImages.DESC_OBJS_CFILE;
                }
                case 2: {
                    ImageDescriptor imageDescriptor2;
                    IWorkbenchAdapter iWorkbenchAdapter2;
                    IJavaProject iJavaProject = (IJavaProject)iJavaElement;
                    if (!iJavaProject.getProject().isOpen()) return DESC_OBJ_PROJECT_CLOSED;
                    IProject iProject = iJavaProject.getProject();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((iWorkbenchAdapter2 = (IWorkbenchAdapter)iProject.getAdapter((Class)clazz)) == null || (imageDescriptor2 = iWorkbenchAdapter2.getImageDescriptor((Object)iProject)) == null) return DESC_OBJ_PROJECT;
                    return imageDescriptor2;
                }
                case 1: {
                    return JavaPluginImages.DESC_OBJS_JAVA_MODEL;
                }
                case 15: {
                    return JavaPluginImages.DESC_OBJS_LOCAL_VARIABLE;
                }
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iWorkbenchAdapter = (IWorkbenchAdapter)iJavaElement.getAdapter((Class)clazz)) == null || iWorkbenchAdapter instanceof JavaWorkbenchAdapter || (imageDescriptor = iWorkbenchAdapter.getImageDescriptor((Object)iJavaElement)) == null) return JavaPluginImages.DESC_OBJS_GHOST;
            return imageDescriptor;
        }
        catch (JavaModelException javaModelException) {
            if (javaModelException.isDoesNotExist()) {
                return JavaPluginImages.DESC_OBJS_UNKNOWN;
            }
            JavaPlugin.log(javaModelException);
            return JavaPluginImages.DESC_OBJS_GHOST;
        }
    }

    private static boolean isDefaultFlag(int n) {
        return !Flags.isPublic((int)n) && !Flags.isProtected((int)n) && !Flags.isPrivate((int)n);
    }

    protected ImageDescriptor getPackageFragmentIcon(IJavaElement iJavaElement, int n) throws JavaModelException {
        IPackageFragment iPackageFragment = (IPackageFragment)iJavaElement;
        boolean bl = false;
        try {
            bl = iPackageFragment.hasChildren();
        }
        catch (JavaModelException javaModelException) {}
        if (!bl && iPackageFragment.getNonJavaResources().length > 0) {
            return JavaPluginImages.DESC_OBJS_EMPTY_PACKAGE_RESOURCES;
        }
        if (!bl) {
            return JavaPluginImages.DESC_OBJS_EMPTY_PACKAGE;
        }
        return JavaPluginImages.DESC_OBJS_PACKAGE;
    }

    public void dispose() {
    }

    private int computeJavaAdornmentFlags(IJavaElement iJavaElement, int n) {
        int n2 = 0;
        if (JavaElementImageProvider.showOverlayIcons(n) && iJavaElement instanceof IMember) {
            try {
                int n3;
                IMember iMember = (IMember)iJavaElement;
                if (iJavaElement.getElementType() == 9 && ((IMethod)iJavaElement).isConstructor()) {
                    n2 |= 0x200;
                }
                if (Flags.isAbstract((int)(n3 = iMember.getFlags())) && JavaElementImageProvider.confirmAbstract(iMember)) {
                    n2 |= 1;
                }
                if (Flags.isFinal((int)n3) || JavaElementImageProvider.isInterfaceOrAnnotationField(iMember) || JavaElementImageProvider.isEnumConstant(iMember, n3)) {
                    n2 |= 2;
                }
                if (Flags.isSynchronized((int)n3) && JavaElementImageProvider.confirmSynchronized((IJavaElement)iMember)) {
                    n2 |= 4;
                }
                if (Flags.isStatic((int)n3) || JavaElementImageProvider.isInterfaceOrAnnotationFieldOrType(iMember) || JavaElementImageProvider.isEnumConstant(iMember, n3)) {
                    n2 |= 8;
                }
                if (Flags.isDeprecated((int)n3)) {
                    n2 |= 0x400;
                }
                if (iMember.getElementType() == 7 && JavaModelUtil.hasMainMethod((IType)iMember)) {
                    n2 |= 0x10;
                }
                if (iMember.getElementType() == 8) {
                    if (Flags.isVolatile((int)n3)) {
                        n2 |= 0x800;
                    }
                    if (Flags.isTransient((int)n3)) {
                        n2 |= 0x1000;
                    }
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return n2;
    }

    private static boolean confirmAbstract(IMember iMember) throws JavaModelException {
        if (iMember.getElementType() == 7) {
            return !JavaModelUtil.isInterfaceOrAnnotation((IType)iMember);
        }
        return !JavaModelUtil.isInterfaceOrAnnotation(iMember.getDeclaringType());
    }

    private static boolean isInterfaceOrAnnotationField(IMember iMember) throws JavaModelException {
        return false;
    }

    private static boolean isInterfaceOrAnnotationFieldOrType(IMember iMember) throws JavaModelException {
        return false;
    }

    private static boolean isEnumConstant(IMember iMember, int n) throws JavaModelException {
        return false;
    }

    private static boolean confirmSynchronized(IJavaElement iJavaElement) {
        return iJavaElement.getElementType() != 7;
    }

    public static ImageDescriptor getMethodImageDescriptor(boolean bl, int n) {
        if (Flags.isPublic((int)n) || bl) {
            return JavaPluginImages.DESC_MISC_PUBLIC;
        }
        if (Flags.isProtected((int)n)) {
            return JavaPluginImages.DESC_MISC_PROTECTED;
        }
        if (Flags.isPrivate((int)n)) {
            return JavaPluginImages.DESC_MISC_PRIVATE;
        }
        return JavaPluginImages.DESC_MISC_DEFAULT;
    }

    public static ImageDescriptor getFieldImageDescriptor(boolean bl, int n) {
        if (Flags.isPublic((int)n) || bl || Flags.isEnum((int)n)) {
            return JavaPluginImages.DESC_FIELD_PUBLIC;
        }
        if (Flags.isProtected((int)n)) {
            return JavaPluginImages.DESC_FIELD_PROTECTED;
        }
        if (Flags.isPrivate((int)n)) {
            return JavaPluginImages.DESC_FIELD_PRIVATE;
        }
        return JavaPluginImages.DESC_FIELD_DEFAULT;
    }

    public static ImageDescriptor getTypeImageDescriptor(boolean bl, boolean bl2, boolean bl3, int n) {
        return JavaElementImageProvider.getTypeImageDescriptor(bl2, bl3, bl ? n | 0x200 : n, false);
    }

    public static ImageDescriptor getTypeImageDescriptor(boolean bl, boolean bl2, int n, boolean bl3) {
        if (Flags.isEnum((int)n)) {
            if (bl3) {
                return JavaPluginImages.DESC_OBJS_ENUM_ALT;
            }
            if (bl) {
                return JavaElementImageProvider.getInnerEnumImageDescriptor(bl2, n);
            }
            return JavaElementImageProvider.getEnumImageDescriptor(n);
        }
        if (Flags.isAnnotation((int)n)) {
            if (bl3) {
                return JavaPluginImages.DESC_OBJS_ANNOTATION_ALT;
            }
            if (bl) {
                return JavaElementImageProvider.getInnerAnnotationImageDescriptor(bl2, n);
            }
            return JavaElementImageProvider.getAnnotationImageDescriptor(n);
        }
        if (Flags.isInterface((int)n)) {
            if (bl3) {
                return JavaPluginImages.DESC_OBJS_INTERFACEALT;
            }
            if (bl) {
                return JavaElementImageProvider.getInnerInterfaceImageDescriptor(bl2, n);
            }
            return JavaElementImageProvider.getInterfaceImageDescriptor(n);
        }
        if (bl3) {
            return JavaPluginImages.DESC_OBJS_CLASSALT;
        }
        if (bl) {
            return JavaElementImageProvider.getInnerClassImageDescriptor(bl2, n);
        }
        return JavaElementImageProvider.getClassImageDescriptor(n);
    }

    public static Image getDecoratedImage(ImageDescriptor imageDescriptor, int n, Point point) {
        return JavaPlugin.getImageDescriptorRegistry().get((ImageDescriptor)new JavaElementImageDescriptor(imageDescriptor, n, point));
    }

    private static ImageDescriptor getClassImageDescriptor(int n) {
        if (Flags.isPublic((int)n) || Flags.isProtected((int)n) || Flags.isPrivate((int)n)) {
            return JavaPluginImages.DESC_OBJS_CLASS;
        }
        return JavaPluginImages.DESC_OBJS_CLASS_DEFAULT;
    }

    private static ImageDescriptor getInnerClassImageDescriptor(boolean bl, int n) {
        if (Flags.isPublic((int)n) || bl) {
            return JavaPluginImages.DESC_OBJS_INNER_CLASS_PUBLIC;
        }
        if (Flags.isPrivate((int)n)) {
            return JavaPluginImages.DESC_OBJS_INNER_CLASS_PRIVATE;
        }
        if (Flags.isProtected((int)n)) {
            return JavaPluginImages.DESC_OBJS_INNER_CLASS_PROTECTED;
        }
        return JavaPluginImages.DESC_OBJS_INNER_CLASS_DEFAULT;
    }

    private static ImageDescriptor getEnumImageDescriptor(int n) {
        if (Flags.isPublic((int)n) || Flags.isProtected((int)n) || Flags.isPrivate((int)n)) {
            return JavaPluginImages.DESC_OBJS_ENUM;
        }
        return JavaPluginImages.DESC_OBJS_ENUM_DEFAULT;
    }

    private static ImageDescriptor getInnerEnumImageDescriptor(boolean bl, int n) {
        if (Flags.isPublic((int)n) || bl) {
            return JavaPluginImages.DESC_OBJS_ENUM;
        }
        if (Flags.isPrivate((int)n)) {
            return JavaPluginImages.DESC_OBJS_ENUM_PRIVATE;
        }
        if (Flags.isProtected((int)n)) {
            return JavaPluginImages.DESC_OBJS_ENUM_PROTECTED;
        }
        return JavaPluginImages.DESC_OBJS_ENUM_DEFAULT;
    }

    private static ImageDescriptor getAnnotationImageDescriptor(int n) {
        if (Flags.isPublic((int)n) || Flags.isProtected((int)n) || Flags.isPrivate((int)n)) {
            return JavaPluginImages.DESC_OBJS_ANNOTATION;
        }
        return JavaPluginImages.DESC_OBJS_ANNOTATION_DEFAULT;
    }

    private static ImageDescriptor getInnerAnnotationImageDescriptor(boolean bl, int n) {
        if (Flags.isPublic((int)n) || bl) {
            return JavaPluginImages.DESC_OBJS_ANNOTATION;
        }
        if (Flags.isPrivate((int)n)) {
            return JavaPluginImages.DESC_OBJS_ANNOTATION_PRIVATE;
        }
        if (Flags.isProtected((int)n)) {
            return JavaPluginImages.DESC_OBJS_ANNOTATION_PROTECTED;
        }
        return JavaPluginImages.DESC_OBJS_ANNOTATION_DEFAULT;
    }

    private static ImageDescriptor getInterfaceImageDescriptor(int n) {
        if (Flags.isPublic((int)n) || Flags.isProtected((int)n) || Flags.isPrivate((int)n)) {
            return JavaPluginImages.DESC_OBJS_INTERFACE;
        }
        return JavaPluginImages.DESC_OBJS_INTERFACE_DEFAULT;
    }

    private static ImageDescriptor getInnerInterfaceImageDescriptor(boolean bl, int n) {
        if (Flags.isPublic((int)n) || bl) {
            return JavaPluginImages.DESC_OBJS_INNER_INTERFACE_PUBLIC;
        }
        if (Flags.isPrivate((int)n)) {
            return JavaPluginImages.DESC_OBJS_INNER_INTERFACE_PRIVATE;
        }
        if (Flags.isProtected((int)n)) {
            return JavaPluginImages.DESC_OBJS_INNER_INTERFACE_PROTECTED;
        }
        return JavaPluginImages.DESC_OBJS_INTERFACE_DEFAULT;
    }
}

