/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.viewsupport;

import java.util.Iterator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredString;

public abstract class OwnerDrawSupport
implements Listener {
    private TextLayout fTextLayout;
    private final Control fControl;

    public OwnerDrawSupport(Control control) {
        this.fControl = control;
        this.fTextLayout = new TextLayout((Device)control.getDisplay());
        control.addListener(42, (Listener)this);
        control.addListener(40, (Listener)this);
        control.addListener(12, (Listener)this);
    }

    public abstract ColoredString getColoredLabel(Item var1);

    public abstract Color getColor(String var1, Display var2);

    public void handleEvent(Event event) {
        if (event.type == 42) {
            this.performPaint(event);
        } else if (event.type == 40) {
            this.performErase(event);
        } else if (event.type == 12) {
            this.dispose();
        }
    }

    private void performErase(Event event) {
        event.detail &= 0xFFFFFFEF;
    }

    private void performPaint(Event event) {
        boolean bl;
        Item item = (Item)event.item;
        GC gC = event.gc;
        ColoredString coloredString = this.getColoredLabel(item);
        boolean bl2 = bl = (event.detail & 2) != 0 && this.fControl.isFocusControl();
        if (item instanceof TreeItem) {
            TreeItem treeItem = (TreeItem)item;
            Image image = treeItem.getImage(event.index);
            if (image != null) {
                this.processImage(image, gC, treeItem.getImageBounds(event.index));
            }
            Rectangle rectangle = treeItem.getTextBounds(event.index);
            Font font = treeItem.getFont(event.index);
            this.processColoredLabel(coloredString, gC, rectangle, bl, font);
            Rectangle rectangle2 = treeItem.getBounds();
            if ((event.detail & 4) != 0) {
                gC.drawFocus(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            }
        } else if (item instanceof TableItem) {
            TableItem tableItem = (TableItem)item;
            Image image = tableItem.getImage(event.index);
            if (image != null) {
                this.processImage(image, gC, tableItem.getImageBounds(event.index));
            }
            Rectangle rectangle = tableItem.getTextBounds(event.index);
            Font font = tableItem.getFont(event.index);
            this.processColoredLabel(coloredString, gC, rectangle, bl, font);
            Rectangle rectangle3 = tableItem.getBounds();
            if ((event.detail & 4) != 0) {
                gC.drawFocus(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            }
        }
    }

    private void processImage(Image image, GC gC, Rectangle rectangle) {
        Rectangle rectangle2 = image.getBounds();
        int n = rectangle.x + Math.max(0, (rectangle.width - rectangle2.width) / 2);
        int n2 = rectangle.y + Math.max(0, (rectangle.height - rectangle2.height) / 2);
        gC.drawImage(image, n, n2);
    }

    private void processColoredLabel(ColoredString coloredString, GC gC, Rectangle rectangle, boolean bl, Font font) {
        Display display;
        String string = coloredString.getString();
        this.fTextLayout.setText(string);
        this.fTextLayout.setFont(font);
        if (!bl) {
            display = (Display)gC.getDevice();
            Iterator iterator = coloredString.getRanges();
            while (iterator.hasNext()) {
                ColoredString.StyleRange styleRange = (ColoredString.StyleRange)iterator.next();
                ColoredString.Style style = styleRange.style;
                if (style == null) continue;
                Color color = this.getColor(style.getForegroundColorName(), display);
                TextStyle textStyle = new TextStyle(null, color, null);
                this.fTextLayout.setStyle(textStyle, styleRange.offset, styleRange.offset + styleRange.length - 1);
            }
        }
        display = this.fTextLayout.getBounds();
        int n = rectangle.x;
        int n2 = rectangle.y + Math.max(0, (rectangle.height - display.height) / 2);
        this.fTextLayout.draw(gC, n, n2);
        this.fTextLayout.setText("");
    }

    public void dispose() {
        if (this.fTextLayout != null) {
            this.fTextLayout.dispose();
            this.fTextLayout = null;
        }
        if (!this.fControl.isDisposed()) {
            this.fControl.removeListener(42, (Listener)this);
            this.fControl.removeListener(40, (Listener)this);
            this.fControl.removeListener(12, (Listener)this);
        }
    }
}

