/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.viewsupport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;

public class ResourceToItemsMapper {
    private static final int NUMBER_LIST_REUSE = 10;
    private HashMap fResourceToItem = new HashMap();
    private Stack fReuseLists = new Stack();
    private IContentViewerAccessor fContentViewerAccess;

    public ResourceToItemsMapper(IContentViewerAccessor iContentViewerAccessor) {
        this.fContentViewerAccess = iContentViewerAccessor;
    }

    public void resourceChanged(IResource iResource) {
        Object v = this.fResourceToItem.get(iResource);
        if (v != null) {
            if (v instanceof Item) {
                this.updateItem((Item)v);
            } else {
                List list = (List)v;
                int n = 0;
                while (n < list.size()) {
                    this.updateItem((Item)list.get(n));
                    ++n;
                }
            }
        }
    }

    private void updateItem(Item item) {
        if (!item.isDisposed()) {
            this.fContentViewerAccess.doUpdateItem((Widget)item);
        }
    }

    public void addToMap(Object object, Item item) {
        IResource iResource = ResourceToItemsMapper.getCorrespondingResource(object);
        if (iResource != null) {
            Object v = this.fResourceToItem.get(iResource);
            if (v == null) {
                this.fResourceToItem.put(iResource, item);
            } else if (v instanceof Item) {
                if (v != item) {
                    List list = this.getNewList();
                    list.add(v);
                    list.add(item);
                    this.fResourceToItem.put(iResource, list);
                }
            } else {
                List list = (List)v;
                if (!list.contains(item)) {
                    list.add(item);
                }
            }
        }
    }

    public void removeFromMap(Object object, Item item) {
        IResource iResource = ResourceToItemsMapper.getCorrespondingResource(object);
        if (iResource != null) {
            Object v = this.fResourceToItem.get(iResource);
            if (v == null) {
                return;
            }
            if (v instanceof Item) {
                this.fResourceToItem.remove(iResource);
            } else {
                List list = (List)v;
                list.remove(item);
                if (list.isEmpty()) {
                    this.fResourceToItem.remove(list);
                    this.releaseList(list);
                }
            }
        }
    }

    private List getNewList() {
        if (!this.fReuseLists.isEmpty()) {
            return (List)this.fReuseLists.pop();
        }
        return new ArrayList(2);
    }

    private void releaseList(List list) {
        if (this.fReuseLists.size() < 10) {
            this.fReuseLists.push(list);
        }
    }

    public void clearMap() {
        this.fResourceToItem.clear();
    }

    public boolean isEmpty() {
        return this.fResourceToItem.isEmpty();
    }

    private static IResource getCorrespondingResource(Object object) {
        if (object instanceof IJavaElement) {
            ICompilationUnit iCompilationUnit;
            IJavaElement iJavaElement = (IJavaElement)object;
            IResource iResource = iJavaElement.getResource();
            if (iResource == null && (iCompilationUnit = (ICompilationUnit)iJavaElement.getAncestor(5)) != null) {
                iResource = iCompilationUnit.getResource();
            }
            return iResource;
        }
        if (object instanceof IResource) {
            return (IResource)object;
        }
        return null;
    }

    public static interface IContentViewerAccessor {
        public void doUpdateItem(Widget var1);
    }
}

