/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.viewsupport;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.wst.jsdt.core.IJarEntryResource;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageFragmentRootContainer;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public class StatusBarUpdater
implements ISelectionChangedListener {
    private final long LABEL_FLAGS = JavaElementLabels.DEFAULT_QUALIFIED | 0x40000000000L | 0x80000000000L | 1L | 2L | 0x20L | 0x10L | 0x4000L | 0x200000L;
    private IStatusLineManager fStatusLineManager;
    static /* synthetic */ Class class$0;

    public StatusBarUpdater(IStatusLineManager iStatusLineManager) {
        this.fStatusLineManager = iStatusLineManager;
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        String string = this.formatMessage(selectionChangedEvent.getSelection());
        this.fStatusLineManager.setMessage(string);
    }

    protected String formatMessage(ISelection iSelection) {
        if (iSelection instanceof IStructuredSelection && !iSelection.isEmpty()) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            int n = iStructuredSelection.size();
            if (n > 1) {
                return Messages.format(JavaUIMessages.StatusBarUpdater_num_elements_selected, String.valueOf(n));
            }
            Object object = iStructuredSelection.getFirstElement();
            if (object instanceof IJavaElement) {
                return this.formatJavaElementMessage((IJavaElement)object);
            }
            if (object instanceof IResource) {
                return this.formatResourceMessage((IResource)object);
            }
            if (object instanceof PackageFragmentRootContainer) {
                PackageFragmentRootContainer packageFragmentRootContainer = (PackageFragmentRootContainer)object;
                return String.valueOf(packageFragmentRootContainer.getLabel()) + JavaElementLabels.CONCAT_STRING + packageFragmentRootContainer.getJavaProject().getElementName();
            }
            if (object instanceof IJarEntryResource) {
                IJarEntryResource iJarEntryResource = (IJarEntryResource)object;
                StringBuffer stringBuffer = new StringBuffer(iJarEntryResource.getName());
                stringBuffer.append(JavaElementLabels.CONCAT_STRING);
                IPath iPath = iJarEntryResource.getFullPath();
                if (iPath.segmentCount() > 1) {
                    stringBuffer.append(iPath.removeLastSegments(1).makeRelative());
                    stringBuffer.append(JavaElementLabels.CONCAT_STRING);
                }
                JavaElementLabels.getPackageFragmentRootLabel(iJarEntryResource.getPackageFragmentRoot(), 0x40000000000L, stringBuffer);
                return stringBuffer.toString();
            }
            if (object instanceof IAdaptable) {
                IWorkbenchAdapter iWorkbenchAdapter;
                IAdaptable iAdaptable = (IAdaptable)object;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iWorkbenchAdapter = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                    return iWorkbenchAdapter.getLabel(object);
                }
            }
        }
        return "";
    }

    private String formatJavaElementMessage(IJavaElement iJavaElement) {
        return JavaElementLabels.getElementLabel(iJavaElement, this.LABEL_FLAGS);
    }

    private String formatResourceMessage(IResource iResource) {
        IContainer iContainer = iResource.getParent();
        if (iContainer != null && iContainer.getType() != 8) {
            return String.valueOf(iResource.getName()) + JavaElementLabels.CONCAT_STRING + iContainer.getFullPath().makeRelative().toString();
        }
        return iResource.getName();
    }
}

