/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.core.IClasspathAttribute;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.ClasspathAttributeConfigurationDescriptors;
import org.eclipse.wst.jsdt.ui.wizards.ClasspathAttributeConfiguration;

public abstract class BuildPathBasePage {
    private ClasspathAttributeConfigurationDescriptors fAttributeDescriptors = JavaPlugin.getDefault().getClasspathAttributeConfigurationDescriptors();

    protected boolean editCustomAttribute(Shell shell, CPListElementAttribute cPListElementAttribute) {
        IClasspathAttribute iClasspathAttribute;
        ClasspathAttributeConfiguration classpathAttributeConfiguration = this.fAttributeDescriptors.get(cPListElementAttribute.getKey());
        if (classpathAttributeConfiguration != null && (iClasspathAttribute = classpathAttributeConfiguration.performEdit(shell, cPListElementAttribute.getClasspathAttributeAccess())) != null) {
            cPListElementAttribute.setValue(iClasspathAttribute.getValue());
            return true;
        }
        return false;
    }

    protected boolean removeCustomAttribute(CPListElementAttribute cPListElementAttribute) {
        IClasspathAttribute iClasspathAttribute;
        ClasspathAttributeConfiguration classpathAttributeConfiguration = this.fAttributeDescriptors.get(cPListElementAttribute.getKey());
        if (classpathAttributeConfiguration != null && (iClasspathAttribute = classpathAttributeConfiguration.performRemove(cPListElementAttribute.getClasspathAttributeAccess())) != null) {
            cPListElementAttribute.setValue(iClasspathAttribute.getValue());
            return true;
        }
        return false;
    }

    protected boolean canEditCustomAttribute(CPListElementAttribute cPListElementAttribute) {
        ClasspathAttributeConfiguration classpathAttributeConfiguration = this.fAttributeDescriptors.get(cPListElementAttribute.getKey());
        if (classpathAttributeConfiguration != null) {
            return classpathAttributeConfiguration.canEdit(cPListElementAttribute.getClasspathAttributeAccess());
        }
        return false;
    }

    protected boolean canRemoveCustomAttribute(CPListElementAttribute cPListElementAttribute) {
        ClasspathAttributeConfiguration classpathAttributeConfiguration = this.fAttributeDescriptors.get(cPListElementAttribute.getKey());
        if (classpathAttributeConfiguration != null) {
            return classpathAttributeConfiguration.canRemove(cPListElementAttribute.getClasspathAttributeAccess());
        }
        return false;
    }

    public abstract List getSelection();

    public abstract void setSelection(List var1, boolean var2);

    public void addElement(CPListElement cPListElement) {
    }

    public abstract boolean isEntryKind(int var1);

    protected void filterAndSetSelection(List list) {
        ArrayList arrayList = new ArrayList(list.size());
        int n = list.size() - 1;
        while (n >= 0) {
            CPListElement cPListElement;
            Object e = list.get(n);
            if (e instanceof CPListElement && (cPListElement = (CPListElement)e).getParentContainer() == null && this.isEntryKind(cPListElement.getEntryKind())) {
                arrayList.add(e);
            }
            --n;
        }
        this.setSelection(arrayList, false);
    }

    public static void fixNestingConflicts(CPListElement[] cPListElementArray, CPListElement[] cPListElementArray2, Set set) {
        int n = 0;
        while (n < cPListElementArray.length) {
            BuildPathBasePage.addExclusionPatterns(cPListElementArray[n], cPListElementArray2, set);
            ++n;
        }
    }

    private static void addExclusionPatterns(CPListElement cPListElement, CPListElement[] cPListElementArray, Set set) {
        IPath iPath = cPListElement.getPath();
        int n = 0;
        while (n < cPListElementArray.length) {
            IPath iPath2;
            CPListElement cPListElement2 = cPListElementArray[n];
            if (cPListElement2.getEntryKind() == 3 && !(iPath2 = cPListElement2.getPath()).equals((Object)iPath)) {
                if (iPath2.isPrefixOf(iPath)) {
                    if (BuildPathBasePage.addToExclusions(iPath, cPListElement2)) {
                        set.add(cPListElement2);
                    }
                } else if (iPath.isPrefixOf(iPath2) && cPListElement.getEntryKind() == 3 && BuildPathBasePage.addToExclusions(iPath2, cPListElement)) {
                    set.add(cPListElement2);
                }
            }
            ++n;
        }
    }

    private static boolean addToExclusions(IPath iPath, CPListElement cPListElement) {
        IPath[] iPathArray = (IPath[])cPListElement.getAttribute("exclusion");
        if (!JavaModelUtil.isExcludedPath(iPath, iPathArray)) {
            IPath iPath2 = iPath.removeFirstSegments(cPListElement.getPath().segmentCount()).addTrailingSeparator();
            IPath[] iPathArray2 = new IPath[iPathArray.length + 1];
            System.arraycopy(iPathArray, 0, iPathArray2, 0, iPathArray.length);
            iPathArray2[iPathArray.length] = iPath2;
            cPListElement.setAttribute("exclusion", iPathArray2);
            return true;
        }
        return false;
    }

    protected boolean containsOnlyTopLevelEntries(List list) {
        if (list.size() == 0) {
            return true;
        }
        int n = 0;
        while (n < list.size()) {
            Object e = list.get(n);
            if (e instanceof CPListElement) {
                if (((CPListElement)e).getParentContainer() != null) {
                    return false;
                }
            } else {
                return false;
            }
            ++n;
        }
        return true;
    }

    public abstract void init(IJavaProject var1);

    public abstract Control getControl(Composite var1);

    public abstract void setFocus();

    public void aboutToShow() {
    }

    public void aboutToDispose() {
    }
}

