/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.wst.jsdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.wst.jsdt.ui.wizards.IClasspathContainerPageExtension;
import org.eclipse.wst.jsdt.ui.wizards.NewElementWizardPage;

public class ClasspathContainerDefaultPage
extends NewElementWizardPage
implements IClasspathContainerPage,
IClasspathContainerPageExtension {
    private StringDialogField fEntryField;
    private ArrayList fUsedPaths;

    public ClasspathContainerDefaultPage() {
        super("ClasspathContainerDefaultPage");
        this.setTitle(NewWizardMessages.ClasspathContainerDefaultPage_title);
        this.setDescription(NewWizardMessages.ClasspathContainerDefaultPage_description);
        this.setImageDescriptor(JavaPluginImages.DESC_WIZBAN_ADD_LIBRARY);
        this.fUsedPaths = new ArrayList();
        this.fEntryField = new StringDialogField();
        this.fEntryField.setLabelText(NewWizardMessages.ClasspathContainerDefaultPage_path_label);
        this.fEntryField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField dialogField) {
                ClasspathContainerDefaultPage.this.validatePath();
            }
        });
        this.validatePath();
    }

    private void validatePath() {
        StatusInfo statusInfo = new StatusInfo();
        String string = this.fEntryField.getText();
        if (string.length() == 0) {
            statusInfo.setError(NewWizardMessages.ClasspathContainerDefaultPage_path_error_enterpath);
        } else if (!Path.ROOT.isValidPath(string)) {
            statusInfo.setError(NewWizardMessages.ClasspathContainerDefaultPage_path_error_invalidpath);
        } else {
            Path path = new Path(string);
            if (path.segmentCount() == 0) {
                statusInfo.setError(NewWizardMessages.ClasspathContainerDefaultPage_path_error_needssegment);
            } else if (this.fUsedPaths.contains(path)) {
                statusInfo.setError(NewWizardMessages.ClasspathContainerDefaultPage_path_error_alreadyexists);
            }
        }
        this.updateStatus(statusInfo);
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        this.fEntryField.doFillIntoGrid(composite2, 2);
        LayoutUtil.setHorizontalGrabbing((Control)this.fEntryField.getTextControl(null));
        this.fEntryField.setFocus();
        this.setControl((Control)composite2);
        Dialog.applyDialogFont((Control)composite2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, "org.eclipse.wst.jsdt.ui.classpath_container_default_page_context");
    }

    public boolean finish() {
        return true;
    }

    public IClasspathEntry getSelection() {
        return JavaCore.newContainerEntry((IPath)new Path(this.fEntryField.getText()));
    }

    public void initialize(IJavaProject iJavaProject, IClasspathEntry[] iClasspathEntryArray) {
        int n = 0;
        while (n < iClasspathEntryArray.length) {
            IClasspathEntry iClasspathEntry = iClasspathEntryArray[n];
            if (iClasspathEntry.getEntryKind() == 5) {
                this.fUsedPaths.add(iClasspathEntry.getPath());
            }
            ++n;
        }
    }

    public void setSelection(IClasspathEntry iClasspathEntry) {
        if (iClasspathEntry != null) {
            this.fUsedPaths.remove(iClasspathEntry.getPath());
            this.fEntryField.setText(iClasspathEntry.getPath().toString());
        } else {
            this.fEntryField.setText("");
        }
    }
}

