/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.eclipse.wst.jsdt.internal.corext.buildpath.CPJavaProject;
import org.eclipse.wst.jsdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.util.SWTUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.wst.jsdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.FolderSelectionDialog;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringButtonDialogField;

public class OutputLocationDialog
extends StatusDialog {
    private StringButtonDialogField fContainerDialogField;
    private SelectionButtonDialogField fUseDefault;
    private SelectionButtonDialogField fUseSpecific;
    private IStatus fContainerFieldStatus;
    private IPath fOutputLocation;
    private final IProject fCurrProject;
    private final CPListElement fEntryToEdit;
    private final boolean fAllowInvalidClasspath;
    private CPJavaProject fCPJavaProject;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public OutputLocationDialog(Shell shell, CPListElement cPListElement, List list, IPath iPath, boolean bl) {
        super(shell);
        this.fEntryToEdit = cPListElement;
        this.fAllowInvalidClasspath = bl;
        this.setTitle(NewWizardMessages.OutputLocationDialog_title);
        this.fContainerFieldStatus = new StatusInfo();
        OutputLocationAdapter outputLocationAdapter = new OutputLocationAdapter();
        this.fUseDefault = new SelectionButtonDialogField(16);
        this.fUseDefault.setLabelText(Messages.format(NewWizardMessages.OutputLocationDialog_usedefault_label, iPath.makeRelative().toString()));
        this.fUseDefault.setDialogFieldListener(outputLocationAdapter);
        String string = Messages.format(NewWizardMessages.OutputLocationDialog_usespecific_label, cPListElement.getPath().segment(0));
        this.fUseSpecific = new SelectionButtonDialogField(16);
        this.fUseSpecific.setLabelText(string);
        this.fUseSpecific.setDialogFieldListener(outputLocationAdapter);
        this.fContainerDialogField = new StringButtonDialogField(outputLocationAdapter);
        this.fContainerDialogField.setButtonLabel(NewWizardMessages.OutputLocationDialog_location_button);
        this.fContainerDialogField.setDialogFieldListener(outputLocationAdapter);
        this.fUseSpecific.attachDialogField(this.fContainerDialogField);
        this.fCurrProject = cPListElement.getJavaProject().getProject();
        this.fCPJavaProject = new CPJavaProject(list, iPath);
        IPath iPath2 = (IPath)cPListElement.getAttribute("output");
        if (iPath2 == null) {
            this.fUseDefault.setSelection(true);
        } else {
            this.fUseSpecific.setSelection(true);
            this.fContainerDialogField.setText(iPath2.removeFirstSegments(1).makeRelative().toString());
        }
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        int n = this.convertWidthInCharsToPixels(70);
        int n2 = this.convertWidthInCharsToPixels(4);
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        composite3.setLayout((Layout)gridLayout);
        this.fUseDefault.doFillIntoGrid(composite3, 2);
        this.fUseSpecific.doFillIntoGrid(composite3, 2);
        Text text = this.fContainerDialogField.getTextControl(composite3);
        GridData gridData = new GridData();
        gridData.widthHint = n;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalIndent = n2;
        text.setLayoutData((Object)gridData);
        Button button = this.fContainerDialogField.getChangeControl(composite3);
        GridData gridData2 = new GridData();
        gridData2.widthHint = SWTUtil.getButtonWidthHint(button);
        button.setLayoutData((Object)gridData2);
        OutputLocationDialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    protected void doChangeControlPressed() {
        IContainer iContainer = this.chooseOutputLocation();
        if (iContainer != null) {
            this.fContainerDialogField.setText(iContainer.getProjectRelativePath().toString());
        }
    }

    protected void doStatusLineUpdate() {
        this.checkIfPathValid();
        this.updateStatus(this.fContainerFieldStatus);
    }

    protected void checkIfPathValid() {
        this.fOutputLocation = null;
        this.fContainerFieldStatus = StatusInfo.OK_STATUS;
        if (this.fUseDefault.isSelected()) {
            return;
        }
        String string = this.fContainerDialogField.getText();
        if (string.length() == 0) {
            this.fContainerFieldStatus = new StatusInfo(4, "");
            return;
        }
        IPath iPath = this.fCPJavaProject.getJavaProject().getProject().getFullPath();
        IPath iPath2 = iPath.append(string);
        try {
            this.fContainerFieldStatus = ClasspathModifier.checkSetOutputLocationPrecondition(this.fEntryToEdit, iPath2, this.fAllowInvalidClasspath, this.fCPJavaProject);
            if (this.fContainerFieldStatus.getSeverity() != 4) {
                this.fOutputLocation = iPath2;
            }
        }
        catch (CoreException coreException) {
            JavaPlugin.log(coreException);
        }
    }

    public IPath getOutputLocation() {
        return this.fOutputLocation;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.wst.jsdt.ui.output_location_dialog_context");
    }

    private IContainer chooseOutputLocation() {
        IWorkspaceRoot iWorkspaceRoot = this.fCurrProject.getWorkspace().getRoot();
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IFolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class[] classArray2 = classArray;
        IProject[] iProjectArray = iWorkspaceRoot.getProjects();
        ArrayList<IProject> arrayList = new ArrayList<IProject>(iProjectArray.length);
        int n = 0;
        while (n < iProjectArray.length) {
            if (!iProjectArray[n].equals((Object)this.fCurrProject)) {
                arrayList.add(iProjectArray[n]);
            }
            ++n;
        }
        TypedViewerFilter typedViewerFilter = new TypedViewerFilter(classArray2, arrayList.toArray());
        WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();
        WorkbenchContentProvider workbenchContentProvider = new WorkbenchContentProvider();
        IResource iResource = null;
        if (this.fOutputLocation != null) {
            iResource = iWorkspaceRoot.findMember(this.fOutputLocation);
        }
        FolderSelectionDialog folderSelectionDialog = new FolderSelectionDialog(this.getShell(), (ILabelProvider)workbenchLabelProvider, (ITreeContentProvider)workbenchContentProvider);
        folderSelectionDialog.setTitle(NewWizardMessages.OutputLocationDialog_ChooseOutputFolder_title);
        folderSelectionDialog.setValidator(new ISelectionStatusValidator(classArray2){
            ISelectionStatusValidator validator;
            {
                this.validator = new TypedElementSelectionValidator(classArray, false);
            }

            public IStatus validate(Object[] objectArray) {
                IStatus iStatus = this.validator.validate(objectArray);
                if (!iStatus.isOK()) {
                    return iStatus;
                }
                if (objectArray[0] instanceof IFolder) {
                    IFolder iFolder = (IFolder)objectArray[0];
                    try {
                        IStatus iStatus2 = ClasspathModifier.checkSetOutputLocationPrecondition(OutputLocationDialog.this.fEntryToEdit, iFolder.getFullPath(), OutputLocationDialog.this.fAllowInvalidClasspath, OutputLocationDialog.this.fCPJavaProject);
                        if (iStatus2.getSeverity() == 4) {
                            return iStatus2;
                        }
                    }
                    catch (CoreException coreException) {
                        JavaPlugin.log(coreException);
                    }
                    return new StatusInfo();
                }
                return new StatusInfo(4, "");
            }
        });
        folderSelectionDialog.setMessage(NewWizardMessages.OutputLocationDialog_ChooseOutputFolder_description);
        folderSelectionDialog.addFilter(typedViewerFilter);
        folderSelectionDialog.setInput(iWorkspaceRoot);
        folderSelectionDialog.setInitialSelection(iResource);
        folderSelectionDialog.setComparator((ViewerComparator)new ResourceComparator(1));
        if (folderSelectionDialog.open() == 0) {
            return (IContainer)folderSelectionDialog.getFirstResult();
        }
        return null;
    }

    private class OutputLocationAdapter
    implements IDialogFieldListener,
    IStringButtonAdapter {
        private OutputLocationAdapter() {
        }

        public void dialogFieldChanged(DialogField dialogField) {
            OutputLocationDialog.this.doStatusLineUpdate();
        }

        public void changeControlPressed(DialogField dialogField) {
            OutputLocationDialog.this.doChangeControlPressed();
        }
    }
}

