/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.buildpath.BuildpathDelta;
import org.eclipse.wst.jsdt.internal.corext.buildpath.CPJavaProject;
import org.eclipse.wst.jsdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.OutputLocationDialog;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage.BuildpathModifierAction;

public class EditOutputFolderAction
extends BuildpathModifierAction {
    private final IRunnableContext fContext;
    private boolean fShowOutputFolders;

    public EditOutputFolderAction(IWorkbenchSite iWorkbenchSite) {
        this(iWorkbenchSite, null, (IRunnableContext)PlatformUI.getWorkbench().getProgressService());
        this.fShowOutputFolders = true;
    }

    public EditOutputFolderAction(IRunnableContext iRunnableContext, ISetSelectionTarget iSetSelectionTarget) {
        this(null, iSetSelectionTarget, iRunnableContext);
    }

    private EditOutputFolderAction(IWorkbenchSite iWorkbenchSite, ISetSelectionTarget iSetSelectionTarget, IRunnableContext iRunnableContext) {
        super(iWorkbenchSite, iSetSelectionTarget, 7);
        this.fContext = iRunnableContext;
        this.fShowOutputFolders = false;
        this.setText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_EditOutput_label);
        this.setImageDescriptor(JavaPluginImages.DESC_ELCL_CONFIGURE_OUTPUT_FOLDER);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_EditOutput_tooltip);
        this.setDisabledImageDescriptor(JavaPluginImages.DESC_DLCL_CONFIGURE_OUTPUT_FOLDER);
    }

    public String getDetailedDescription() {
        return NewWizardMessages.PackageExplorerActionGroup_FormText_EditOutputFolder;
    }

    public void showOutputFolders(boolean bl) {
        this.fShowOutputFolders = bl;
    }

    public void run() {
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            IJavaProject iJavaProject;
            Shell shell = this.getShell();
            CPListElement cPListElement = null;
            Object e = this.getSelectedElements().get(0);
            if (e instanceof IJavaProject) {
                iJavaProject = (IJavaProject)e;
                object4 = ClasspathModifier.getClasspathEntryFor(iJavaProject.getPath(), iJavaProject, 3);
                cPListElement = CPListElement.createFromExisting((IClasspathEntry)object4, iJavaProject);
            } else if (e instanceof IPackageFragmentRoot) {
                object4 = (IPackageFragmentRoot)e;
                iJavaProject = object4.getJavaProject();
                object3 = ClasspathModifier.getClasspathEntryFor(object4.getPath(), iJavaProject, 3);
                cPListElement = CPListElement.createFromExisting(object3, iJavaProject);
            } else if (e instanceof CPListElementAttribute) {
                object4 = (CPListElementAttribute)e;
                cPListElement = ((CPListElementAttribute)object4).getParent();
                iJavaProject = cPListElement.getJavaProject();
            } else {
                return;
            }
            object4 = ClasspathModifier.getExistingEntries(iJavaProject);
            object3 = ClasspathModifier.getClasspathEntry((List)object4, cPListElement);
            OutputLocationDialog outputLocationDialog = new OutputLocationDialog(shell, (CPListElement)object3, (List)object4, iJavaProject.getOutputLocation(), false);
            if (outputLocationDialog.open() != 0) {
                return;
            }
            CPJavaProject cPJavaProject = CPJavaProject.createFromExisting(iJavaProject);
            BuildpathDelta buildpathDelta = ClasspathModifier.setOutputLocation(cPJavaProject.getCPElement((CPListElement)object3), outputLocationDialog.getOutputLocation(), false, cPJavaProject);
            IFolder iFolder = this.getOldOutputFolder(buildpathDelta);
            if (iFolder != null) {
                object2 = Messages.format(NewWizardMessages.EditOutputFolderAction_DeleteOldOutputFolderQuestion, iFolder.getLocation().toString());
                object = MessageDialog.openQuestion((Shell)this.getShell(), (String)NewWizardMessages.OutputLocationDialog_title, (String)object2) ? iFolder : null;
            } else {
                object = null;
            }
            try {
                object2 = new IRunnableWithProgress((IFolder)object, cPJavaProject, buildpathDelta, (CPListElement)object3){
                    private final /* synthetic */ IFolder val$folderToDelete;
                    private final /* synthetic */ CPJavaProject val$cpProject;
                    private final /* synthetic */ BuildpathDelta val$delta;
                    private final /* synthetic */ CPListElement val$element;
                    {
                        this.val$folderToDelete = iFolder;
                        this.val$cpProject = cPJavaProject;
                        this.val$delta = buildpathDelta;
                        this.val$element = cPListElement;
                    }

                    /*
                     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                        try {
                            try {
                                iProgressMonitor.beginTask(NewWizardMessages.EditOutputFolderAction_ProgressMonitorDescription, 50 + (this.val$folderToDelete == null ? 0 : 10));
                                ClasspathModifier.commitClassPath(this.val$cpProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 50));
                                if (this.val$folderToDelete != null) {
                                    this.val$folderToDelete.delete(true, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 10));
                                }
                                EditOutputFolderAction.this.informListeners(this.val$delta);
                                EditOutputFolderAction.this.selectAndReveal((ISelection)new StructuredSelection((Object)JavaCore.create((IResource)this.val$element.getResource())));
                            }
                            catch (CoreException coreException) {
                                throw new InvocationTargetException(coreException);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var3_4 = null;
                            iProgressMonitor.done();
                            throw throwable;
                        }
                        {
                            Object var3_5 = null;
                        }
                        iProgressMonitor.done();
                    }
                };
                this.fContext.run(false, false, (IRunnableWithProgress)object2);
            }
            catch (InvocationTargetException invocationTargetException) {
                JavaPlugin.log(invocationTargetException);
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (CoreException coreException) {
            this.showExceptionDialog(coreException, NewWizardMessages.EditOutputFolderAction_ErrorDescription);
        }
    }

    private IFolder getOldOutputFolder(BuildpathDelta buildpathDelta) {
        IResource[] iResourceArray = buildpathDelta.getDeletedResources();
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        int n = 0;
        while (n < iResourceArray.length) {
            if (iResourceArray[n] instanceof IFolder && iResourceArray[n].exists()) {
                arrayList.add(iResourceArray[n]);
            }
            ++n;
        }
        if (arrayList.size() > 0) {
            if (arrayList.size() > 1) {
                String string = "Found more then one existing folders:";
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    IFolder iFolder = (IFolder)iterator.next();
                    string = String.valueOf(string) + "\n" + iFolder.toString();
                }
                Assert.isTrue((boolean)false, (String)string);
            }
            return (IFolder)arrayList.get(0);
        }
        return null;
    }

    protected boolean canHandle(IStructuredSelection iStructuredSelection) {
        Object object;
        block12: {
            block9: {
                IJavaProject iJavaProject;
                IPackageFragmentRoot iPackageFragmentRoot;
                block11: {
                    block10: {
                        if (!this.fShowOutputFolders) {
                            return false;
                        }
                        if (iStructuredSelection.size() != 1) {
                            return false;
                        }
                        object = iStructuredSelection.getFirstElement();
                        try {
                            if (!(object instanceof IPackageFragmentRoot)) break block9;
                            iPackageFragmentRoot = (IPackageFragmentRoot)object;
                            if (iPackageFragmentRoot.getKind() == 1) break block10;
                            return false;
                        }
                        catch (JavaModelException javaModelException) {
                            return false;
                        }
                    }
                    iJavaProject = iPackageFragmentRoot.getJavaProject();
                    if (iJavaProject != null) break block11;
                    return false;
                }
                IClasspathEntry iClasspathEntry = ClasspathModifier.getClasspathEntryFor(iPackageFragmentRoot.getPath(), iJavaProject, 3);
                return iClasspathEntry != null;
            }
            if (!(object instanceof IJavaProject)) break block12;
            IJavaProject iJavaProject = (IJavaProject)object;
            return ClasspathModifier.isSourceFolder(iJavaProject);
        }
        if (object instanceof CPListElementAttribute) {
            CPListElementAttribute cPListElementAttribute = (CPListElementAttribute)object;
            return cPListElementAttribute.getKey() == "output";
        }
        return false;
    }
}

