/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage.BuildpathModifierAction;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage.DialogPackageExplorerActionGroup;

public final class HintTextGroup
implements ISelectionChangedListener {
    private Composite fTopComposite;
    private DialogPackageExplorerActionGroup fActionGroup;
    private List fNewFolders = new ArrayList();
    private HashMap fImageMap = new HashMap();

    public Composite createControl(Composite composite) {
        this.fTopComposite = new Composite(composite, 0);
        this.fTopComposite.setFont(composite.getFont());
        GridData gridData = new GridData(1808);
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        gridData.heightHint = pixelConverter.convertHeightInCharsToPixels(12);
        gridData.widthHint = pixelConverter.convertWidthInCharsToPixels(25);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.fTopComposite.setLayout((Layout)gridLayout);
        this.fTopComposite.setLayoutData((Object)gridData);
        this.fTopComposite.setData(null);
        this.fTopComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                Collection collection = HintTextGroup.this.fImageMap.values();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Image image = (Image)iterator.next();
                    image.dispose();
                }
            }
        });
        return this.fTopComposite;
    }

    private Shell getShell() {
        return JavaPlugin.getActiveWorkbenchShell();
    }

    public void setActionGroup(DialogPackageExplorerActionGroup dialogPackageExplorerActionGroup) {
        this.fActionGroup = dialogPackageExplorerActionGroup;
    }

    private FormText createFormText(Composite composite, String string) {
        FormText formText;
        FormToolkit formToolkit = new FormToolkit(this.getShell().getDisplay());
        try {
            FormText formText2 = formToolkit.createFormText(composite, true);
            formText2.setFont(composite.getFont());
            try {
                formText2.setText(string, true, false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                formText2.setText(illegalArgumentException.getMessage(), false, false);
                JavaPlugin.log(illegalArgumentException);
            }
            formText2.marginHeight = 2;
            formText2.marginWidth = 0;
            formText2.setBackground(null);
            formText2.setLayoutData((Object)new TableWrapData(256));
            formText = formText2;
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            formToolkit.dispose();
            throw throwable;
        }
        formToolkit.dispose();
        return formText;
    }

    private void createLabel(Composite composite, String string, final BuildpathModifierAction buildpathModifierAction) {
        FormText formText = this.createFormText(composite, string);
        Image image = (Image)this.fImageMap.get(buildpathModifierAction.getId());
        if (image == null) {
            image = buildpathModifierAction.getImageDescriptor().createImage();
            this.fImageMap.put(buildpathModifierAction.getId(), image);
        }
        formText.setImage("defaultImage", image);
        formText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                buildpathModifierAction.run();
            }
        });
    }

    void handleFolderCreation(List list) {
        if (list.size() == 1) {
            try {
                this.fNewFolders.add(((IPackageFragmentRoot)list.get(0)).getCorrespondingResource());
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
            }
        }
    }

    public List getCreatedResources() {
        return this.fNewFolders;
    }

    public void resetCreatedResources() {
        this.fNewFolders.clear();
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        if (selectionChangedEvent.getSelection() instanceof StructuredSelection) {
            this.handlePostSelectionChange((StructuredSelection)selectionChangedEvent.getSelection());
        } else {
            this.handlePostSelectionChange(StructuredSelection.EMPTY);
        }
    }

    private void handlePostSelectionChange(StructuredSelection structuredSelection) {
        BuildpathModifierAction[] buildpathModifierActionArray = this.fActionGroup.getHintTextGroupActions();
        String[] stringArray = new String[buildpathModifierActionArray.length];
        int n = 0;
        while (n < buildpathModifierActionArray.length) {
            stringArray[n] = buildpathModifierActionArray[n].getDetailedDescription();
            ++n;
        }
        Composite composite = (Composite)this.fTopComposite.getData();
        if (composite != null && composite.getParent() != null) {
            composite.getParent().dispose();
        }
        PixelConverter pixelConverter = new PixelConverter((Control)this.fTopComposite);
        ScrolledPageContent scrolledPageContent = new ScrolledPageContent(this.fTopComposite, 512);
        scrolledPageContent.getVerticalBar().setIncrement(5);
        GridData gridData = new GridData(1808);
        gridData.heightHint = pixelConverter.convertHeightInCharsToPixels(12);
        gridData.widthHint = pixelConverter.convertWidthInCharsToPixels(25);
        scrolledPageContent.setLayoutData(gridData);
        composite = scrolledPageContent.getBody();
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        tableWrapLayout.leftMargin = 0;
        tableWrapLayout.rightMargin = 0;
        composite.setLayout((Layout)tableWrapLayout);
        gridData = new GridData(1808);
        gridData.heightHint = pixelConverter.convertHeightInCharsToPixels(12);
        gridData.widthHint = pixelConverter.convertWidthInCharsToPixels(25);
        composite.setLayoutData((Object)gridData);
        this.fTopComposite.setData((Object)composite);
        if (this.noContextHelpAvailable(buildpathModifierActionArray)) {
            String string = this.noAction((ISelection)structuredSelection);
            this.createFormText(composite, Messages.format(NewWizardMessages.HintTextGroup_NoAction, string));
            this.fTopComposite.layout(true);
            return;
        }
        int n2 = 0;
        while (n2 < buildpathModifierActionArray.length) {
            this.createLabel(composite, stringArray[n2], buildpathModifierActionArray[n2]);
            ++n2;
        }
        this.fTopComposite.layout(true);
    }

    private String noAction(ISelection iSelection) {
        if (iSelection instanceof StructuredSelection) {
            return this.noAction(((StructuredSelection)iSelection).toList());
        }
        return this.noAction(Collections.EMPTY_LIST);
    }

    private String noAction(List list) {
        if (list.size() == 0) {
            return NewWizardMessages.PackageExplorerActionGroup_NoAction_NullSelection;
        }
        if (list.size() == 1) {
            return NewWizardMessages.PackageExplorerActionGroup_NoAction_NoReason;
        }
        return NewWizardMessages.PackageExplorerActionGroup_NoAction_MultiSelection;
    }

    private boolean noContextHelpAvailable(BuildpathModifierAction[] buildpathModifierActionArray) {
        int n;
        if (buildpathModifierActionArray.length == 0) {
            return true;
        }
        if (buildpathModifierActionArray.length == 1 && (n = Integer.parseInt(buildpathModifierActionArray[0].getId())) == 5) {
            return true;
        }
        if (buildpathModifierActionArray.length == 2) {
            n = Integer.parseInt(buildpathModifierActionArray[0].getId());
            int n2 = Integer.parseInt(buildpathModifierActionArray[1].getId());
            if (n2 == 6 && n == 5) {
                return true;
            }
        }
        return false;
    }
}

