/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.workingsets;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.wst.jsdt.internal.ui.workingsets.ConfigureWorkingSetAssignementAction;
import org.eclipse.wst.jsdt.internal.ui.workingsets.IWorkingSetActionGroup;
import org.eclipse.wst.jsdt.internal.ui.workingsets.OpenPropertiesWorkingSetAction;
import org.eclipse.wst.jsdt.internal.ui.workingsets.ViewAction;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetFilterActionGroup;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetShowActionGroup;

public class ViewActionGroup
extends ActionGroup {
    public static final int SHOW_PROJECTS = 1;
    public static final int SHOW_WORKING_SETS = 2;
    public static final String MODE_CHANGED;
    private static final Integer INT_SHOW_PROJECTS;
    private static final Integer INT_SHOW_WORKING_SETS;
    private IPropertyChangeListener fChangeListener;
    private int fMode;
    private IMenuManager fMenuManager;
    private IWorkingSetActionGroup fActiveActionGroup;
    private final WorkingSetShowActionGroup fShowActionGroup;
    private final WorkingSetFilterActionGroup fFilterActionGroup;
    private final ConfigureWorkingSetAssignementAction fWorkingSetAssignementAction;
    private final OpenPropertiesWorkingSetAction fEditWorkingSetGroupAction;
    private final IWorkbenchPartSite fSite;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.internal.ui.workingsets.ViewActionGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        MODE_CHANGED = String.valueOf(clazz.getName()) + ".mode_changed";
        INT_SHOW_PROJECTS = new Integer(1);
        INT_SHOW_WORKING_SETS = new Integer(2);
    }

    public ViewActionGroup(int n, IPropertyChangeListener iPropertyChangeListener, IWorkbenchPartSite iWorkbenchPartSite) {
        this.fChangeListener = iPropertyChangeListener;
        this.fSite = iWorkbenchPartSite;
        if (this.fChangeListener == null) {
            this.fChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                }
            };
        }
        this.fFilterActionGroup = new WorkingSetFilterActionGroup(iWorkbenchPartSite, this.fChangeListener);
        this.fShowActionGroup = new WorkingSetShowActionGroup(iWorkbenchPartSite);
        this.fWorkingSetAssignementAction = new ConfigureWorkingSetAssignementAction((IWorkbenchSite)iWorkbenchPartSite);
        this.fEditWorkingSetGroupAction = new OpenPropertiesWorkingSetAction((IWorkbenchSite)iWorkbenchPartSite);
        ISelectionProvider iSelectionProvider = iWorkbenchPartSite.getSelectionProvider();
        iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.fWorkingSetAssignementAction);
        iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.fEditWorkingSetGroupAction);
        this.fMode = n;
        this.fActiveActionGroup = this.showWorkingSets() ? this.fShowActionGroup : this.fFilterActionGroup;
    }

    public void dispose() {
        this.fFilterActionGroup.dispose();
        this.fShowActionGroup.dispose();
        this.fChangeListener = null;
        ISelectionProvider iSelectionProvider = this.fSite.getSelectionProvider();
        iSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.fWorkingSetAssignementAction);
        iSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.fEditWorkingSetGroupAction);
        super.dispose();
    }

    public void setWorkingSetModel(WorkingSetModel workingSetModel) {
        this.fShowActionGroup.setWorkingSetMode(workingSetModel);
        this.fWorkingSetAssignementAction.setWorkingSetModel(workingSetModel);
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        if (this.fWorkingSetAssignementAction.isEnabled()) {
            iMenuManager.appendToGroup("group.build", (IAction)this.fWorkingSetAssignementAction);
        }
        if (this.fEditWorkingSetGroupAction.isEnabled()) {
            iMenuManager.appendToGroup("group.build", (IAction)this.fEditWorkingSetGroupAction);
        }
    }

    public void fillActionBars(IActionBars iActionBars) {
        super.fillActionBars(iActionBars);
        this.fMenuManager = iActionBars.getMenuManager();
        this.fillViewMenu(this.fMenuManager);
        if (this.fActiveActionGroup == null) {
            this.fActiveActionGroup = this.fFilterActionGroup;
        }
        ((ActionGroup)this.fActiveActionGroup).fillActionBars(iActionBars);
    }

    private void fillViewMenu(IMenuManager iMenuManager) {
        MenuManager menuManager = new MenuManager(WorkingSetMessages.ViewActionGroup_show_label);
        this.fillShowMenu((IMenuManager)menuManager);
        iMenuManager.add((IContributionItem)menuManager);
        iMenuManager.add((IContributionItem)new Separator("working_set_action_group"));
    }

    private void fillShowMenu(IMenuManager iMenuManager) {
        ViewAction viewAction = new ViewAction(this, 1);
        viewAction.setText(WorkingSetMessages.ViewActionGroup_projects_label);
        iMenuManager.add((IAction)viewAction);
        ViewAction viewAction2 = new ViewAction(this, 2);
        viewAction2.setText(WorkingSetMessages.ViewActionGroup_workingSets_label);
        iMenuManager.add((IAction)viewAction2);
        if (this.fMode == 1) {
            viewAction.setChecked(true);
        } else {
            viewAction2.setChecked(true);
        }
    }

    public void fillFilters(StructuredViewer structuredViewer) {
        ViewerFilter viewerFilter = this.fFilterActionGroup.getWorkingSetFilter();
        if (this.showProjects()) {
            structuredViewer.addFilter(viewerFilter);
        } else if (this.showWorkingSets()) {
            structuredViewer.removeFilter(viewerFilter);
        }
    }

    public void setMode(int n) {
        PropertyChangeEvent propertyChangeEvent;
        this.fMode = n;
        this.fActiveActionGroup.cleanViewMenu(this.fMenuManager);
        if (n == 1) {
            this.fActiveActionGroup = this.fFilterActionGroup;
            propertyChangeEvent = new PropertyChangeEvent((Object)this, MODE_CHANGED, (Object)INT_SHOW_WORKING_SETS, (Object)INT_SHOW_PROJECTS);
        } else {
            this.fActiveActionGroup = this.fShowActionGroup;
            propertyChangeEvent = new PropertyChangeEvent((Object)this, MODE_CHANGED, (Object)INT_SHOW_PROJECTS, (Object)INT_SHOW_WORKING_SETS);
        }
        this.fActiveActionGroup.fillViewMenu(this.fMenuManager);
        this.fMenuManager.updateAll(true);
        if (this.fChangeListener != null) {
            this.fChangeListener.propertyChange(propertyChangeEvent);
        }
    }

    public WorkingSetFilterActionGroup getFilterGroup() {
        return this.fFilterActionGroup;
    }

    public void restoreState(IMemento iMemento) {
        this.fFilterActionGroup.restoreState(iMemento);
    }

    public void saveState(IMemento iMemento) {
        this.fFilterActionGroup.saveState(iMemento);
    }

    private boolean showProjects() {
        return this.fMode == 1;
    }

    private boolean showWorkingSets() {
        return this.fMode == 2;
    }
}

