/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.workingsets;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.internal.ui.workingsets.SimpleWorkingSetSelectionDialog;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetMessages;

public class WorkingSetConfigurationBlock {
    private static final String WORKINGSET_SELECTION_HISTORY = "workingset_selection_history";
    private static final int MAX_HISTORY_SIZE = 5;
    private Label fLabel;
    private Combo fWorkingSetCombo;
    private Button fConfigure;
    private IWorkingSet[] fSelectedWorkingSets;
    private String fMessage;
    private Button fEnableButton;
    private ArrayList fSelectionHistory;
    private final IDialogSettings fSettings;
    private final String fEnableButtonText;
    private final String[] fWorkingSetIds;

    public static IWorkingSet[] getSelectedWorkingSet(IStructuredSelection iStructuredSelection) {
        if (!(iStructuredSelection instanceof ITreeSelection)) {
            return null;
        }
        ITreeSelection iTreeSelection = (ITreeSelection)iStructuredSelection;
        if (iTreeSelection.isEmpty()) {
            return null;
        }
        List list = iTreeSelection.toList();
        if (list.size() == 1) {
            Object e = list.get(0);
            TreePath[] treePathArray = iTreeSelection.getPathsFor(e);
            if (treePathArray.length != 1) {
                return null;
            }
            TreePath treePath = treePathArray[0];
            if (treePath.getSegmentCount() == 0) {
                return null;
            }
            Object object = treePath.getSegment(0);
            if (!(object instanceof IWorkingSet)) {
                return null;
            }
            return new IWorkingSet[]{(IWorkingSet)object};
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof IWorkingSet)) continue;
            arrayList.add(e);
        }
        return arrayList.toArray(new IWorkingSet[arrayList.size()]);
    }

    public static void addToWorkingSets(IAdaptable iAdaptable, IWorkingSet[] iWorkingSetArray) {
        int n = 0;
        while (n < iWorkingSetArray.length) {
            IWorkingSet iWorkingSet = iWorkingSetArray[n];
            IAdaptable[] iAdaptableArray = iWorkingSet.adaptElements(new IAdaptable[]{iAdaptable});
            if (iAdaptableArray.length == 1) {
                IAdaptable[] iAdaptableArray2 = iWorkingSet.getElements();
                IAdaptable[] iAdaptableArray3 = new IAdaptable[iAdaptableArray2.length + 1];
                System.arraycopy(iAdaptableArray2, 0, iAdaptableArray3, 0, iAdaptableArray2.length);
                iAdaptableArray3[iAdaptableArray3.length - 1] = iAdaptableArray[0];
                iWorkingSet.setElements(iAdaptableArray3);
            }
            ++n;
        }
    }

    public static IWorkingSet[] filter(IWorkingSet[] iWorkingSetArray, String[] stringArray) {
        ArrayList<IWorkingSet> arrayList = new ArrayList<IWorkingSet>();
        int n = 0;
        while (n < iWorkingSetArray.length) {
            if (WorkingSetConfigurationBlock.accept(iWorkingSetArray[n], stringArray)) {
                arrayList.add(iWorkingSetArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new IWorkingSet[arrayList.size()]);
    }

    private static boolean accept(IWorkingSet iWorkingSet, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(iWorkingSet.getId())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public WorkingSetConfigurationBlock(String[] stringArray, String string, IDialogSettings iDialogSettings) {
        Assert.isNotNull((Object)stringArray);
        Assert.isNotNull((Object)string);
        Assert.isNotNull((Object)iDialogSettings);
        this.fWorkingSetIds = stringArray;
        this.fEnableButtonText = string;
        this.fSelectedWorkingSets = new IWorkingSet[0];
        this.fSettings = iDialogSettings;
        this.fSelectionHistory = this.loadSelectionHistory(iDialogSettings, stringArray);
    }

    public void setDialogMessage(String string) {
        this.fMessage = string;
    }

    public void setSelection(IWorkingSet[] iWorkingSetArray) {
        if (iWorkingSetArray == null) {
            iWorkingSetArray = new IWorkingSet[]{};
        }
        this.fSelectedWorkingSets = iWorkingSetArray;
        if (this.fWorkingSetCombo != null) {
            this.updateSelectedWorkingSets();
        }
    }

    public IWorkingSet[] getSelectedWorkingSets() {
        if (this.fEnableButton.getSelection()) {
            return this.fSelectedWorkingSets;
        }
        return new IWorkingSet[0];
    }

    public void createContent(final Composite composite) {
        int n = 3;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(4, 128, true, false));
        composite2.setLayout((Layout)new GridLayout(n, false));
        this.fEnableButton = new Button(composite2, 32);
        this.fEnableButton.setText(this.fEnableButtonText);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = n;
        this.fEnableButton.setLayoutData((Object)gridData);
        this.fEnableButton.setSelection(this.fSelectedWorkingSets.length > 0);
        this.fLabel = new Label(composite2, 0);
        this.fLabel.setText(WorkingSetMessages.WorkingSetConfigurationBlock_WorkingSetText_name);
        this.fWorkingSetCombo = new Combo(composite2, 2056);
        GridData gridData2 = new GridData(4, 0x1000000, true, false);
        gridData2.horizontalSpan = n - 2;
        gridData2.horizontalIndent = 0;
        this.fWorkingSetCombo.setLayoutData((Object)gridData2);
        this.fConfigure = new Button(composite2, 8);
        this.fConfigure.setText(WorkingSetMessages.WorkingSetConfigurationBlock_SelectWorkingSet_button);
        GridData gridData3 = new GridData(16384, 0x1000000, false, false);
        gridData3.widthHint = WorkingSetConfigurationBlock.getButtonWidthHint(this.fConfigure);
        this.fConfigure.setLayoutData((Object)gridData3);
        this.fConfigure.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SimpleWorkingSetSelectionDialog simpleWorkingSetSelectionDialog = new SimpleWorkingSetSelectionDialog(composite.getShell(), WorkingSetConfigurationBlock.this.fWorkingSetIds, WorkingSetConfigurationBlock.this.fSelectedWorkingSets);
                if (WorkingSetConfigurationBlock.this.fMessage != null) {
                    simpleWorkingSetSelectionDialog.setMessage(WorkingSetConfigurationBlock.this.fMessage);
                }
                if (simpleWorkingSetSelectionDialog.open() == 0) {
                    IWorkingSet[] iWorkingSetArray = simpleWorkingSetSelectionDialog.getSelection();
                    if (iWorkingSetArray != null && iWorkingSetArray.length > 0) {
                        WorkingSetConfigurationBlock.this.fSelectedWorkingSets = iWorkingSetArray;
                        PlatformUI.getWorkbench().getWorkingSetManager().addRecentWorkingSet(iWorkingSetArray[0]);
                    } else {
                        WorkingSetConfigurationBlock.this.fSelectedWorkingSets = new IWorkingSet[0];
                    }
                    WorkingSetConfigurationBlock.this.updateWorkingSetSelection();
                }
            }
        });
        this.fEnableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WorkingSetConfigurationBlock.this.updateEnableState(WorkingSetConfigurationBlock.this.fEnableButton.getSelection());
            }
        });
        this.updateEnableState(this.fEnableButton.getSelection());
        this.fWorkingSetCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WorkingSetConfigurationBlock.this.updateSelectedWorkingSets();
            }
        });
        this.fWorkingSetCombo.setItems(this.getHistoryEntries());
        if (this.fSelectedWorkingSets.length == 0 && this.fSelectionHistory.size() > 0) {
            this.fWorkingSetCombo.select(this.historyIndex((String)this.fSelectionHistory.get(0)));
            this.updateSelectedWorkingSets();
        } else {
            this.updateWorkingSetSelection();
        }
    }

    private void updateEnableState(boolean bl) {
        this.fLabel.setEnabled(bl);
        this.fWorkingSetCombo.setEnabled(bl && (this.fSelectedWorkingSets.length > 0 || this.getHistoryEntries().length > 0));
        this.fConfigure.setEnabled(bl);
    }

    private void updateWorkingSetSelection() {
        if (this.fSelectedWorkingSets.length > 0) {
            this.fWorkingSetCombo.setEnabled(true);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.fSelectedWorkingSets[0].getLabel());
            int n = 1;
            while (n < this.fSelectedWorkingSets.length) {
                IWorkingSet iWorkingSet = this.fSelectedWorkingSets[n];
                stringBuffer.append(',').append(' ');
                stringBuffer.append(iWorkingSet.getLabel());
                ++n;
            }
            String string = stringBuffer.toString();
            int n2 = this.historyIndex(string);
            this.historyInsert(string);
            if (n2 >= 0) {
                this.fWorkingSetCombo.select(n2);
            } else {
                this.fWorkingSetCombo.setItems(this.getHistoryEntries());
                this.fWorkingSetCombo.select(this.historyIndex(string));
            }
        } else {
            this.fEnableButton.setSelection(false);
            this.updateEnableState(false);
        }
    }

    private String[] getHistoryEntries() {
        String[] stringArray = this.fSelectionHistory.toArray(new String[this.fSelectionHistory.size()]);
        Arrays.sort(stringArray, new Comparator(){

            public int compare(Object object, Object object2) {
                return Collator.getInstance().compare(object, object2);
            }
        });
        return stringArray;
    }

    private void historyInsert(String string) {
        this.fSelectionHistory.remove(string);
        this.fSelectionHistory.add(0, string);
        this.storeSelectionHistory(this.fSettings);
    }

    private int historyIndex(String string) {
        int n = 0;
        while (n < this.fWorkingSetCombo.getItemCount()) {
            if (this.fWorkingSetCombo.getItem(n).equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void updateSelectedWorkingSets() {
        String string = this.fWorkingSetCombo.getItem(this.fWorkingSetCombo.getSelectionIndex());
        String[] stringArray = string.split(", ");
        IWorkingSetManager iWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        this.fSelectedWorkingSets = new IWorkingSet[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            IWorkingSet iWorkingSet = iWorkingSetManager.getWorkingSet(stringArray[n]);
            Assert.isNotNull((Object)iWorkingSet);
            this.fSelectedWorkingSets[n] = iWorkingSet;
            ++n;
        }
    }

    private void storeSelectionHistory(IDialogSettings iDialogSettings) {
        String[] stringArray;
        if (this.fSelectionHistory.size() > 5) {
            List list = this.fSelectionHistory.subList(0, 5);
            stringArray = list.toArray(new String[list.size()]);
        } else {
            stringArray = this.fSelectionHistory.toArray(new String[this.fSelectionHistory.size()]);
        }
        iDialogSettings.put(WORKINGSET_SELECTION_HISTORY, stringArray);
    }

    private ArrayList loadSelectionHistory(IDialogSettings iDialogSettings, String[] stringArray) {
        String[] stringArray2 = iDialogSettings.getArray(WORKINGSET_SELECTION_HISTORY);
        if (stringArray2 == null || stringArray2.length == 0) {
            return new ArrayList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        IWorkingSetManager iWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        int n = 0;
        while (n < stringArray2.length) {
            String[] stringArray3 = stringArray2[n].split(", ");
            boolean bl = true;
            int n2 = 0;
            while (n2 < stringArray3.length && bl) {
                IWorkingSet iWorkingSet = iWorkingSetManager.getWorkingSet(stringArray3[n2]);
                if (iWorkingSet == null) {
                    bl = false;
                } else if (!hashSet.contains(iWorkingSet.getId())) {
                    bl = false;
                }
                ++n2;
            }
            if (bl) {
                arrayList.add(stringArray2[n]);
            }
            ++n;
        }
        return arrayList;
    }

    private static int getButtonWidthHint(Button button) {
        button.setFont(JFaceResources.getDialogFont());
        GC gC = new GC((Drawable)button);
        gC.setFont(button.getFont());
        FontMetrics fontMetrics = gC.getFontMetrics();
        gC.dispose();
        int n = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        return Math.max(n, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }
}

