/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.launching;

import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.launching.LaunchingMessages;

public final class LibraryLocation {
    private IPath fSystemLibrary;
    private IPath fSystemLibrarySource;
    private IPath fPackageRootPath;
    private URL fJavadocLocation;

    public LibraryLocation(IPath iPath, IPath iPath2, IPath iPath3) {
        this(iPath, iPath2, iPath3, null);
    }

    public LibraryLocation(IPath iPath, IPath iPath2, IPath iPath3, URL uRL) {
        if (iPath == null) {
            throw new IllegalArgumentException(LaunchingMessages.libraryLocation_assert_libraryNotNull);
        }
        this.fSystemLibrary = iPath;
        this.fSystemLibrarySource = iPath2;
        this.fPackageRootPath = iPath3;
        this.fJavadocLocation = uRL;
    }

    public IPath getSystemLibraryPath() {
        return this.fSystemLibrary;
    }

    public IPath getSystemLibrarySourcePath() {
        return this.fSystemLibrarySource;
    }

    public IPath getPackageRootPath() {
        return this.fPackageRootPath;
    }

    public boolean equals(Object object) {
        if (object instanceof LibraryLocation) {
            LibraryLocation libraryLocation = (LibraryLocation)object;
            return this.getSystemLibraryPath().equals((Object)libraryLocation.getSystemLibraryPath()) && this.equals(this.getSystemLibrarySourcePath(), libraryLocation.getSystemLibrarySourcePath()) && this.equals(this.getPackageRootPath(), libraryLocation.getPackageRootPath()) && this.equalsOrNull(this.getJavadocLocation(), libraryLocation.getJavadocLocation());
        }
        return false;
    }

    public int hashCode() {
        return this.getSystemLibraryPath().hashCode();
    }

    protected boolean equals(IPath iPath, IPath iPath2) {
        return this.equalsOrNull(iPath, iPath2);
    }

    private boolean equalsOrNull(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        if (object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    public URL getJavadocLocation() {
        return this.fJavadocLocation;
    }
}

