/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.wst.jsdt.core.ElementChangedEvent;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IElementChangedListener;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaElementDelta;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.ui.StandardJavaElementContentProvider;

public class JavaElementContentProvider
extends StandardJavaElementContentProvider
implements ITreeContentProvider,
IElementChangedListener {
    protected TreeViewer fViewer;
    protected Object fInput;

    public void dispose() {
        super.dispose();
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        super.inputChanged(viewer, object, object2);
        this.fViewer = (TreeViewer)viewer;
        if (object == null && object2 != null) {
            JavaCore.addElementChangedListener((IElementChangedListener)this);
        } else if (object != null && object2 == null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this);
        }
        this.fInput = object2;
    }

    public JavaElementContentProvider() {
    }

    public JavaElementContentProvider(boolean bl, boolean bl2) {
        super(bl, bl2);
    }

    public void elementChanged(ElementChangedEvent elementChangedEvent) {
        try {
            this.processDelta(elementChangedEvent.getDelta());
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
        }
    }

    protected void processDelta(IJavaElementDelta iJavaElementDelta) throws JavaModelException {
        Object object;
        Object object2;
        int n = iJavaElementDelta.getKind();
        int n2 = iJavaElementDelta.getFlags();
        IJavaElement iJavaElement = iJavaElementDelta.getElement();
        if (iJavaElement instanceof ICompilationUnit) {
            if (!this.getProvideWorkingCopy()) {
                return;
            }
            object2 = (ICompilationUnit)iJavaElement;
            if (!JavaModelUtil.isPrimary((ICompilationUnit)object2) || !this.isOnClassPath((ICompilationUnit)iJavaElement)) {
                return;
            }
        }
        if ((n2 & 0x400) != 0 || (n2 & 0x200) != 0) {
            this.postRefresh(iJavaElement);
            return;
        }
        if (n == 2) {
            object2 = this.internalGetParent(iJavaElement);
            this.postRemove(iJavaElement);
            if (object2 instanceof IPackageFragment) {
                this.updatePackageIcon((IJavaElement)((IPackageFragment)object2));
            }
            if (this.isPackageFragmentEmpty(iJavaElement.getParent()) && this.fViewer.testFindItem(object2) != null) {
                this.postRefresh(this.internalGetParent(object2));
            }
            return;
        }
        if (n == 1) {
            object2 = this.internalGetParent(iJavaElement);
            if (object2 instanceof IPackageFragment) {
                object = this.internalGetParent(object2);
                if (object2.equals(this.fInput)) {
                    this.postRefresh(object2);
                } else if (this.fViewer.testFindItem(object2) == null) {
                    this.postRefresh(object);
                } else {
                    this.postRefresh(object2);
                }
            } else {
                this.postAdd(object2, iJavaElement);
            }
        }
        if (iJavaElement instanceof ICompilationUnit && n == 4) {
            this.postRefresh(iJavaElement);
            return;
        }
        if (iJavaElement instanceof ICompilationUnit || iJavaElement instanceof IClassFile) {
            return;
        }
        if (iJavaElement instanceof IPackageFragmentRoot && (n2 & 0x8000) != 0) {
            this.postRefresh(iJavaElement);
        }
        if (this.isClassPathChange(iJavaElementDelta)) {
            this.postRefresh(iJavaElement.getJavaProject());
        }
        if (iJavaElementDelta.getResourceDeltas() != null) {
            object2 = iJavaElementDelta.getResourceDeltas();
            int n3 = 0;
            while (n3 < ((Object)object2).length) {
                this.processResourceDelta((IResourceDelta)object2[n3], iJavaElement);
                ++n3;
            }
        }
        if (((Object)(object2 = iJavaElementDelta.getAffectedChildren())).length > 1) {
            if (iJavaElement instanceof IPackageFragment) {
                object = (IJavaElement)this.internalGetParent(iJavaElement);
                if (iJavaElement.equals(this.fInput)) {
                    this.postRefresh(iJavaElement);
                } else {
                    this.postRefresh(object);
                }
                return;
            }
            if (iJavaElement instanceof IPackageFragmentRoot) {
                this.postRefresh(this.skipProjectPackageFragmentRoot((IPackageFragmentRoot)iJavaElement));
            } else {
                this.postRefresh(iJavaElement);
            }
            return;
        }
        int n4 = 0;
        while (n4 < ((Object)object2).length) {
            this.processDelta((IJavaElementDelta)object2[n4]);
            ++n4;
        }
    }

    private boolean isOnClassPath(ICompilationUnit iCompilationUnit) {
        IJavaProject iJavaProject = iCompilationUnit.getJavaProject();
        if (iJavaProject == null || !iJavaProject.exists()) {
            return false;
        }
        return iJavaProject.isOnClasspath((IJavaElement)iCompilationUnit);
    }

    private void updatePackageIcon(final IJavaElement iJavaElement) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control control = JavaElementContentProvider.this.fViewer.getControl();
                if (control != null && !control.isDisposed()) {
                    JavaElementContentProvider.this.fViewer.update((Object)iJavaElement, new String[]{"org.eclipse.jface.image"});
                }
            }
        });
    }

    private void processResourceDelta(IResourceDelta iResourceDelta, Object object) {
        IResourceDelta[] iResourceDeltaArray;
        int n = iResourceDelta.getKind();
        IResource iResource = iResourceDelta.getResource();
        if (iResource == null) {
            return;
        }
        if ((n & 2) != 0) {
            if (object instanceof IPackageFragment) {
                this.postRefresh(this.internalGetParent(object));
            } else {
                this.postRemove(iResource);
            }
        }
        if ((n & 1) != 0) {
            if (object instanceof IPackageFragment) {
                this.postRefresh(this.internalGetParent(object));
            } else {
                this.postAdd(object, iResource);
            }
        }
        if ((iResourceDeltaArray = iResourceDelta.getAffectedChildren()).length > 1) {
            this.postRefresh(iResource);
            return;
        }
        int n2 = 0;
        while (n2 < iResourceDeltaArray.length) {
            this.processResourceDelta(iResourceDeltaArray[n2], iResource);
            ++n2;
        }
    }

    private void postRefresh(final Object object) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control control = JavaElementContentProvider.this.fViewer.getControl();
                if (control != null && !control.isDisposed()) {
                    JavaElementContentProvider.this.fViewer.refresh(object);
                }
            }
        });
    }

    private void postAdd(final Object object, final Object object2) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control control = JavaElementContentProvider.this.fViewer.getControl();
                if (control != null && !control.isDisposed()) {
                    JavaElementContentProvider.this.fViewer.add(object, object2);
                }
            }
        });
    }

    private void postRemove(final Object object) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control control = JavaElementContentProvider.this.fViewer.getControl();
                if (control != null && !control.isDisposed()) {
                    JavaElementContentProvider.this.fViewer.remove(object);
                }
            }
        });
    }

    private void postRunnable(Runnable runnable) {
        Control control = this.fViewer.getControl();
        if (control != null && !control.isDisposed()) {
            control.getDisplay().asyncExec(runnable);
        }
    }
}

