/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.wst.jsdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ImageImageDescriptor;
import org.eclipse.wst.jsdt.ui.JavaElementImageDescriptor;

public class OverrideIndicatorLabelDecorator
implements ILabelDecorator,
ILightweightLabelDecorator {
    private ImageDescriptorRegistry fRegistry;
    private boolean fUseNewRegistry = false;

    public OverrideIndicatorLabelDecorator() {
        this(null);
        this.fUseNewRegistry = true;
    }

    public OverrideIndicatorLabelDecorator(ImageDescriptorRegistry imageDescriptorRegistry) {
        this.fRegistry = imageDescriptorRegistry;
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = this.fUseNewRegistry ? new ImageDescriptorRegistry() : JavaPlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    public String decorateText(String string, Object object) {
        return string;
    }

    public Image decorateImage(Image image, Object object) {
        int n = this.computeAdornmentFlags(object);
        if (n != 0) {
            ImageImageDescriptor imageImageDescriptor = new ImageImageDescriptor(image);
            Rectangle rectangle = image.getBounds();
            return this.getRegistry().get((ImageDescriptor)new JavaElementImageDescriptor(imageImageDescriptor, n, new Point(rectangle.width, rectangle.height)));
        }
        return image;
    }

    public int computeAdornmentFlags(Object object) {
        block7: {
            if (object instanceof IMethod) {
                IMethod iMethod;
                block6: {
                    iMethod = (IMethod)object;
                    if (iMethod.getJavaProject().isOnClasspath((IJavaElement)iMethod)) break block6;
                    return 0;
                }
                try {
                    int n = iMethod.getFlags();
                    if (!(iMethod.isConstructor() || Flags.isPrivate((int)n) || Flags.isStatic((int)n))) {
                        int n2 = this.getOverrideIndicators(iMethod);
                        if (n2 != 0 && Flags.isSynchronized((int)n)) {
                            return n2 | 4;
                        }
                        return n2;
                    }
                }
                catch (JavaModelException javaModelException) {
                    if (javaModelException.isDoesNotExist()) break block7;
                    JavaPlugin.log(javaModelException);
                }
            }
        }
        return 0;
    }

    protected int getOverrideIndicators(IMethod iMethod) throws JavaModelException {
        int n;
        CompilationUnit compilationUnit = JavaPlugin.getDefault().getASTProvider().getAST((IJavaElement)iMethod.getOpenable(), ASTProvider.WAIT_ACTIVE_ONLY, null);
        if (compilationUnit != null && (n = this.findInHierarchyWithAST(compilationUnit, iMethod)) != -1) {
            return n;
        }
        IType iType = iMethod.getDeclaringType();
        if (iType == null) {
            return 0;
        }
        MethodOverrideTester methodOverrideTester = SuperTypeHierarchyCache.getMethodOverrideTester(iType);
        IMethod iMethod2 = methodOverrideTester.findOverriddenMethod(iMethod, true);
        if (iMethod2 != null) {
            if (JdtFlags.isAbstract((IMember)iMethod2)) {
                return 256;
            }
            return 128;
        }
        return 0;
    }

    private int findInHierarchyWithAST(CompilationUnit compilationUnit, IMethod iMethod) throws JavaModelException {
        IMethodBinding iMethodBinding;
        ASTNode aSTNode = NodeFinder.perform((ASTNode)compilationUnit, iMethod.getNameRange());
        if (aSTNode instanceof SimpleName && aSTNode.getParent() instanceof MethodDeclaration && (iMethodBinding = ((MethodDeclaration)aSTNode.getParent()).resolveBinding()) != null) {
            IMethodBinding iMethodBinding2 = Bindings.findOverriddenMethod(iMethodBinding, true);
            if (iMethodBinding2 != null) {
                if (JdtFlags.isAbstract(iMethodBinding2)) {
                    return 256;
                }
                return 128;
            }
            return 0;
        }
        return -1;
    }

    protected int findInHierarchy(IType iType, ITypeHierarchy iTypeHierarchy, String string, String[] stringArray) throws JavaModelException {
        IMethod iMethod;
        IType iType2 = iTypeHierarchy.getSuperclass(iType);
        if (iType2 != null && (iMethod = JavaModelUtil.findMethodInHierarchy(iTypeHierarchy, iType2, string, stringArray, false)) != null && !Flags.isPrivate((int)iMethod.getFlags()) && JavaModelUtil.isVisibleInHierarchy((IMember)iMethod, iType.getPackageFragment())) {
            if (JdtFlags.isAbstract((IMember)iMethod)) {
                return 256;
            }
            return 128;
        }
        iMethod = iTypeHierarchy.getSuperInterfaces(iType);
        int n = 0;
        while (n < ((IMethod)iMethod).length) {
            IMethod iMethod2 = JavaModelUtil.findMethodInHierarchy(iTypeHierarchy, (IType)iMethod[n], string, stringArray, false);
            if (iMethod2 != null) {
                if (JdtFlags.isAbstract((IMember)iMethod2)) {
                    return 256;
                }
                return 128;
            }
            ++n;
        }
        return 0;
    }

    public void addListener(ILabelProviderListener iLabelProviderListener) {
    }

    public void dispose() {
        if (this.fRegistry != null && this.fUseNewRegistry) {
            this.fRegistry.dispose();
        }
    }

    public boolean isLabelProperty(Object object, String string) {
        return true;
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
    }

    public void decorate(Object object, IDecoration iDecoration) {
        int n = this.computeAdornmentFlags(object);
        if ((n & 0x100) != 0) {
            if ((n & 4) != 0) {
                iDecoration.addOverlay(JavaPluginImages.DESC_OVR_SYNCH_AND_IMPLEMENTS);
            } else {
                iDecoration.addOverlay(JavaPluginImages.DESC_OVR_IMPLEMENTS);
            }
        } else if ((n & 0x80) != 0) {
            if ((n & 4) != 0) {
                iDecoration.addOverlay(JavaPluginImages.DESC_OVR_SYNCH_AND_OVERRIDES);
            } else {
                iDecoration.addOverlay(JavaPluginImages.DESC_OVR_OVERRIDES);
            }
        }
    }
}

