/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui;

import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJarEntryResource;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaElementDelta;
import org.eclipse.wst.jsdt.core.IJavaModel;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IParent;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.ui.IWorkingCopyProvider;

public class StandardJavaElementContentProvider
implements ITreeContentProvider,
IWorkingCopyProvider {
    protected static final Object[] NO_CHILDREN = new Object[0];
    protected boolean fProvideMembers;
    protected boolean fProvideWorkingCopy;

    public StandardJavaElementContentProvider() {
        this(false);
    }

    public StandardJavaElementContentProvider(boolean bl, boolean bl2) {
        this(bl);
    }

    public StandardJavaElementContentProvider(boolean bl) {
        this.fProvideMembers = bl;
        this.fProvideWorkingCopy = bl;
    }

    public boolean getProvideMembers() {
        return this.fProvideMembers;
    }

    public void setProvideMembers(boolean bl) {
        this.fProvideMembers = bl;
    }

    public boolean getProvideWorkingCopy() {
        return this.fProvideWorkingCopy;
    }

    public void setProvideWorkingCopy(boolean bl) {
        this.fProvideWorkingCopy = bl;
    }

    public boolean providesWorkingCopies() {
        return this.getProvideWorkingCopy();
    }

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
    }

    public void dispose() {
    }

    public Object[] getChildren(Object object) {
        if (!this.exists(object)) {
            return NO_CHILDREN;
        }
        try {
            if (object instanceof IJavaModel) {
                return this.getJavaProjects((IJavaModel)object);
            }
            if (object instanceof IJavaProject) {
                return this.getPackageFragmentRoots((IJavaProject)object);
            }
            if (object instanceof IPackageFragmentRoot) {
                return this.getPackageFragmentRootContent((IPackageFragmentRoot)object);
            }
            if (object instanceof IPackageFragment) {
                return this.getPackageContent((IPackageFragment)object);
            }
            if (object instanceof IFolder) {
                return this.getFolderContent((IFolder)object);
            }
            if (object instanceof IJarEntryResource) {
                return ((IJarEntryResource)object).getChildren();
            }
            if (this.getProvideMembers() && object instanceof ISourceReference && object instanceof IParent) {
                if (object instanceof ITypeRoot) {
                    return this.filter(((IParent)object).getChildren());
                }
                return ((IParent)object).getChildren();
            }
        }
        catch (CoreException coreException) {
            return NO_CHILDREN;
        }
        return NO_CHILDREN;
    }

    protected boolean matches(IJavaElement iJavaElement) {
        if (iJavaElement.getElementType() == 7 && (iJavaElement.getParent().getElementType() == 5 || iJavaElement.getParent().getElementType() == 6)) {
            IType iType = (IType)iJavaElement;
            try {
                return iType.isAnonymous();
            }
            catch (JavaModelException javaModelException) {
                javaModelException.printStackTrace();
            }
        }
        return false;
    }

    protected IJavaElement[] filter(IJavaElement[] iJavaElementArray) {
        boolean bl = false;
        int n = 0;
        while (n < iJavaElementArray.length) {
            if (this.matches(iJavaElementArray[n])) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            return iJavaElementArray;
        }
        Vector<IJavaElement> vector = new Vector<IJavaElement>();
        int n2 = 0;
        while (n2 < iJavaElementArray.length) {
            if (!this.matches(iJavaElementArray[n2])) {
                vector.addElement(iJavaElementArray[n2]);
            }
            ++n2;
        }
        Object[] objectArray = new IJavaElement[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public boolean hasChildren(Object object) {
        Object[] objectArray;
        if (this.getProvideMembers()) {
            if (object instanceof ICompilationUnit || object instanceof IClassFile) {
                return true;
            }
        } else if (object instanceof ICompilationUnit || object instanceof IClassFile || object instanceof IFile) {
            return false;
        }
        if (object instanceof IJavaProject && !(objectArray = (Object[])object).getProject().isOpen()) {
            return false;
        }
        if (object instanceof IParent) {
            try {
                if (((IParent)object).hasChildren()) {
                    return true;
                }
            }
            catch (JavaModelException javaModelException) {
                return true;
            }
        }
        return (objectArray = this.getChildren(object)) != null && objectArray.length > 0;
    }

    public Object getParent(Object object) {
        if (!this.exists(object)) {
            return null;
        }
        return this.internalGetParent(object);
    }

    protected Object[] getPackageFragmentRootContent(IPackageFragmentRoot iPackageFragmentRoot) throws JavaModelException {
        Object[] objectArray = iPackageFragmentRoot.getChildren();
        if (this.isProjectPackageFragmentRoot(iPackageFragmentRoot)) {
            return objectArray;
        }
        Object[] objectArray2 = iPackageFragmentRoot.getNonJavaResources();
        if (objectArray2 == null) {
            return objectArray;
        }
        return StandardJavaElementContentProvider.concatenate(objectArray, objectArray2);
    }

    protected Object[] getPackageFragmentRoots(IJavaProject iJavaProject) throws JavaModelException {
        if (!iJavaProject.getProject().isOpen()) {
            return NO_CHILDREN;
        }
        IPackageFragmentRoot[] iPackageFragmentRootArray = iJavaProject.getPackageFragmentRoots();
        ArrayList<Object> arrayList = new ArrayList<Object>(iPackageFragmentRootArray.length);
        int n = 0;
        while (n < iPackageFragmentRootArray.length) {
            IPackageFragmentRoot iPackageFragmentRoot = iPackageFragmentRootArray[n];
            if (this.isProjectPackageFragmentRoot(iPackageFragmentRoot)) {
                Object[] objectArray = this.getPackageFragmentRootContent(iPackageFragmentRoot);
                int n2 = 0;
                while (n2 < objectArray.length) {
                    arrayList.add(objectArray[n2]);
                    ++n2;
                }
            } else {
                arrayList.add(iPackageFragmentRoot);
            }
            ++n;
        }
        Object[] objectArray = iJavaProject.getNonJavaResources();
        int n3 = 0;
        while (n3 < objectArray.length) {
            arrayList.add(objectArray[n3]);
            ++n3;
        }
        return arrayList.toArray();
    }

    protected Object[] getJavaProjects(IJavaModel iJavaModel) throws JavaModelException {
        return iJavaModel.getJavaProjects();
    }

    protected Object[] getPackageContent(IPackageFragment iPackageFragment) throws JavaModelException {
        if (iPackageFragment.getKind() == 1) {
            return StandardJavaElementContentProvider.concatenate(iPackageFragment.getCompilationUnits(), iPackageFragment.getNonJavaResources());
        }
        return StandardJavaElementContentProvider.concatenate(iPackageFragment.getClassFiles(), iPackageFragment.getNonJavaResources());
    }

    protected Object[] getFolderContent(IFolder iFolder) throws CoreException {
        Object[] objectArray = iFolder.members();
        IJavaProject iJavaProject = JavaCore.create((IProject)iFolder.getProject());
        if (iJavaProject == null || !iJavaProject.exists()) {
            return objectArray;
        }
        boolean bl = iJavaProject.isOnClasspath((IResource)iFolder);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            if (bl) {
                if (iJavaProject.findPackageFragmentRoot(object.getFullPath()) == null) {
                    arrayList.add(object);
                }
            } else if (!iJavaProject.isOnClasspath((IResource)object)) {
                arrayList.add(object);
            }
            ++n;
        }
        return arrayList.toArray();
    }

    protected boolean isClassPathChange(IJavaElementDelta iJavaElementDelta) {
        if (iJavaElementDelta.getElement().getElementType() != 3) {
            return false;
        }
        int n = iJavaElementDelta.getFlags();
        return iJavaElementDelta.getKind() == 4 && (n & 0x40) != 0 || (n & 0x80) != 0 || (n & 0x100) != 0;
    }

    protected Object skipProjectPackageFragmentRoot(IPackageFragmentRoot iPackageFragmentRoot) {
        if (this.isProjectPackageFragmentRoot(iPackageFragmentRoot)) {
            return iPackageFragmentRoot.getParent();
        }
        return iPackageFragmentRoot;
    }

    protected boolean isPackageFragmentEmpty(IJavaElement iJavaElement) throws JavaModelException {
        IPackageFragment iPackageFragment;
        return iJavaElement instanceof IPackageFragment && (iPackageFragment = (IPackageFragment)iJavaElement).exists() && !iPackageFragment.hasChildren() && iPackageFragment.getNonJavaResources().length <= 0 && iPackageFragment.hasSubpackages();
    }

    protected boolean isProjectPackageFragmentRoot(IPackageFragmentRoot iPackageFragmentRoot) {
        IJavaProject iJavaProject = iPackageFragmentRoot.getJavaProject();
        return iJavaProject != null && iJavaProject.getPath().equals((Object)iPackageFragmentRoot.getPath());
    }

    protected boolean exists(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof IResource) {
            return ((IResource)object).exists();
        }
        if (object instanceof IJavaElement) {
            return ((IJavaElement)object).exists();
        }
        return true;
    }

    protected Object internalGetParent(Object object) {
        if (object instanceof IResource) {
            IContainer iContainer = ((IResource)object).getParent();
            IJavaElement iJavaElement = JavaCore.create((IResource)iContainer);
            if (iJavaElement != null && iJavaElement.exists()) {
                return iJavaElement;
            }
            return iContainer;
        }
        if (object instanceof IJavaElement) {
            IJavaElement iJavaElement = ((IJavaElement)object).getParent();
            if (object instanceof IPackageFragment) {
                return this.skipProjectPackageFragmentRoot((IPackageFragmentRoot)iJavaElement);
            }
            return iJavaElement;
        }
        if (object instanceof IJarEntryResource) {
            return ((IJarEntryResource)object).getParent();
        }
        return null;
    }

    protected static Object[] concatenate(Object[] objectArray, Object[] objectArray2) {
        int n = objectArray.length;
        int n2 = objectArray2.length;
        if (n == 0) {
            return objectArray2;
        }
        if (n2 == 0) {
            return objectArray;
        }
        Object[] objectArray3 = new Object[n + n2];
        System.arraycopy(objectArray, 0, objectArray3, 0, n);
        System.arraycopy(objectArray2, 0, objectArray3, n, n2);
        return objectArray3;
    }
}

