/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.Page;
import org.eclipse.wst.jsdt.internal.ui.actions.CopyQualifiedNameAction;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.CopyToClipboardAction;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.CutAction;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.DeleteAction;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.PasteAction;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class CCPActionGroup
extends ActionGroup {
    private IWorkbenchSite fSite;
    private Clipboard fClipboard;
    private SelectionDispatchAction[] fActions;
    private SelectionDispatchAction fDeleteAction;
    private SelectionDispatchAction fCopyAction;
    private SelectionDispatchAction fCopyQualifiedNameAction;
    private SelectionDispatchAction fPasteAction;
    private SelectionDispatchAction fCutAction;

    public CCPActionGroup(IViewPart iViewPart) {
        this((IWorkbenchSite)iViewPart.getSite());
    }

    public CCPActionGroup(Page page) {
        this((IWorkbenchSite)page.getSite());
    }

    private CCPActionGroup(IWorkbenchSite iWorkbenchSite) {
        this.fSite = iWorkbenchSite;
        this.fClipboard = new Clipboard(iWorkbenchSite.getShell().getDisplay());
        this.fPasteAction = new PasteAction(this.fSite, this.fClipboard);
        this.fPasteAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this.fCopyAction = new CopyToClipboardAction(this.fSite, this.fClipboard);
        this.fCopyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.fCopyQualifiedNameAction = new CopyQualifiedNameAction(this.fSite);
        this.fCopyQualifiedNameAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.copy.qualified.name");
        this.fCutAction = new CutAction(this.fSite, this.fClipboard);
        this.fCutAction.setActionDefinitionId("org.eclipse.ui.edit.cut");
        this.fDeleteAction = new DeleteAction(this.fSite);
        this.fDeleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.fActions = new SelectionDispatchAction[]{this.fCutAction, this.fCopyAction, this.fCopyQualifiedNameAction, this.fPasteAction, this.fDeleteAction};
        this.registerActionsAsSelectionChangeListeners();
    }

    private void registerActionsAsSelectionChangeListeners() {
        ISelectionProvider iSelectionProvider = this.fSite.getSelectionProvider();
        ISelection iSelection = iSelectionProvider.getSelection();
        int n = 0;
        while (n < this.fActions.length) {
            SelectionDispatchAction selectionDispatchAction = this.fActions[n];
            selectionDispatchAction.update(iSelection);
            iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)selectionDispatchAction);
            ++n;
        }
    }

    private void deregisterActionsAsSelectionChangeListeners() {
        ISelectionProvider iSelectionProvider = this.fSite.getSelectionProvider();
        int n = 0;
        while (n < this.fActions.length) {
            iSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.fActions[n]);
            ++n;
        }
    }

    public IAction getDeleteAction() {
        return this.fDeleteAction;
    }

    public void fillActionBars(IActionBars iActionBars) {
        super.fillActionBars(iActionBars);
        iActionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.fDeleteAction);
        iActionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.fCopyAction);
        iActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.CopyQualifiedName", (IAction)this.fCopyQualifiedNameAction);
        iActionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.fCutAction);
        iActionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.fPasteAction);
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        super.fillContextMenu(iMenuManager);
        int n = 0;
        while (n < this.fActions.length) {
            SelectionDispatchAction selectionDispatchAction = this.fActions[n];
            if (selectionDispatchAction != this.fCutAction || this.fCutAction.isEnabled()) {
                iMenuManager.appendToGroup("group.edit", (IAction)selectionDispatchAction);
            }
            ++n;
        }
    }

    public void dispose() {
        super.dispose();
        if (this.fClipboard != null) {
            this.fClipboard.dispose();
            this.fClipboard = null;
        }
        this.deregisterActionsAsSelectionChangeListeners();
    }
}

