/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.wst.jsdt.core.IJavaElement;

public class ConvertingSelectionProvider
implements ISelectionProvider {
    private final ISelectionProvider fProvider;
    private SelectionChangedListener fListener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ConvertingSelectionProvider(ISelectionProvider iSelectionProvider) {
        Assert.isNotNull((Object)iSelectionProvider);
        this.fProvider = iSelectionProvider;
    }

    public ISelection convertFrom(ISelection iSelection) {
        return this.convertFromUsingDefaultMechanism(iSelection);
    }

    private ISelection convertFromUsingDefaultMechanism(ISelection iSelection) {
        if (!(iSelection instanceof IStructuredSelection)) {
            return iSelection;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        ArrayList arrayList = new ArrayList(iStructuredSelection.size());
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof IResource || e instanceof IJavaElement) {
                arrayList.add(e);
                continue;
            }
            if (e instanceof IAdaptable) {
                IResource iResource;
                IJavaElement iJavaElement;
                IAdaptable iAdaptable = (IAdaptable)e;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.wst.jsdt.core.IJavaElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iJavaElement = (IJavaElement)iAdaptable.getAdapter((Class)clazz)) != null) {
                    arrayList.add(iJavaElement);
                    continue;
                }
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iResource = (IResource)iAdaptable.getAdapter((Class)clazz2)) != null) {
                    arrayList.add(iResource);
                    continue;
                }
                arrayList.add(e);
                continue;
            }
            arrayList.add(e);
        }
        return new StructuredSelection(arrayList);
    }

    public ISelection convertTo(ISelection iSelection) {
        return iSelection;
    }

    public final ISelection getSelection() {
        return this.convertFrom(this.fProvider.getSelection());
    }

    public final void setSelection(ISelection iSelection) {
        this.fProvider.setSelection(this.convertTo(iSelection));
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        if (this.fListener == null) {
            this.fListener = new SelectionChangedListener();
            this.fProvider.addSelectionChangedListener((ISelectionChangedListener)this.fListener);
        }
        this.fListener.addListener(iSelectionChangedListener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        if (this.fListener == null) {
            return;
        }
        this.fListener.removeListener(iSelectionChangedListener);
        if (this.fListener.isEmpty()) {
            this.fProvider.removeSelectionChangedListener((ISelectionChangedListener)this.fListener);
            this.fListener = null;
        }
    }

    private class SelectionChangedListener
    implements ISelectionChangedListener {
        ListenerList fListeners = new ListenerList();

        private SelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            ISelection iSelection = ConvertingSelectionProvider.this.convertFrom(selectionChangedEvent.getSelection());
            SelectionChangedEvent selectionChangedEvent2 = new SelectionChangedEvent((ISelectionProvider)ConvertingSelectionProvider.this, iSelection);
            Object[] objectArray = this.fListeners.getListeners();
            int n = 0;
            while (n < objectArray.length) {
                ((ISelectionChangedListener)objectArray[n]).selectionChanged(selectionChangedEvent2);
                ++n;
            }
        }

        public void addListener(ISelectionChangedListener iSelectionChangedListener) {
            this.fListeners.add((Object)iSelectionChangedListener);
        }

        public void removeListener(ISelectionChangedListener iSelectionChangedListener) {
            this.fListeners.remove((Object)iSelectionChangedListener);
        }

        public boolean isEmpty() {
            return this.fListeners.isEmpty();
        }
    }
}

