/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSLine;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSScanner;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.wst.jsdt.internal.ui.refactoring.actions.ListDialog;
import org.eclipse.wst.jsdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.ExternalizeWizard;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.JavaElementLabelProvider;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class ExternalizeStringsAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;
    private NonNLSElement[] fElements;

    public ExternalizeStringsAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(ActionMessages.ExternalizeStringsAction_label);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.externalize_strings_action");
    }

    public ExternalizeStringsAction(CompilationUnitEditor compilationUnitEditor) {
        this((IWorkbenchSite)compilationUnitEditor.getEditorSite());
        this.fEditor = compilationUnitEditor;
        this.setEnabled(this.fEditor != null && SelectionConverter.canOperateOn(this.fEditor));
    }

    public void selectionChanged(ITextSelection iTextSelection) {
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isExternalizeStringsAvailable(iStructuredSelection));
        }
        catch (JavaModelException javaModelException) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)javaModelException))) {
                JavaPlugin.log(javaModelException);
            }
            this.setEnabled(false);
        }
    }

    public void run(ITextSelection iTextSelection) {
        IJavaElement iJavaElement = SelectionConverter.getInput(this.fEditor);
        if (!(iJavaElement instanceof ICompilationUnit)) {
            return;
        }
        this.run((ICompilationUnit)iJavaElement);
    }

    public void run(IStructuredSelection iStructuredSelection) {
        ICompilationUnit iCompilationUnit = ExternalizeStringsAction.getCompilationUnit(iStructuredSelection);
        if (iCompilationUnit != null) {
            this.run(iCompilationUnit);
        } else {
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, true, this.createRunnable(iStructuredSelection));
            }
            catch (InvocationTargetException invocationTargetException) {
                ExceptionHandler.handle(invocationTargetException, this.getShell(), ActionMessages.ExternalizeStringsAction_dialog_title, ActionMessages.FindStringsToExternalizeAction_error_message);
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            this.showResults();
        }
    }

    public void run(final ICompilationUnit iCompilationUnit) {
        if (!ActionUtil.isEditable(this.fEditor, this.getShell(), (IJavaElement)iCompilationUnit)) {
            return;
        }
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                try {
                    NLSRefactoring nLSRefactoring;
                    if (iCompilationUnit != null && iCompilationUnit.exists() && (nLSRefactoring = NLSRefactoring.create(iCompilationUnit)) != null) {
                        new RefactoringStarter().activate(nLSRefactoring, new ExternalizeWizard(nLSRefactoring), ExternalizeStringsAction.this.getShell(), ActionMessages.ExternalizeStringsAction_dialog_title, 3);
                    }
                }
                catch (JavaModelException javaModelException) {
                    ExceptionHandler.handle((CoreException)((Object)javaModelException), ExternalizeStringsAction.this.getShell(), ActionMessages.ExternalizeStringsAction_dialog_title, ActionMessages.ExternalizeStringsAction_dialog_message);
                }
            }
        });
    }

    private static ICompilationUnit getCompilationUnit(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.isEmpty() || iStructuredSelection.size() != 1) {
            return null;
        }
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof ICompilationUnit) {
            return (ICompilationUnit)object;
        }
        if (object instanceof IType) {
            return ((IType)object).getCompilationUnit();
        }
        return null;
    }

    private IRunnableWithProgress createRunnable(final IStructuredSelection iStructuredSelection) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                try {
                    ExternalizeStringsAction.this.fElements = ExternalizeStringsAction.this.doRun(iStructuredSelection, iProgressMonitor);
                }
                catch (CoreException coreException) {
                    throw new InvocationTargetException(coreException);
                }
            }
        };
    }

    private NonNLSElement[] doRun(IStructuredSelection iStructuredSelection, IProgressMonitor iProgressMonitor) throws CoreException {
        NonNLSElement[] nonNLSElementArray;
        List list = ExternalizeStringsAction.getSelectedElementList(iStructuredSelection);
        if (list == null || list.isEmpty()) {
            return new NonNLSElement[0];
        }
        iProgressMonitor.beginTask(ActionMessages.FindStringsToExternalizeAction_find_strings, list.size());
        try {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof IJavaElement) {
                    Object object;
                    IPackageFragmentRoot iPackageFragmentRoot;
                    IJavaElement iJavaElement = (IJavaElement)e;
                    int n = iJavaElement.getElementType();
                    if (n == 4) {
                        arrayList.addAll(this.analyze((IPackageFragment)iJavaElement, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)));
                        continue;
                    }
                    if (n == 3) {
                        iPackageFragmentRoot = (IPackageFragmentRoot)iJavaElement;
                        if (!iPackageFragmentRoot.isExternal() && !ReorgUtils.isClassFolder((IJavaElement)iPackageFragmentRoot)) {
                            arrayList.addAll(this.analyze((IPackageFragmentRoot)iJavaElement, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)));
                            continue;
                        }
                        iProgressMonitor.worked(1);
                        continue;
                    }
                    if (n == 2) {
                        arrayList.addAll(this.analyze((IJavaProject)iJavaElement, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)));
                        continue;
                    }
                    if (n == 5) {
                        iPackageFragmentRoot = (ICompilationUnit)iJavaElement;
                        if (iPackageFragmentRoot.exists() && (object = this.analyze((ICompilationUnit)iPackageFragmentRoot)) != null) {
                            arrayList.add(object);
                        }
                        iProgressMonitor.worked(1);
                        continue;
                    }
                    if (n == 7) {
                        NonNLSElement nonNLSElement;
                        iPackageFragmentRoot = (IType)iJavaElement;
                        object = iPackageFragmentRoot.getCompilationUnit();
                        if (object != null && object.exists() && (nonNLSElement = this.analyze((ICompilationUnit)object)) != null) {
                            arrayList.add(nonNLSElement);
                        }
                        iProgressMonitor.worked(1);
                        continue;
                    }
                    iProgressMonitor.worked(1);
                    continue;
                }
                iProgressMonitor.worked(1);
            }
            nonNLSElementArray = arrayList.toArray(new NonNLSElement[arrayList.size()]);
            Object var12_13 = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return nonNLSElementArray;
    }

    private void showResults() {
        if (this.noStrings()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.ExternalizeStringsAction_dialog_title, (String)ActionMessages.FindStringsToExternalizeAction_noStrings);
        } else {
            new NonNLSListDialog(this.getShell(), this.fElements, this.countStrings()).open();
        }
    }

    private boolean noStrings() {
        if (this.fElements != null) {
            int n = 0;
            while (n < this.fElements.length) {
                if (this.fElements[n].count != 0) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    private List analyze(IPackageFragment iPackageFragment, IProgressMonitor iProgressMonitor) throws CoreException {
        ArrayList<NonNLSElement> arrayList;
        block6: {
            if (iPackageFragment != null) break block6;
            ArrayList arrayList2 = new ArrayList(0);
            Object var7_5 = null;
            iProgressMonitor.done();
            return arrayList2;
        }
        try {
            ICompilationUnit[] iCompilationUnitArray = iPackageFragment.getCompilationUnits();
            iProgressMonitor.beginTask("", iCompilationUnitArray.length);
            iProgressMonitor.setTaskName(iPackageFragment.getElementName());
            ArrayList<NonNLSElement> arrayList3 = new ArrayList<NonNLSElement>(iCompilationUnitArray.length);
            int n = 0;
            while (n < iCompilationUnitArray.length) {
                iProgressMonitor.subTask(iCompilationUnitArray[n].getElementName());
                NonNLSElement nonNLSElement = this.analyze(iCompilationUnitArray[n]);
                if (nonNLSElement != null) {
                    arrayList3.add(nonNLSElement);
                }
                iProgressMonitor.worked(1);
                if (iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ++n;
            }
            arrayList = arrayList3;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return arrayList;
    }

    private List analyze(IPackageFragmentRoot iPackageFragmentRoot, IProgressMonitor iProgressMonitor) throws CoreException {
        ArrayList arrayList;
        try {
            IJavaElement[] iJavaElementArray = iPackageFragmentRoot.getChildren();
            iProgressMonitor.beginTask("", iJavaElementArray.length);
            iProgressMonitor.setTaskName(iPackageFragmentRoot.getElementName());
            ArrayList arrayList2 = new ArrayList();
            int n = 0;
            while (n < iJavaElementArray.length) {
                IJavaElement iJavaElement = iJavaElementArray[n];
                if (iJavaElement.getElementType() == 4) {
                    IPackageFragment iPackageFragment = (IPackageFragment)iJavaElement;
                    if (!iPackageFragment.isReadOnly()) {
                        arrayList2.addAll(this.analyze(iPackageFragment, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)));
                    } else {
                        iProgressMonitor.worked(1);
                    }
                } else {
                    iProgressMonitor.worked(1);
                }
                ++n;
            }
            arrayList = arrayList2;
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return arrayList;
    }

    private List analyze(IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws CoreException {
        ArrayList arrayList;
        try {
            IPackageFragment[] iPackageFragmentArray = iJavaProject.getPackageFragments();
            iProgressMonitor.beginTask("", iPackageFragmentArray.length);
            ArrayList arrayList2 = new ArrayList();
            int n = 0;
            while (n < iPackageFragmentArray.length) {
                if (!iPackageFragmentArray[n].isReadOnly()) {
                    arrayList2.addAll(this.analyze(iPackageFragmentArray[n], (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)));
                } else {
                    iProgressMonitor.worked(1);
                }
                ++n;
            }
            arrayList = arrayList2;
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return arrayList;
    }

    private int countStrings() {
        int n = 0;
        if (this.fElements != null) {
            int n2 = 0;
            while (n2 < this.fElements.length) {
                n += this.fElements[n2].count;
                ++n2;
            }
        }
        return n;
    }

    private NonNLSElement analyze(ICompilationUnit iCompilationUnit) throws CoreException {
        int n = this.countNonExternalizedStrings(iCompilationUnit);
        if (n == 0) {
            return null;
        }
        return new NonNLSElement(iCompilationUnit, n);
    }

    private int countNonExternalizedStrings(ICompilationUnit iCompilationUnit) throws CoreException {
        try {
            NLSLine[] nLSLineArray = NLSScanner.scan(iCompilationUnit);
            int n = 0;
            int n2 = 0;
            while (n2 < nLSLineArray.length) {
                n += this.countNonExternalizedStrings(nLSLineArray[n2]);
                ++n2;
            }
            return n;
        }
        catch (InvalidInputException invalidInputException) {
            throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 4, Messages.format(ActionMessages.FindStringsToExternalizeAction_error_cannotBeParsed, iCompilationUnit.getElementName()), (Throwable)invalidInputException));
        }
    }

    private int countNonExternalizedStrings(NLSLine nLSLine) {
        int n = 0;
        NLSElement[] nLSElementArray = nLSLine.getElements();
        int n2 = 0;
        while (n2 < nLSElementArray.length) {
            if (!nLSElementArray[n2].hasTag()) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    private static List getSelectedElementList(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection == null) {
            return null;
        }
        return iStructuredSelection.toList();
    }

    private static class NonNLSElement {
        ICompilationUnit cu;
        int count;

        NonNLSElement(ICompilationUnit iCompilationUnit, int n) {
            this.cu = iCompilationUnit;
            this.count = n;
        }
    }

    private static class NonNLSListDialog
    extends ListDialog {
        private static final int OPEN_BUTTON_ID = 1025;
        private Button fOpenButton;

        NonNLSListDialog(Shell shell, NonNLSElement[] nonNLSElementArray, int n) {
            super(shell);
            this.setInput(Arrays.asList(nonNLSElementArray));
            this.setTitle(ActionMessages.ExternalizeStringsAction_dialog_title);
            this.setMessage(Messages.format(ActionMessages.FindStringsToExternalizeAction_non_externalized, new Object[]{new Integer(n)}));
            this.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
            this.setLabelProvider((ILabelProvider)NonNLSListDialog.createLabelProvider());
        }

        public void create() {
            this.setShellStyle(2288);
            super.create();
        }

        protected Point getInitialSize() {
            return this.getShell().computeSize(-1, -1, true);
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = (Composite)super.createDialogArea(composite);
            this.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(this){
                final /* synthetic */ NonNLSListDialog this$1;
                {
                    this.this$1 = nonNLSListDialog;
                }

                public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                    if (NonNLSListDialog.access$0(this.this$1) != null) {
                        NonNLSListDialog.access$0(this.this$1).setEnabled(!this.this$1.getTableViewer().getSelection().isEmpty());
                    }
                }
            });
            this.getTableViewer().getTable().addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ NonNLSListDialog this$1;
                {
                    this.this$1 = nonNLSListDialog;
                }

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    NonNLSElement nonNLSElement = (NonNLSElement)selectionEvent.item.getData();
                    NonNLSListDialog.access$1(this.this$1, nonNLSElement.cu);
                }
            });
            this.getTableViewer().getTable().setFocus();
            NonNLSListDialog.applyDialogFont((Control)composite2);
            return composite2;
        }

        protected void createButtonsForButtonBar(Composite composite) {
            this.fOpenButton = this.createButton(composite, 1025, ActionMessages.FindStringsToExternalizeAction_button_label, true);
            this.fOpenButton.setEnabled(false);
            this.createButton(composite, 1, IDialogConstants.CLOSE_LABEL, false);
        }

        protected void buttonPressed(int n) {
            IStructuredSelection iStructuredSelection;
            if (n != 1025) {
                super.buttonPressed(n);
                return;
            }
            ISelection iSelection = this.getTableViewer().getSelection();
            if (iSelection instanceof IStructuredSelection && (iStructuredSelection = (IStructuredSelection)iSelection).getFirstElement() instanceof NonNLSElement) {
                this.openWizard(((NonNLSElement)iStructuredSelection.getFirstElement()).cu);
            }
        }

        private void openWizard(ICompilationUnit iCompilationUnit) {
            try {
                NLSRefactoring nLSRefactoring;
                if (iCompilationUnit != null && iCompilationUnit.exists() && (nLSRefactoring = NLSRefactoring.create(iCompilationUnit)) != null) {
                    new RefactoringStarter().activate(nLSRefactoring, new ExternalizeWizard(nLSRefactoring), this.getShell(), ActionMessages.ExternalizeStringsAction_dialog_title, 3);
                }
            }
            catch (JavaModelException javaModelException) {
                ExceptionHandler.handle((CoreException)((Object)javaModelException), ActionMessages.ExternalizeStringsAction_dialog_title, ActionMessages.FindStringsToExternalizeAction_error_message);
            }
        }

        private static LabelProvider createLabelProvider() {
            return new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT){

                public String getText(Object object) {
                    NonNLSElement nonNLSElement = (NonNLSElement)object;
                    String string = nonNLSElement.cu.getResource().getFullPath().toString();
                    return Messages.format(ActionMessages.FindStringsToExternalizeAction_foundStrings, new Object[]{new Integer(nonNLSElement.count), string});
                }

                public Image getImage(Object object) {
                    return super.getImage(((NonNLSElement)object).cu);
                }
            };
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.wst.jsdt.ui.nonnls_dialog_context");
        }

        static /* synthetic */ Button access$0(NonNLSListDialog nonNLSListDialog) {
            return nonNLSListDialog.fOpenButton;
        }

        static /* synthetic */ void access$1(NonNLSListDialog nonNLSListDialog, ICompilationUnit iCompilationUnit) {
            nonNLSListDialog.openWizard(iCompilationUnit);
        }
    }
}

