/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;
import org.eclipse.wst.jsdt.internal.ui.search.SearchUtil;
import org.eclipse.wst.jsdt.ui.actions.FindReferencesAction;
import org.eclipse.wst.jsdt.ui.search.ElementQuerySpecification;
import org.eclipse.wst.jsdt.ui.search.QuerySpecification;

public class FindReferencesInWorkingSetAction
extends FindReferencesAction {
    private IWorkingSet[] fWorkingSets;

    public FindReferencesInWorkingSetAction(IWorkbenchSite iWorkbenchSite) {
        this(iWorkbenchSite, (IWorkingSet[])null);
    }

    public FindReferencesInWorkingSetAction(IWorkbenchSite iWorkbenchSite, IWorkingSet[] iWorkingSetArray) {
        super(iWorkbenchSite);
        this.fWorkingSets = iWorkingSetArray;
    }

    public FindReferencesInWorkingSetAction(JavaEditor javaEditor) {
        this(javaEditor, null);
    }

    public FindReferencesInWorkingSetAction(JavaEditor javaEditor, IWorkingSet[] iWorkingSetArray) {
        super(javaEditor);
        this.fWorkingSets = iWorkingSetArray;
    }

    void init() {
        this.setText(SearchMessages.Search_FindReferencesInWorkingSetAction_label);
        this.setToolTipText(SearchMessages.Search_FindReferencesInWorkingSetAction_tooltip);
        this.setImageDescriptor(JavaPluginImages.DESC_OBJS_SEARCH_REF);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.find_references_in_working_set_action");
    }

    QuerySpecification createQuery(IJavaElement iJavaElement) throws JavaModelException, InterruptedException {
        JavaSearchScopeFactory javaSearchScopeFactory = JavaSearchScopeFactory.getInstance();
        IWorkingSet[] iWorkingSetArray = this.fWorkingSets;
        if (this.fWorkingSets == null && (iWorkingSetArray = javaSearchScopeFactory.queryWorkingSets()) == null) {
            return super.createQuery(iJavaElement);
        }
        SearchUtil.updateLRUWorkingSets(iWorkingSetArray);
        IJavaSearchScope iJavaSearchScope = javaSearchScopeFactory.createJavaSearchScope(iWorkingSetArray, true);
        String string = javaSearchScopeFactory.getWorkingSetScopeDescription(iWorkingSetArray, true);
        return new ElementQuerySpecification(iJavaElement, this.getLimitTo(), iJavaSearchScope, string);
    }
}

