/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;
import org.eclipse.wst.jsdt.internal.ui.search.SearchUtil;
import org.eclipse.wst.jsdt.ui.actions.FindAction;
import org.eclipse.wst.jsdt.ui.actions.FindImplementorsAction;
import org.eclipse.wst.jsdt.ui.actions.FindImplementorsInProjectAction;
import org.eclipse.wst.jsdt.ui.actions.FindImplementorsInWorkingSetAction;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;
import org.eclipse.wst.jsdt.ui.actions.WorkingSetFindAction;

public class ImplementorsSearchGroup
extends ActionGroup {
    private static final String MENU_TEXT = SearchMessages.group_implementors;
    private IWorkbenchSite fSite;
    private JavaEditor fEditor;
    private IActionBars fActionBars;
    private String fGroupId;
    private FindImplementorsAction fFindImplementorsAction;
    private FindImplementorsInProjectAction fFindImplementorsInProjectAction;
    private FindImplementorsInWorkingSetAction fFindImplementorsInWorkingSetAction;

    public ImplementorsSearchGroup(IWorkbenchSite iWorkbenchSite) {
        this.fSite = iWorkbenchSite;
        this.fGroupId = "group.search";
        this.fFindImplementorsAction = new FindImplementorsAction(iWorkbenchSite);
        this.fFindImplementorsAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.implementors.in.workspace");
        this.fFindImplementorsInProjectAction = new FindImplementorsInProjectAction(iWorkbenchSite);
        this.fFindImplementorsInProjectAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.implementors.in.project");
        this.fFindImplementorsInWorkingSetAction = new FindImplementorsInWorkingSetAction(iWorkbenchSite);
        this.fFindImplementorsInWorkingSetAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.implementors.in.working.set");
        ISelectionProvider iSelectionProvider = this.fSite.getSelectionProvider();
        ISelection iSelection = iSelectionProvider.getSelection();
        this.registerAction(this.fFindImplementorsAction, iSelectionProvider, iSelection);
        this.registerAction(this.fFindImplementorsInProjectAction, iSelectionProvider, iSelection);
        this.registerAction(this.fFindImplementorsInWorkingSetAction, iSelectionProvider, iSelection);
    }

    public ImplementorsSearchGroup(JavaEditor javaEditor) {
        this.fEditor = javaEditor;
        this.fSite = this.fEditor.getSite();
        this.fGroupId = "group.find";
        this.fFindImplementorsAction = new FindImplementorsAction(this.fEditor);
        this.fFindImplementorsAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.implementors.in.workspace");
        this.fEditor.setAction("SearchImplementorsInWorkspace", (IAction)this.fFindImplementorsAction);
        this.fFindImplementorsInProjectAction = new FindImplementorsInProjectAction(this.fEditor);
        this.fFindImplementorsInProjectAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.implementors.in.project");
        this.fEditor.setAction("SearchImplementorsInProject", (IAction)this.fFindImplementorsInProjectAction);
        this.fFindImplementorsInWorkingSetAction = new FindImplementorsInWorkingSetAction(this.fEditor);
        this.fFindImplementorsInWorkingSetAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.implementors.in.working.set");
        this.fEditor.setAction("SearchImplementorsInWorkingSet", (IAction)this.fFindImplementorsInWorkingSetAction);
    }

    private void registerAction(SelectionDispatchAction selectionDispatchAction, ISelectionProvider iSelectionProvider, ISelection iSelection) {
        selectionDispatchAction.update(iSelection);
        iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)selectionDispatchAction);
    }

    private void addAction(IAction iAction, IMenuManager iMenuManager) {
        if (iAction.isEnabled()) {
            iMenuManager.add(iAction);
        }
    }

    private void addWorkingSetAction(IWorkingSet[] iWorkingSetArray, IMenuManager iMenuManager) {
        WorkingSetFindAction workingSetFindAction = this.fEditor != null ? new WorkingSetFindAction(this.fEditor, (FindAction)new FindImplementorsInWorkingSetAction(this.fEditor, iWorkingSetArray), SearchUtil.toString(iWorkingSetArray)) : new WorkingSetFindAction(this.fSite, (FindAction)new FindImplementorsInWorkingSetAction(this.fSite, iWorkingSetArray), SearchUtil.toString(iWorkingSetArray));
        workingSetFindAction.update(this.getContext().getSelection());
        this.addAction((IAction)workingSetFindAction, iMenuManager);
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        MenuManager menuManager = new MenuManager(MENU_TEXT, "group.search");
        this.addAction((IAction)this.fFindImplementorsAction, (IMenuManager)menuManager);
        this.addAction((IAction)this.fFindImplementorsInProjectAction, (IMenuManager)menuManager);
        menuManager.add((IContributionItem)new Separator());
        Iterator iterator = SearchUtil.getLRUWorkingSets().sortedIterator();
        while (iterator.hasNext()) {
            this.addWorkingSetAction((IWorkingSet[])iterator.next(), (IMenuManager)menuManager);
        }
        this.addAction((IAction)this.fFindImplementorsInWorkingSetAction, (IMenuManager)menuManager);
        if (!menuManager.isEmpty()) {
            iMenuManager.appendToGroup(this.fGroupId, (IContributionItem)menuManager);
        }
    }

    public void fillActionBars(IActionBars iActionBars) {
        Assert.isNotNull((Object)iActionBars);
        super.fillActionBars(iActionBars);
        this.fActionBars = iActionBars;
        this.updateGlobalActionHandlers();
    }

    public void dispose() {
        ISelectionProvider iSelectionProvider = this.fSite.getSelectionProvider();
        if (iSelectionProvider != null) {
            this.disposeAction(this.fFindImplementorsAction, iSelectionProvider);
            this.disposeAction(this.fFindImplementorsInProjectAction, iSelectionProvider);
            this.disposeAction(this.fFindImplementorsInWorkingSetAction, iSelectionProvider);
        }
        super.dispose();
        this.fFindImplementorsAction = null;
        this.fFindImplementorsInProjectAction = null;
        this.fFindImplementorsInWorkingSetAction = null;
        this.updateGlobalActionHandlers();
    }

    private void updateGlobalActionHandlers() {
        if (this.fActionBars != null) {
            this.fActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.ImplementorsInWorkspace", (IAction)this.fFindImplementorsAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.ImplementorsInProject", (IAction)this.fFindImplementorsInProjectAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.ImplementorsInWorkingSet", (IAction)this.fFindImplementorsInWorkingSetAction);
        }
    }

    private void disposeAction(ISelectionChangedListener iSelectionChangedListener, ISelectionProvider iSelectionProvider) {
        if (iSelectionChangedListener != null) {
            iSelectionProvider.removeSelectionChangedListener(iSelectionChangedListener);
        }
    }
}

