/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class ModifyParametersAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public ModifyParametersAction(JavaEditor javaEditor) {
        this((IWorkbenchSite)javaEditor.getEditorSite());
        this.fEditor = javaEditor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public ModifyParametersAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(RefactoringMessages.RefactoringGroup_modify_Parameters_label);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.modify_parameters_action");
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isChangeSignatureAvailable(iStructuredSelection));
        }
        catch (JavaModelException javaModelException) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)javaModelException))) {
                JavaPlugin.log(javaModelException);
            }
            this.setEnabled(false);
        }
    }

    public void selectionChanged(ITextSelection iTextSelection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection javaTextSelection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isChangeSignatureAvailable(javaTextSelection));
        }
        catch (JavaModelException javaModelException) {
            this.setEnabled(false);
        }
    }

    public void run(IStructuredSelection iStructuredSelection) {
        try {
            if (RefactoringAvailabilityTester.isChangeSignatureAvailable(iStructuredSelection)) {
                IMethod iMethod = ModifyParametersAction.getSingleSelectedMethod(iStructuredSelection);
                if (!ActionUtil.isEditable(this.getShell(), (IJavaElement)iMethod)) {
                    return;
                }
                RefactoringExecutionStarter.startChangeSignatureRefactoring(iMethod, this, this.getShell());
            }
        }
        catch (JavaModelException javaModelException) {
            ExceptionHandler.handle((CoreException)((Object)javaModelException), RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }

    public void run(ITextSelection iTextSelection) {
        try {
            if (!ActionUtil.isEditable(this.fEditor)) {
                return;
            }
            IMethod iMethod = this.getSingleSelectedMethod(iTextSelection);
            if (RefactoringAvailabilityTester.isChangeSignatureAvailable(iMethod)) {
                RefactoringExecutionStarter.startChangeSignatureRefactoring(iMethod, this, this.getShell());
            } else {
                MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.OpenRefactoringWizardAction_unavailable, (String)RefactoringMessages.ModifyParametersAction_unavailable);
            }
        }
        catch (JavaModelException javaModelException) {
            ExceptionHandler.handle((CoreException)((Object)javaModelException), RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }

    private static IMethod getSingleSelectedMethod(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.isEmpty() || iStructuredSelection.size() != 1) {
            return null;
        }
        if (iStructuredSelection.getFirstElement() instanceof IMethod) {
            return (IMethod)iStructuredSelection.getFirstElement();
        }
        return null;
    }

    private IMethod getSingleSelectedMethod(ITextSelection iTextSelection) throws JavaModelException {
        IJavaElement[] iJavaElementArray = SelectionConverter.codeResolve(this.fEditor);
        if (iJavaElementArray.length > 1) {
            return null;
        }
        if (iJavaElementArray.length == 1 && iJavaElementArray[0] instanceof IMethod) {
            return (IMethod)iJavaElementArray[0];
        }
        IJavaElement iJavaElement = SelectionConverter.getInputAsCompilationUnit(this.fEditor).getElementAt(iTextSelection.getOffset());
        if (iJavaElement instanceof IMethod) {
            return (IMethod)iJavaElement;
        }
        return null;
    }
}

