/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import com.ibm.icu.text.Collator;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IEditingSupport;
import org.eclipse.jface.text.IEditingSupportRegistry;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.search.TypeNameMatch;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.OrganizeImportsOperation;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.QualifiedTypeNameHistory;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.MultiOrganizeImportAction;
import org.eclipse.wst.jsdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.wst.jsdt.internal.ui.dialogs.MultiElementListSelectionDialog;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.wst.jsdt.internal.ui.util.ElementValidator;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.TypeNameMatchLabelProvider;
import org.eclipse.wst.jsdt.ui.JavaUI;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class OrganizeImportsAction
extends SelectionDispatchAction {
    private static final OrganizeImportComparator ORGANIZE_IMPORT_COMPARATOR = new OrganizeImportComparator();
    private JavaEditor fEditor;
    private boolean fIsQueryShowing = false;
    private final MultiOrganizeImportAction fCleanUpDelegate;
    static /* synthetic */ Class class$0;

    public OrganizeImportsAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.fCleanUpDelegate = new MultiOrganizeImportAction(iWorkbenchSite);
        this.setText(ActionMessages.OrganizeImportsAction_label);
        this.setToolTipText(ActionMessages.OrganizeImportsAction_tooltip);
        this.setDescription(ActionMessages.OrganizeImportsAction_description);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.organize_imports_action_context");
    }

    public OrganizeImportsAction(JavaEditor javaEditor) {
        super((IWorkbenchSite)javaEditor.getEditorSite());
        this.fEditor = javaEditor;
        this.fCleanUpDelegate = new MultiOrganizeImportAction(javaEditor);
        this.setText(ActionMessages.OrganizeImportsAction_label);
        this.setToolTipText(ActionMessages.OrganizeImportsAction_tooltip);
        this.setDescription(ActionMessages.OrganizeImportsAction_description);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.organize_imports_action_context");
        this.setEnabled(this.fCleanUpDelegate.isEnabled());
    }

    public void selectionChanged(ITextSelection iTextSelection) {
        this.fCleanUpDelegate.selectionChanged(iTextSelection);
        this.setEnabled(this.fCleanUpDelegate.isEnabled());
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.fCleanUpDelegate.selectionChanged(iStructuredSelection);
        this.setEnabled(this.fCleanUpDelegate.isEnabled());
    }

    public void run(ITextSelection iTextSelection) {
        ICompilationUnit iCompilationUnit = OrganizeImportsAction.getCompilationUnit(this.fEditor);
        if (iCompilationUnit != null) {
            this.run(iCompilationUnit);
        }
    }

    private static ICompilationUnit getCompilationUnit(JavaEditor javaEditor) {
        IJavaElement iJavaElement = JavaUI.getEditorInputJavaElement(javaEditor.getEditorInput());
        if (!(iJavaElement instanceof ICompilationUnit)) {
            return null;
        }
        return (ICompilationUnit)iJavaElement;
    }

    public void run(IStructuredSelection iStructuredSelection) {
        ICompilationUnit[] iCompilationUnitArray = this.fCleanUpDelegate.getCompilationUnits(iStructuredSelection);
        if (iCompilationUnitArray.length == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.OrganizeImportsAction_EmptySelection_title, (String)ActionMessages.OrganizeImportsAction_EmptySelection_description);
        } else if (iCompilationUnitArray.length == 1) {
            this.run(iCompilationUnitArray[0]);
        } else {
            this.fCleanUpDelegate.run(iStructuredSelection);
        }
    }

    public void runOnMultiple(ICompilationUnit[] iCompilationUnitArray) {
        if (iCompilationUnitArray.length == 0) {
            return;
        }
        this.fCleanUpDelegate.run((IStructuredSelection)new StructuredSelection((Object[])iCompilationUnitArray));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(ICompilationUnit iCompilationUnit) {
        if (!ElementValidator.check((IJavaElement)iCompilationUnit, this.getShell(), ActionMessages.OrganizeImportsAction_error_title, this.fEditor != null)) {
            return;
        }
        if (!ActionUtil.isEditable(this.fEditor, this.getShell(), (IJavaElement)iCompilationUnit)) {
            return;
        }
        IEditingSupport iEditingSupport = this.createViewerHelper();
        try {
            IEditorPart iEditorPart;
            CodeGenerationSettings codeGenerationSettings = JavaPreferencesSettings.getCodeGenerationSettings(iCompilationUnit.getJavaProject());
            if (this.fEditor == null && EditorUtility.isOpenInEditor(iCompilationUnit) == null && (iEditorPart = JavaUI.openInEditor((IJavaElement)iCompilationUnit)) instanceof JavaEditor) {
                this.fEditor = (JavaEditor)iEditorPart;
            }
            iEditorPart = JavaPlugin.getDefault().getASTProvider().getAST((IJavaElement)iCompilationUnit, ASTProvider.WAIT_ACTIVE_ONLY, null);
            OrganizeImportsOperation organizeImportsOperation = new OrganizeImportsOperation(iCompilationUnit, (CompilationUnit)iEditorPart, codeGenerationSettings.importIgnoreLowercase, !iCompilationUnit.isWorkingCopy(), true, this.createChooseImportQuery());
            IRewriteTarget iRewriteTarget = null;
            if (this.fEditor != null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("org.eclipse.jface.text.IRewriteTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$0 = clazz2;
                }
                if ((iRewriteTarget = (IRewriteTarget)this.fEditor.getAdapter(clazz)) != null) {
                    iRewriteTarget.beginCompoundChange();
                }
            }
            IProgressService iProgressService = PlatformUI.getWorkbench().getProgressService();
            IWorkbenchWindow iWorkbenchWindow = this.getSite().getWorkbenchWindow();
            if (iWorkbenchWindow == null) {
                iWorkbenchWindow = iProgressService;
            }
            try {
                try {
                    this.registerHelper(iEditingSupport);
                    iProgressService.runInUI((IRunnableContext)iWorkbenchWindow, (IRunnableWithProgress)new WorkbenchRunnableAdapter(organizeImportsOperation, organizeImportsOperation.getScheduleRule()), organizeImportsOperation.getScheduleRule());
                    IProblem iProblem = organizeImportsOperation.getParseError();
                    if (iProblem != null) {
                        String string = Messages.format(ActionMessages.OrganizeImportsAction_single_error_parse, iProblem.getMessage());
                        MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.OrganizeImportsAction_error_title, (String)string);
                        if (this.fEditor != null && iProblem.getSourceStart() != -1) {
                            this.fEditor.selectAndReveal(iProblem.getSourceStart(), iProblem.getSourceEnd() - iProblem.getSourceStart() + 1);
                        }
                    } else if (this.fEditor != null) {
                        this.setStatusBarMessage(this.getOrganizeInfo(organizeImportsOperation));
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    ExceptionHandler.handle(invocationTargetException, this.getShell(), ActionMessages.OrganizeImportsAction_error_title, ActionMessages.OrganizeImportsAction_error_message);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                this.deregisterHelper(iEditingSupport);
                if (iRewriteTarget == null) throw throwable;
                iRewriteTarget.endCompoundChange();
                throw throwable;
            }
            {
                Object var11_15 = null;
                this.deregisterHelper(iEditingSupport);
                if (iRewriteTarget == null) return;
                iRewriteTarget.endCompoundChange();
                return;
            }
        }
        catch (CoreException coreException) {
            ExceptionHandler.handle(coreException, this.getShell(), ActionMessages.OrganizeImportsAction_error_title, ActionMessages.OrganizeImportsAction_error_message);
        }
    }

    private String getOrganizeInfo(OrganizeImportsOperation organizeImportsOperation) {
        int n = organizeImportsOperation.getNumberOfImportsAdded();
        if (n >= 0) {
            return Messages.format(ActionMessages.OrganizeImportsAction_summary_added, String.valueOf(n));
        }
        return Messages.format(ActionMessages.OrganizeImportsAction_summary_removed, String.valueOf(-n));
    }

    private OrganizeImportsOperation.IChooseImportQuery createChooseImportQuery() {
        return new OrganizeImportsOperation.IChooseImportQuery(){

            public TypeNameMatch[] chooseImports(TypeNameMatch[][] typeNameMatchArray, ISourceRange[] iSourceRangeArray) {
                return OrganizeImportsAction.this.doChooseImports(typeNameMatchArray, iSourceRangeArray);
            }
        };
    }

    private TypeNameMatch[] doChooseImports(TypeNameMatch[][] typeNameMatchArray, final ISourceRange[] iSourceRangeArray) {
        ITextSelection iTextSelection;
        ISelection iSelection = this.fEditor != null ? this.fEditor.getSelectionProvider().getSelection() : null;
        TypeNameMatch[] typeNameMatchArray2 = null;
        TypeNameMatchLabelProvider typeNameMatchLabelProvider = new TypeNameMatchLabelProvider(1);
        MultiElementListSelectionDialog multiElementListSelectionDialog = new MultiElementListSelectionDialog(this.getShell(), (ILabelProvider)typeNameMatchLabelProvider){

            protected void handleSelectionChanged() {
                super.handleSelectionChanged();
                OrganizeImportsAction.this.doListSelectionChanged(this.getCurrentPage(), iSourceRangeArray);
            }
        };
        this.fIsQueryShowing = true;
        multiElementListSelectionDialog.setTitle(ActionMessages.OrganizeImportsAction_selectiondialog_title);
        multiElementListSelectionDialog.setMessage(ActionMessages.OrganizeImportsAction_selectiondialog_message);
        multiElementListSelectionDialog.setElements(typeNameMatchArray);
        multiElementListSelectionDialog.setComparator(ORGANIZE_IMPORT_COMPARATOR);
        if (multiElementListSelectionDialog.open() == 0) {
            iTextSelection = multiElementListSelectionDialog.getResult();
            typeNameMatchArray2 = new TypeNameMatch[((Object[])iTextSelection).length];
            int n = 0;
            while (n < ((ITextSelection)iTextSelection).length) {
                Object[] objectArray = (Object[])iTextSelection[n];
                if (objectArray.length > 0) {
                    typeNameMatchArray2[n] = (TypeNameMatch)objectArray[0];
                    QualifiedTypeNameHistory.remember(typeNameMatchArray2[n].getFullyQualifiedName());
                }
                ++n;
            }
        }
        if (iSelection instanceof ITextSelection) {
            iTextSelection = (ITextSelection)iSelection;
            this.fEditor.selectAndReveal(iTextSelection.getOffset(), iTextSelection.getLength());
        }
        this.fIsQueryShowing = false;
        return typeNameMatchArray2;
    }

    private void doListSelectionChanged(int n, ISourceRange[] iSourceRangeArray) {
        if (this.fEditor != null && iSourceRangeArray != null && n >= 0 && n < iSourceRangeArray.length) {
            ISourceRange iSourceRange = iSourceRangeArray[n];
            this.fEditor.selectAndReveal(iSourceRange.getOffset(), iSourceRange.getLength());
        }
    }

    private void setStatusBarMessage(String string) {
        IStatusLineManager iStatusLineManager = this.fEditor.getEditorSite().getActionBars().getStatusLineManager();
        iStatusLineManager.setMessage(string);
    }

    private IEditingSupport createViewerHelper() {
        return new IEditingSupport(){

            public boolean isOriginator(DocumentEvent documentEvent, IRegion iRegion) {
                return true;
            }

            public boolean ownsFocusShell() {
                return OrganizeImportsAction.this.fIsQueryShowing;
            }
        };
    }

    private void registerHelper(IEditingSupport iEditingSupport) {
        if (this.fEditor == null) {
            return;
        }
        ISourceViewer iSourceViewer = this.fEditor.getViewer();
        if (iSourceViewer instanceof IEditingSupportRegistry) {
            IEditingSupportRegistry iEditingSupportRegistry = (IEditingSupportRegistry)iSourceViewer;
            iEditingSupportRegistry.register(iEditingSupport);
        }
    }

    private void deregisterHelper(IEditingSupport iEditingSupport) {
        if (this.fEditor == null) {
            return;
        }
        ISourceViewer iSourceViewer = this.fEditor.getViewer();
        if (iSourceViewer instanceof IEditingSupportRegistry) {
            IEditingSupportRegistry iEditingSupportRegistry = (IEditingSupportRegistry)iSourceViewer;
            iEditingSupportRegistry.unregister(iEditingSupport);
        }
    }

    public static class ObjectDelegate
    implements IObjectActionDelegate {
        private OrganizeImportsAction fAction;

        public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
            this.fAction = new OrganizeImportsAction((IWorkbenchSite)iWorkbenchPart.getSite());
        }

        public void run(IAction iAction) {
            this.fAction.run();
        }

        public void selectionChanged(IAction iAction, ISelection iSelection) {
            if (this.fAction == null) {
                iAction.setEnabled(false);
            }
        }
    }

    private static final class OrganizeImportComparator
    implements Comparator {
        private OrganizeImportComparator() {
        }

        public int compare(Object object, Object object2) {
            int n;
            if (((String)object).equals(object2)) {
                return 0;
            }
            QualifiedTypeNameHistory qualifiedTypeNameHistory = QualifiedTypeNameHistory.getDefault();
            int n2 = qualifiedTypeNameHistory.getPosition(object);
            if (n2 == (n = qualifiedTypeNameHistory.getPosition(object2))) {
                return Collator.getInstance().compare(object, object2);
            }
            if (n2 > n) {
                return -1;
            }
            return 1;
        }
    }
}

