/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.operations.UndoRedoActionGroup;
import org.eclipse.ui.part.Page;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.JDTQuickMenuAction;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.ui.actions.ExtractConstantAction;
import org.eclipse.wst.jsdt.ui.actions.ExtractMethodAction;
import org.eclipse.wst.jsdt.ui.actions.ExtractTempAction;
import org.eclipse.wst.jsdt.ui.actions.InlineAction;
import org.eclipse.wst.jsdt.ui.actions.IntroduceParameterAction;
import org.eclipse.wst.jsdt.ui.actions.ModifyParametersAction;
import org.eclipse.wst.jsdt.ui.actions.MoveAction;
import org.eclipse.wst.jsdt.ui.actions.RenameAction;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class RefactorActionGroup
extends ActionGroup {
    private static final String PERF_REFACTOR_ACTION_GROUP = "org.eclipse.wst.jsdt.ui/perf/explorer/RefactorActionGroup";
    public static final String MENU_ID = "org.eclipse.wst.jsdt.ui.refactoring.menu";
    public static final String GROUP_REORG = "reorgGroup";
    public static final String GROUP_TYPE = "typeGroup";
    public static final String GROUP_CODING = "codingGroup";
    public static final String GROUP_CODING2 = "codingGroup2";
    private static final String GROUP_REORG2 = "reorgGroup2";
    private static final String GROUP_TYPE2 = "typeGroup2";
    private IWorkbenchSite fSite;
    private JavaEditor fEditor;
    private String fGroupName = "group.reorganize";
    private boolean fBinary = false;
    private SelectionDispatchAction fMoveAction;
    private SelectionDispatchAction fRenameAction;
    private SelectionDispatchAction fModifyParametersAction;
    private SelectionDispatchAction fPullUpAction;
    private SelectionDispatchAction fPushDownAction;
    private SelectionDispatchAction fExtractSupertypeAction;
    private SelectionDispatchAction fUseSupertypeAction;
    private SelectionDispatchAction fInferTypeArgumentsAction;
    private SelectionDispatchAction fInlineAction;
    private SelectionDispatchAction fIntroduceIndirectionAction;
    private SelectionDispatchAction fExtractMethodAction;
    private SelectionDispatchAction fExtractTempAction;
    private SelectionDispatchAction fExtractConstantAction;
    private SelectionDispatchAction fIntroduceParameterAction;
    private SelectionDispatchAction fIntroduceFactoryAction;
    private SelectionDispatchAction fConvertLocalToFieldAction;
    private SelectionDispatchAction fSelfEncapsulateField;
    private UndoRedoActionGroup fUndoRedoActionGroup;
    private final List fActions = new ArrayList();
    private static final String QUICK_MENU_ID = "org.eclipse.wst.jsdt.ui.edit.text.java.refactor.quickMenu";
    private JDTQuickMenuAction fQuickAccessAction;
    private IHandlerActivation fQuickAccessHandlerActivation;
    private IHandlerService fHandlerService;
    private Action fNoActionAvailable = new NoActionAvailable();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public RefactorActionGroup(IViewPart iViewPart) {
        this((IWorkbenchSite)iViewPart.getSite());
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.commands.operations.IUndoContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IUndoContext iUndoContext = (IUndoContext)iWorkspace.getAdapter((Class)clazz);
        this.fUndoRedoActionGroup = new UndoRedoActionGroup((IWorkbenchPartSite)iViewPart.getViewSite(), iUndoContext, true);
    }

    public RefactorActionGroup(Page page) {
        this((IWorkbenchSite)page.getSite());
    }

    public RefactorActionGroup(JavaEditor javaEditor, String string, boolean bl) {
        PerformanceStats performanceStats = PerformanceStats.getStats((String)PERF_REFACTOR_ACTION_GROUP, (Object)((Object)this));
        performanceStats.startRun();
        this.fSite = javaEditor.getEditorSite();
        this.fEditor = javaEditor;
        this.fGroupName = string;
        this.fBinary = bl;
        ISelectionProvider iSelectionProvider = javaEditor.getSelectionProvider();
        ISelection iSelection = iSelectionProvider.getSelection();
        if (!this.fBinary) {
            this.fRenameAction = new RenameAction(javaEditor);
            this.initAction(this.fRenameAction, iSelection, "org.eclipse.wst.jsdt.ui.edit.text.java.rename.element");
            javaEditor.setAction("RenameElement", (IAction)this.fRenameAction);
            this.fMoveAction = new MoveAction(javaEditor);
            this.initAction(this.fMoveAction, iSelection, "org.eclipse.wst.jsdt.ui.edit.text.java.move.element");
            javaEditor.setAction("MoveElement", (IAction)this.fMoveAction);
            this.fModifyParametersAction = new ModifyParametersAction(javaEditor);
            this.initAction(this.fModifyParametersAction, iSelection, "org.eclipse.wst.jsdt.ui.edit.text.java.modify.method.parameters");
            javaEditor.setAction("ModifyParameters", (IAction)this.fModifyParametersAction);
            this.fExtractMethodAction = new ExtractMethodAction(javaEditor);
            this.initUpdatingAction(this.fExtractMethodAction, iSelectionProvider, iSelection, "org.eclipse.wst.jsdt.ui.edit.text.java.extract.method");
            javaEditor.setAction("ExtractMethod", (IAction)this.fExtractMethodAction);
            this.fExtractTempAction = new ExtractTempAction(javaEditor);
            this.initUpdatingAction(this.fExtractTempAction, iSelectionProvider, iSelection, "org.eclipse.wst.jsdt.ui.edit.text.java.extract.local.variable");
            javaEditor.setAction("ExtractLocalVariable", (IAction)this.fExtractTempAction);
            this.fExtractConstantAction = new ExtractConstantAction(javaEditor);
            this.initUpdatingAction(this.fExtractConstantAction, iSelectionProvider, iSelection, "org.eclipse.wst.jsdt.ui.edit.text.java.extract.constant");
            javaEditor.setAction("ExtractConstant", (IAction)this.fExtractConstantAction);
            this.fIntroduceParameterAction = new IntroduceParameterAction(javaEditor);
            this.initUpdatingAction(this.fIntroduceParameterAction, iSelectionProvider, iSelection, "org.eclipse.wst.jsdt.ui.edit.text.java.introduce.parameter");
            javaEditor.setAction("IntroduceParameter", (IAction)this.fIntroduceParameterAction);
        }
        this.fInlineAction = new InlineAction(javaEditor);
        this.initAction(this.fInlineAction, iSelection, "org.eclipse.wst.jsdt.ui.edit.text.java.inline");
        javaEditor.setAction("Inline", (IAction)this.fInlineAction);
        this.installQuickAccessAction();
        performanceStats.endRun();
    }

    private RefactorActionGroup(IWorkbenchSite iWorkbenchSite) {
        PerformanceStats performanceStats = PerformanceStats.getStats((String)PERF_REFACTOR_ACTION_GROUP, (Object)((Object)this));
        performanceStats.startRun();
        this.fSite = iWorkbenchSite;
        ISelectionProvider iSelectionProvider = this.fSite.getSelectionProvider();
        ISelection iSelection = iSelectionProvider.getSelection();
        if (!this.fBinary) {
            this.fMoveAction = new MoveAction(iWorkbenchSite);
            this.initUpdatingAction(this.fMoveAction, iSelectionProvider, iSelection, "org.eclipse.wst.jsdt.ui.edit.text.java.move.element");
            this.fRenameAction = new RenameAction(iWorkbenchSite);
            this.initUpdatingAction(this.fRenameAction, iSelectionProvider, iSelection, "org.eclipse.wst.jsdt.ui.edit.text.java.rename.element");
            this.fModifyParametersAction = new ModifyParametersAction(this.fSite);
            this.initUpdatingAction(this.fModifyParametersAction, iSelectionProvider, iSelection, "org.eclipse.wst.jsdt.ui.edit.text.java.modify.method.parameters");
        }
        this.fInlineAction = new InlineAction(this.fSite);
        this.initUpdatingAction(this.fInlineAction, iSelectionProvider, iSelection, "org.eclipse.wst.jsdt.ui.edit.text.java.inline");
        this.installQuickAccessAction();
        performanceStats.endRun();
    }

    private void installQuickAccessAction() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fHandlerService = (IHandlerService)this.fSite.getService((Class)clazz);
        if (this.fHandlerService != null) {
            this.fQuickAccessAction = new RefactorQuickAccessAction(this.fEditor);
            this.fQuickAccessHandlerActivation = this.fHandlerService.activateHandler(this.fQuickAccessAction.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.fQuickAccessAction));
        }
    }

    private void initAction(SelectionDispatchAction selectionDispatchAction, ISelection iSelection, String string) {
        this.initUpdatingAction(selectionDispatchAction, null, iSelection, string);
    }

    private void initUpdatingAction(SelectionDispatchAction selectionDispatchAction, ISelectionProvider iSelectionProvider, ISelection iSelection, String string) {
        selectionDispatchAction.setActionDefinitionId(string);
        selectionDispatchAction.update(iSelection);
        if (iSelectionProvider != null) {
            iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)selectionDispatchAction);
        }
        this.fActions.add(selectionDispatchAction);
    }

    public void fillActionBars(IActionBars iActionBars) {
        super.fillActionBars(iActionBars);
        if (!this.fBinary) {
            iActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.Move", (IAction)this.fMoveAction);
            iActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.Rename", (IAction)this.fRenameAction);
            iActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.ModifyParameters", (IAction)this.fModifyParametersAction);
            iActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.ExtractTemp", (IAction)this.fExtractTempAction);
            iActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.ExtractMethod", (IAction)this.fExtractMethodAction);
        }
        if (this.fUndoRedoActionGroup != null) {
            this.fUndoRedoActionGroup.fillActionBars(iActionBars);
        }
    }

    public void retargetFileMenuActions(IActionBars iActionBars) {
        iActionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.fRenameAction);
        iActionBars.setGlobalActionHandler(ActionFactory.MOVE.getId(), (IAction)this.fMoveAction);
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        super.fillContextMenu(iMenuManager);
        this.addRefactorSubmenu(iMenuManager);
    }

    public void dispose() {
        ISelectionProvider iSelectionProvider = this.fSite.getSelectionProvider();
        if (!this.fBinary) {
            this.disposeAction(this.fMoveAction, iSelectionProvider);
            this.disposeAction(this.fRenameAction, iSelectionProvider);
            this.disposeAction(this.fExtractTempAction, iSelectionProvider);
            this.disposeAction(this.fIntroduceParameterAction, iSelectionProvider);
            this.disposeAction(this.fExtractMethodAction, iSelectionProvider);
        }
        if (this.fQuickAccessHandlerActivation != null && this.fHandlerService != null) {
            this.fHandlerService.deactivateHandler(this.fQuickAccessHandlerActivation);
        }
        if (this.fUndoRedoActionGroup != null) {
            this.fUndoRedoActionGroup.dispose();
        }
        super.dispose();
    }

    private void disposeAction(ISelectionChangedListener iSelectionChangedListener, ISelectionProvider iSelectionProvider) {
        if (iSelectionChangedListener != null) {
            iSelectionProvider.removeSelectionChangedListener(iSelectionChangedListener);
        }
    }

    private void addRefactorSubmenu(IMenuManager iMenuManager) {
        String string = ActionMessages.RefactorMenu_label;
        if (this.fQuickAccessAction != null) {
            string = this.fQuickAccessAction.addShortcut(string);
        }
        MenuManager menuManager = new MenuManager(string, MENU_ID);
        if (this.fEditor != null) {
            IJavaElement iJavaElement = SelectionConverter.getInput(this.fEditor);
            if (iJavaElement != null && ActionUtil.isOnBuildPath(iJavaElement)) {
                menuManager.addMenuListener(new IMenuListener(){

                    public void menuAboutToShow(IMenuManager iMenuManager) {
                        RefactorActionGroup.this.refactorMenuShown(iMenuManager);
                    }
                });
                menuManager.add((IAction)this.fNoActionAvailable);
                iMenuManager.appendToGroup(this.fGroupName, (IContributionItem)menuManager);
            }
        } else {
            ISelection iSelection = this.fSite.getSelectionProvider().getSelection();
            Iterator iterator = this.fActions.iterator();
            while (iterator.hasNext()) {
                ((SelectionDispatchAction)((Object)iterator.next())).update(iSelection);
            }
            if (this.fillRefactorMenu((IMenuManager)menuManager) > 0) {
                iMenuManager.appendToGroup(this.fGroupName, (IContributionItem)menuManager);
            }
        }
    }

    private int fillRefactorMenu(IMenuManager iMenuManager) {
        int n = 0;
        iMenuManager.add((IContributionItem)new Separator(GROUP_REORG));
        n += this.addAction(iMenuManager, (IAction)this.fRenameAction);
        n += this.addAction(iMenuManager, (IAction)this.fMoveAction);
        iMenuManager.add((IContributionItem)new Separator(GROUP_CODING));
        n += this.addAction(iMenuManager, (IAction)this.fModifyParametersAction);
        n += this.addAction(iMenuManager, (IAction)this.fExtractMethodAction);
        n += this.addAction(iMenuManager, (IAction)this.fExtractTempAction);
        iMenuManager.add((IContributionItem)new Separator(GROUP_CODING2));
        return n += this.addAction(iMenuManager, (IAction)this.fIntroduceParameterAction);
    }

    private int addAction(IMenuManager iMenuManager, IAction iAction) {
        if (iAction != null && iAction.isEnabled()) {
            iMenuManager.add(iAction);
            return 1;
        }
        return 0;
    }

    private void refactorMenuShown(final IMenuManager iMenuManager) {
        Menu menu = ((MenuManager)iMenuManager).getMenu();
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuHidden(MenuEvent menuEvent) {
                RefactorActionGroup.this.refactorMenuHidden(iMenuManager);
            }
        });
        ITextSelection iTextSelection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
        JavaTextSelection javaTextSelection = new JavaTextSelection(this.getEditorInput(), this.getDocument(), iTextSelection.getOffset(), iTextSelection.getLength());
        Iterator iterator = this.fActions.iterator();
        while (iterator.hasNext()) {
            SelectionDispatchAction selectionDispatchAction = (SelectionDispatchAction)((Object)iterator.next());
            selectionDispatchAction.update((ISelection)javaTextSelection);
        }
        iMenuManager.removeAll();
        if (this.fillRefactorMenu(iMenuManager) == 0) {
            iMenuManager.add((IAction)this.fNoActionAvailable);
        }
    }

    private void refactorMenuHidden(IMenuManager iMenuManager) {
        ITextSelection iTextSelection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
        Iterator iterator = this.fActions.iterator();
        while (iterator.hasNext()) {
            SelectionDispatchAction selectionDispatchAction = (SelectionDispatchAction)((Object)iterator.next());
            selectionDispatchAction.update((ISelection)iTextSelection);
        }
    }

    private IJavaElement getEditorInput() {
        IEditorInput iEditorInput = this.fEditor.getEditorInput();
        if (iEditorInput instanceof IClassFileEditorInput) {
            IClassFileEditorInput iClassFileEditorInput = (IClassFileEditorInput)iEditorInput;
            return iClassFileEditorInput.getClassFile();
        }
        return JavaPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(iEditorInput);
    }

    private IDocument getDocument() {
        return JavaPlugin.getDefault().getCompilationUnitDocumentProvider().getDocument(this.fEditor.getEditorInput());
    }

    private void fillQuickMenu(IMenuManager iMenuManager) {
        if (this.fEditor != null) {
            IJavaElement iJavaElement = SelectionConverter.getInput(this.fEditor);
            if (iJavaElement == null || !ActionUtil.isOnBuildPath(iJavaElement)) {
                iMenuManager.add((IAction)this.fNoActionAvailable);
                return;
            }
            ITextSelection iTextSelection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
            JavaTextSelection javaTextSelection = new JavaTextSelection(this.getEditorInput(), this.getDocument(), iTextSelection.getOffset(), iTextSelection.getLength());
            Iterator iterator = this.fActions.iterator();
            while (iterator.hasNext()) {
                ((SelectionDispatchAction)((Object)iterator.next())).update((ISelection)javaTextSelection);
            }
            this.fillRefactorMenu(iMenuManager);
            iterator = this.fActions.iterator();
            while (iterator.hasNext()) {
                ((SelectionDispatchAction)((Object)iterator.next())).update((ISelection)iTextSelection);
            }
        } else {
            ISelection iSelection = this.fSite.getSelectionProvider().getSelection();
            Iterator iterator = this.fActions.iterator();
            while (iterator.hasNext()) {
                ((SelectionDispatchAction)((Object)iterator.next())).update(iSelection);
            }
            this.fillRefactorMenu(iMenuManager);
        }
    }

    private static class NoActionAvailable
    extends Action {
        public NoActionAvailable() {
            this.setEnabled(true);
            this.setText(RefactoringMessages.RefactorActionGroup_no_refactoring_available);
        }
    }

    private class RefactorQuickAccessAction
    extends JDTQuickMenuAction {
        public RefactorQuickAccessAction(JavaEditor javaEditor) {
            super(javaEditor, RefactorActionGroup.QUICK_MENU_ID);
        }

        protected void fillMenu(IMenuManager iMenuManager) {
            RefactorActionGroup.this.fillQuickMenu(iMenuManager);
        }
    }
}

