/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class RemoveFromClasspathAction
extends SelectionDispatchAction {
    public RemoveFromClasspathAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(ActionMessages.RemoveFromClasspathAction_Remove);
        this.setToolTipText(ActionMessages.RemoveFromClasspathAction_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.removefromclasspath_action_context");
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.setEnabled(RemoveFromClasspathAction.checkEnabled(iStructuredSelection));
    }

    private static boolean checkEnabled(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.isEmpty()) {
            return false;
        }
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            if (RemoveFromClasspathAction.canRemove(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public void run(final IStructuredSelection iStructuredSelection) {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(new IWorkspaceRunnable(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                    try {
                        IPackageFragmentRoot[] iPackageFragmentRootArray = RemoveFromClasspathAction.getRootsToRemove(iStructuredSelection);
                        iProgressMonitor.beginTask(ActionMessages.RemoveFromClasspathAction_Removing, iPackageFragmentRootArray.length);
                        int n = 0;
                        while (n < iPackageFragmentRootArray.length) {
                            int n2 = 3;
                            iPackageFragmentRootArray[n].delete(0, n2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                            ++n;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        iProgressMonitor.done();
                        throw throwable;
                    }
                    {
                        Object var5_7 = null;
                    }
                    iProgressMonitor.done();
                }
            }));
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionHandler.handle(invocationTargetException, this.getShell(), ActionMessages.RemoveFromClasspathAction_exception_dialog_title, ActionMessages.RemoveFromClasspathAction_Problems_occurred);
        }
        catch (InterruptedException interruptedException) {}
    }

    private static IPackageFragmentRoot[] getRootsToRemove(IStructuredSelection iStructuredSelection) {
        ArrayList arrayList = new ArrayList(iStructuredSelection.size());
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!RemoveFromClasspathAction.canRemove(e)) continue;
            arrayList.add(e);
        }
        return arrayList.toArray(new IPackageFragmentRoot[arrayList.size()]);
    }

    private static boolean canRemove(Object object) {
        if (!(object instanceof IPackageFragmentRoot)) {
            return false;
        }
        IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)object;
        try {
            IClasspathEntry iClasspathEntry = iPackageFragmentRoot.getRawClasspathEntry();
            return iClasspathEntry != null && iClasspathEntry.getEntryKind() != 5;
        }
        catch (JavaModelException javaModelException) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)javaModelException))) {
                JavaPlugin.log(javaModelException);
            }
            return false;
        }
    }
}

