/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class ShowInNavigatorViewAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public ShowInNavigatorViewAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(ActionMessages.ShowInNavigatorView_label);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.show_in_navigator_action");
    }

    public ShowInNavigatorViewAction(JavaEditor javaEditor) {
        this((IWorkbenchSite)javaEditor.getEditorSite());
        this.fEditor = javaEditor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public void selectionChanged(ITextSelection iTextSelection) {
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.setEnabled(this.getResource(iStructuredSelection) != null);
    }

    public void run(ITextSelection iTextSelection) {
        IJavaElement iJavaElement = SelectionConverter.getInput(this.fEditor);
        if (!ActionUtil.isProcessable(this.getShell(), iJavaElement)) {
            return;
        }
        try {
            IJavaElement[] iJavaElementArray = SelectionConverter.codeResolveOrInputForked(this.fEditor);
            if (iJavaElementArray == null || iJavaElementArray.length == 0) {
                return;
            }
            IJavaElement iJavaElement2 = iJavaElementArray[0];
            if (iJavaElementArray.length > 1) {
                iJavaElement2 = SelectionConverter.selectJavaElement(iJavaElementArray, this.getShell(), ShowInNavigatorViewAction.getDialogTitle(), ActionMessages.ShowInNavigatorView_dialog_message);
            }
            if (iJavaElement2 != null) {
                this.run(this.getResource(iJavaElement2));
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionHandler.handle(invocationTargetException, ShowInNavigatorViewAction.getDialogTitle(), ActionMessages.SelectionConverter_codeResolve_failed);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void run(IStructuredSelection iStructuredSelection) {
        this.run(this.getResource(iStructuredSelection));
    }

    public void run(IResource iResource) {
        if (iResource == null) {
            return;
        }
        try {
            IWorkbenchPage iWorkbenchPage = this.getSite().getWorkbenchWindow().getActivePage();
            IViewPart iViewPart = iWorkbenchPage.showView("org.eclipse.ui.views.ResourceNavigator");
            if (iViewPart instanceof ISetSelectionTarget) {
                StructuredSelection structuredSelection = new StructuredSelection((Object)iResource);
                ((ISetSelectionTarget)iViewPart).selectReveal((ISelection)structuredSelection);
            }
        }
        catch (PartInitException partInitException) {
            ExceptionHandler.handle((CoreException)((Object)partInitException), this.getShell(), ShowInNavigatorViewAction.getDialogTitle(), ActionMessages.ShowInNavigatorView_error_activation_failed);
        }
    }

    private IResource getResource(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.size() != 1) {
            return null;
        }
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof IResource) {
            return (IResource)object;
        }
        if (object instanceof IJavaElement) {
            return this.getResource((IJavaElement)object);
        }
        return null;
    }

    private IResource getResource(IJavaElement iJavaElement) {
        if (iJavaElement == null) {
            return null;
        }
        if ((iJavaElement = (IJavaElement)iJavaElement.getOpenable()) instanceof ICompilationUnit) {
            iJavaElement = ((ICompilationUnit)iJavaElement).getPrimary();
        }
        return iJavaElement.getResource();
    }

    private static String getDialogTitle() {
        return ActionMessages.ShowInNavigatorView_dialog_title;
    }
}

