/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.natures;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class NatureUtil {
    public static void removeNature(IProject iProject, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProject.hasNature(string)) {
            IProjectDescription iProjectDescription = iProject.getDescription();
            String[] stringArray = iProjectDescription.getNatureIds();
            String[] stringArray2 = new String[stringArray.length - 1];
            int n = 0;
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (!stringArray[n2].equals(string)) {
                    stringArray2[n] = stringArray[n2];
                    ++n;
                }
                ++n2;
            }
            iProjectDescription.setNatureIds(stringArray2);
            iProject.setDescription(iProjectDescription, iProgressMonitor);
        }
    }

    public static void addNature(IProject iProject, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        if (!iProject.hasNature(string)) {
            IProjectDescription iProjectDescription = iProject.getDescription();
            String[] stringArray = iProjectDescription.getNatureIds();
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray.length] = string;
            iProjectDescription.setNatureIds(stringArray2);
            try {
                iProject.setDescription(iProjectDescription, iProgressMonitor);
            }
            catch (CoreException coreException) {
                iProjectDescription.setNatureIds(stringArray);
                iProject.setDescription(iProjectDescription, iProgressMonitor);
                throw coreException;
            }
        }
    }

    public static void addBuilder(IProject iProject, String string) throws CoreException {
        IProjectDescription iProjectDescription = iProject.getDescription();
        int n = NatureUtil.getBuilderIndex(iProjectDescription.getBuildSpec(), string);
        if (n == -1) {
            ICommand[] iCommandArray;
            ICommand iCommand = iProjectDescription.newCommand();
            iCommand.setBuilderName(string);
            ICommand[] iCommandArray2 = iProjectDescription.getBuildSpec();
            int n2 = NatureUtil.getBuilderIndex(iCommandArray2, string);
            if (n2 == -1) {
                iCommandArray = new ICommand[iCommandArray2.length + 1];
                System.arraycopy(iCommandArray2, 0, iCommandArray, 0, iCommandArray2.length);
                iCommandArray[iCommandArray.length - 1] = iCommand;
            } else {
                iCommandArray2[n2] = iCommand;
                iCommandArray = iCommandArray2;
            }
            iProjectDescription.setBuildSpec(iCommandArray);
            iProject.setDescription(iProjectDescription, null);
        }
    }

    public static void removeBuilder(IProject iProject, String string) throws CoreException {
        IProjectDescription iProjectDescription = iProject.getDescription();
        int n = NatureUtil.getBuilderIndex(iProjectDescription.getBuildSpec(), string);
        if (n != -1) {
            ICommand[] iCommandArray = iProjectDescription.getBuildSpec();
            ICommand[] iCommandArray2 = new ICommand[iCommandArray.length - 1];
            int n2 = 0;
            int n3 = 0;
            while (n3 < iCommandArray.length) {
                if (n3 != n) {
                    iCommandArray2[n2] = iCommandArray[n3];
                    ++n2;
                }
                ++n3;
            }
            iProjectDescription.setBuildSpec(iCommandArray2);
            iProject.setDescription(iProjectDescription, null);
        }
    }

    protected static int getBuilderIndex(ICommand[] iCommandArray, String string) {
        int n = 0;
        while (n < iCommandArray.length) {
            if (iCommandArray[n].getBuilderName().equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected static void setBuilderCommand(IProject iProject, IProjectDescription iProjectDescription, ICommand iCommand, String string) throws CoreException {
        ICommand[] iCommandArray;
        ICommand[] iCommandArray2 = iProjectDescription.getBuildSpec();
        int n = NatureUtil.getBuilderIndex(iCommandArray2, string);
        if (n == -1) {
            iCommandArray = new ICommand[iCommandArray2.length + 1];
            System.arraycopy(iCommandArray2, 0, iCommandArray, 0, iCommandArray2.length);
            iCommandArray[iCommandArray.length - 1] = iCommand;
        } else {
            iCommandArray2[n] = iCommand;
            iCommandArray = iCommandArray2;
        }
        iProjectDescription.setBuildSpec(iCommandArray);
        iProject.setDescription(iProjectDescription, null);
    }
}

