/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.natures;

import org.eclipse.atf.natures.NatureUtil;
import org.eclipse.atf.runtime.IRuntime;
import org.eclipse.atf.runtime.handler.IRuntimeHandler;
import org.eclipse.atf.runtime.handler.SimpleRuntimeHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.QualifiedName;

public abstract class RuntimeAwareNature
extends PlatformObject
implements IProjectNature,
IExecutableExtension {
    private IProject project = null;
    protected static final String RUNTIME_PROP = "runtime";

    public IRuntimeHandler getDefaultRuntimeHandler(IRuntime iRuntime) {
        return new SimpleRuntimeHandler();
    }

    public abstract String getPrefixId();

    public String[] getAssociatedBuilderIds() {
        return new String[0];
    }

    public void clearRuntimeSettings() throws CoreException {
        this.project.setPersistentProperty(new QualifiedName(this.getPrefixId(), RUNTIME_PROP), null);
    }

    public void configure() throws CoreException {
        String[] stringArray = this.getAssociatedBuilderIds();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                NatureUtil.addBuilder(this.getProject(), stringArray[n]);
                ++n;
            }
        }
    }

    public void deconfigure() throws CoreException {
        this.clearRuntimeSettings();
        String[] stringArray = this.getAssociatedBuilderIds();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                NatureUtil.removeBuilder(this.getProject(), stringArray[n]);
                ++n;
            }
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject iProject) {
        this.project = iProject;
    }

    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) throws CoreException {
    }
}

