/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.runtime;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.atf.core.CorePlugin;
import org.eclipse.atf.runtime.IRuntime;
import org.eclipse.atf.runtime.IRuntimeContainer;
import org.eclipse.atf.runtime.IRuntimeInstance;
import org.eclipse.atf.runtime.IRuntimeInstanceContainer;
import org.eclipse.atf.runtime.Runtime;
import org.eclipse.atf.runtime.RuntimeInstance;
import org.eclipse.atf.runtime.installer.IRuntimeInstaller;
import org.eclipse.atf.runtime.validator.AlwaysValidRuntimeValidator;
import org.eclipse.atf.runtime.validator.IRuntimeValidator;
import org.eclipse.atf.runtime.version.IVersionFinder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class RuntimeManager
implements IRuntimeContainer,
IRuntimeInstanceContainer {
    protected static final String RUNTIME_PLUGIN_POINT = "runtime";
    protected static final String RUNTIME_INSTANCE_PLUGIN_POINT = "runtimeInstance";
    protected static final String USER_RUNTIME_PREF = "AJAX_RUNTIME_USER_SETTINGS";
    protected static final String ATTR_ID = "id";
    protected static final String ATTR_NAME = "name";
    protected static final String ATTR_TYPE = "type";
    protected static final String ATTR_VERSION = "version";
    protected static final String ATTR_LOCATION = "location";
    protected static final String ATTR_ALLOWUSERINSTANCES = "allowUserInstances";
    protected static final String TAG_RUNTIME = "runtime";
    protected static final String TAG_RUNTIME_INSTANCE = "runtime-instance";
    protected static final String TAG_HANDLER = "handler";
    protected static final String TAG_INSTALLER = "installer";
    protected static final String TAG_VALIDATOR = "validator";
    protected static final String TAG_VERSION = "version";
    protected static final String ATTR_CLASS = "class";
    protected HashMap runtimeMap = new HashMap();
    private static RuntimeManager instance = null;

    public static RuntimeManager getInstance() {
        if (instance == null) {
            instance = new RuntimeManager();
        }
        return instance;
    }

    private RuntimeManager() {
        this.loadSupportedRuntimes();
        this.loadInstancesFromExtension();
        this.loadEndUserConfigurations();
    }

    public IRuntime[] getRuntimes() {
        return this.runtimeMap.values().toArray(new IRuntime[0]);
    }

    public IRuntime getRuntime(String string) {
        return (IRuntime)this.runtimeMap.get(string);
    }

    public void addRuntime(IRuntime iRuntime) {
        if (!this.runtimeMap.containsKey(iRuntime.getId())) {
            this.runtimeMap.put(iRuntime.getId(), iRuntime);
        }
    }

    public void removeRuntime(IRuntime iRuntime) {
        this.runtimeMap.remove(iRuntime.getId());
    }

    public IRuntimeInstance[] getRuntimeInstances() {
        ArrayList<IRuntimeInstance> arrayList = new ArrayList<IRuntimeInstance>();
        IRuntime[] iRuntimeArray = this.getRuntimes();
        int n = 0;
        while (n < iRuntimeArray.length) {
            IRuntimeInstance[] iRuntimeInstanceArray = iRuntimeArray[n].getRuntimeInstances();
            int n2 = 0;
            while (n2 < iRuntimeInstanceArray.length) {
                arrayList.add(iRuntimeInstanceArray[n2]);
                ++n2;
            }
            ++n;
        }
        return (IRuntimeInstance[])arrayList.toArray(new IRuntimeInstaller[0]);
    }

    public IRuntimeInstance[] getRuntimeInstancesOfType(IRuntime iRuntime) {
        return this.getRuntimeInstancesOfType(iRuntime.getId());
    }

    public IRuntimeInstance[] getRuntimeInstancesOfType(String string) {
        if (this.runtimeMap.containsKey(string)) {
            IRuntime iRuntime = (IRuntime)this.runtimeMap.get(string);
            return iRuntime.getRuntimeInstances();
        }
        return new IRuntimeInstance[0];
    }

    public void addRuntimeInstance(IRuntimeInstance iRuntimeInstance, String string) {
        Runtime runtime = (Runtime)this.getRuntime(string);
        if (runtime != null) {
            runtime.addInstance((RuntimeInstance)iRuntimeInstance);
        }
    }

    public void removeRuntimeInstance(IRuntimeInstance iRuntimeInstance) {
        ((Runtime)iRuntimeInstance.getType()).removeInstance((RuntimeInstance)iRuntimeInstance);
    }

    protected void loadSupportedRuntimes() {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint("org.eclipse.atf.core", "runtime");
        if (iExtensionPoint == null) {
            return;
        }
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        int n = 0;
        while (n < iExtensionArray.length) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                block15: {
                    if (iConfigurationElementArray[n2].getName().equals("runtime")) {
                        Object object;
                        Runtime runtime;
                        block14: {
                            runtime = new Runtime(iConfigurationElementArray[n2].getAttribute(ATTR_ID), iConfigurationElementArray[n2].getAttribute(ATTR_NAME));
                            String string = iConfigurationElementArray[n2].getAttribute(ATTR_ALLOWUSERINSTANCES);
                            if (string != null) {
                                runtime.setAllowUserInstances(Boolean.valueOf(string));
                            }
                            try {
                                if (iConfigurationElementArray[n2].getChildren(TAG_INSTALLER).length <= 0) break block14;
                                object = (IRuntimeInstaller)iConfigurationElementArray[n2].createExecutableExtension(TAG_INSTALLER);
                                runtime.setInstaller((IRuntimeInstaller)object);
                            }
                            catch (CoreException coreException) {
                                CorePlugin.log(coreException, "No installer defined for runtime. Will not add to configuration");
                                break block15;
                            }
                        }
                        try {
                            if (iConfigurationElementArray[n2].getChildren(TAG_VALIDATOR).length > 0) {
                                object = (IRuntimeValidator)iConfigurationElementArray[n2].createExecutableExtension(TAG_VALIDATOR);
                                runtime.setValidator((IRuntimeValidator)object);
                            } else {
                                runtime.setValidator(new AlwaysValidRuntimeValidator());
                            }
                        }
                        catch (CoreException coreException) {
                            CorePlugin.log(coreException, "No validator defined for runtime.");
                        }
                        try {
                            if (iConfigurationElementArray[n2].getChildren("version").length > 0) {
                                object = (IVersionFinder)iConfigurationElementArray[n2].createExecutableExtension("version");
                                runtime.setVersionFinder((IVersionFinder)object);
                            }
                        }
                        catch (CoreException coreException) {
                            CorePlugin.log(coreException, "No version finder defined for runtime.");
                        }
                        this.addRuntime(runtime);
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    protected void loadInstancesFromExtension() {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint("org.eclipse.atf.core", RUNTIME_INSTANCE_PLUGIN_POINT);
        if (iExtensionPoint == null) {
            return;
        }
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        int n = 0;
        while (n < iExtensionArray.length) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                if (iConfigurationElementArray[n2].getName().equals("runtime")) {
                    RuntimeInstance runtimeInstance = new RuntimeInstance();
                    runtimeInstance.setName(iConfigurationElementArray[n2].getAttribute(ATTR_NAME));
                    runtimeInstance.setLocation(iConfigurationElementArray[n2].getAttribute(ATTR_LOCATION));
                    runtimeInstance.setVersion(iConfigurationElementArray[n2].getAttribute("version"));
                    String string = iConfigurationElementArray[n2].getAttribute(ATTR_TYPE);
                    this.addRuntimeInstance(runtimeInstance, string);
                }
                ++n2;
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadEndUserConfigurations() {
        block14: {
            if (CorePlugin.getDefault().getPluginPreferences().contains("AJAX_RUNTIME_USER_SETTINGS") == false) return;
            var1_1 = CorePlugin.getDefault().getPluginPreferences().getString("AJAX_RUNTIME_USER_SETTINGS");
            var2_2 = null;
            var3_3 = null;
            try {
                try {
                    var3_3 = new BufferedInputStream(new ByteArrayInputStream(var1_1.getBytes("UTF8")));
                    var4_4 = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    var4_4.setErrorHandler(new DefaultHandler());
                    var2_2 = var4_4.parse(new InputSource(var3_3)).getDocumentElement();
                }
                catch (Exception v0) {
                    if (var3_3 == null) ** GOTO lbl-1000
                    try {
                        var3_3.close();
                        ** GOTO lbl-1000
                    }
                    catch (IOException var4_5) {
                        var4_5.printStackTrace();
                    }
                }
                ** GOTO lbl-1000
                {
                }
            }
            catch (Throwable var6_6) {
                var5_9 = null;
                if (var3_3 == null) throw var6_6;
                try {
                    var3_3.close();
                    throw var6_6;
                }
                catch (IOException var7_13) {
                    var7_13.printStackTrace();
                }
                throw var6_6;
            }
lbl-1000:
            // 4 sources

            {
                var5_10 = null;
                if (var3_3 == null) break block14;
            }
            ** try [egrp 3[TRYBLOCK] [4 : 130->137)] { 
lbl34:
            // 1 sources

            var3_3.close();
            break block14;
lbl36:
            // 1 sources

            catch (IOException var7_14) {
                var7_14.printStackTrace();
            }
        }
        if (var2_2 == null) return;
        if (!var2_2.getNodeName().equalsIgnoreCase("runtime-settings")) {
            return;
        }
        var4_4 = var2_2.getElementsByTagName("runtime");
        var5_11 = 0;
        while (true) {
            if (var5_11 >= var4_4.getLength()) break;
            var6_7 = (Element)var4_4.item(var5_11);
            var7_14 = new Runtime(var6_7.getAttribute("id"), var6_7.getAttribute("name"));
            var7_14.setIsUser(true);
            this.addRuntime((IRuntime)var7_14);
            ++var5_11;
        }
        var5_12 = var2_2.getElementsByTagName("runtime-instance");
        var6_8 = 0;
        while (true) {
            if (var6_8 >= var5_12.getLength()) {
                return;
            }
            var7_14 = (Element)var5_12.item(var6_8);
            var8_15 = new RuntimeInstance();
            var8_15.setName(var7_14.getAttribute("name"));
            var8_15.setLocation(var7_14.getAttribute("location"));
            var8_15.setVersion(var7_14.getAttribute("version"));
            var9_16 = var7_14.getAttribute("type");
            var8_15.setIsUser(true);
            this.addRuntimeInstance(var8_15, var9_16);
            ++var6_8;
        }
    }

    protected String serializeSettings() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<runtime-settings>");
        IRuntime[] iRuntimeArray = this.getRuntimes();
        int n = 0;
        while (n < iRuntimeArray.length) {
            IRuntime iRuntime = iRuntimeArray[n];
            if (iRuntime.isUser()) {
                stringBuffer.append(this.serializeRuntime(iRuntime));
            }
            IRuntimeInstance[] iRuntimeInstanceArray = iRuntime.getRuntimeInstances();
            int n2 = 0;
            while (n2 < iRuntimeInstanceArray.length) {
                IRuntimeInstance iRuntimeInstance = iRuntimeInstanceArray[n2];
                if (iRuntimeInstance.isUser()) {
                    stringBuffer.append(this.serializeRuntimeInstance(iRuntimeInstance));
                }
                ++n2;
            }
            ++n;
        }
        stringBuffer.append("</runtime-settings>");
        return stringBuffer.toString();
    }

    public String serializeRuntime(IRuntime iRuntime) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        stringBuffer.append("runtime");
        stringBuffer.append(" ");
        stringBuffer.append(ATTR_NAME);
        stringBuffer.append("=\"");
        stringBuffer.append(iRuntime.getName());
        stringBuffer.append("\" ");
        stringBuffer.append(ATTR_ID);
        stringBuffer.append("=\"");
        stringBuffer.append(iRuntime.getId());
        stringBuffer.append("\" />");
        return stringBuffer.toString();
    }

    public String serializeRuntimeInstance(IRuntimeInstance iRuntimeInstance) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        stringBuffer.append(TAG_RUNTIME_INSTANCE);
        stringBuffer.append(" ");
        stringBuffer.append(ATTR_NAME);
        stringBuffer.append("=\"");
        stringBuffer.append(iRuntimeInstance.getName());
        stringBuffer.append("\" ");
        stringBuffer.append(ATTR_TYPE);
        stringBuffer.append("=\"");
        stringBuffer.append(iRuntimeInstance.getType().getId());
        stringBuffer.append("\" ");
        stringBuffer.append(ATTR_LOCATION);
        stringBuffer.append("=\"");
        stringBuffer.append(iRuntimeInstance.getLocation());
        stringBuffer.append("\" ");
        stringBuffer.append("version");
        stringBuffer.append("=\"");
        stringBuffer.append(iRuntimeInstance.getVersion());
        stringBuffer.append("\" />");
        return stringBuffer.toString();
    }

    public void saveSettings() {
        String string = this.serializeSettings();
        CorePlugin.getDefault().getPluginPreferences().setValue(USER_RUNTIME_PREF, string);
        CorePlugin.getDefault().savePluginPreferences();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void installRuntimes(final Object[] objectArray, final IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor.beginTask("Installing runtime instances to project " + iProject.getName() + "...", 100);
        try {
            iProject.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                    int n = 100 / objectArray.length;
                    int n2 = 0;
                    while (n2 < objectArray.length) {
                        IRuntimeInstance iRuntimeInstance = (IRuntimeInstance)objectArray[n2];
                        IRuntime iRuntime = iRuntimeInstance.getType();
                        IRuntimeInstaller iRuntimeInstaller = iRuntime.getInstaller();
                        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, n);
                        subProgressMonitor.setTaskName("Installing " + iRuntime.getName() + " runtime assets...");
                        iRuntimeInstaller.install(iRuntimeInstance, iProject, (IProgressMonitor)subProgressMonitor);
                        ++n2;
                    }
                }
            }, iProgressMonitor);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        iProgressMonitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void uninstallRuntimes(final Object[] objectArray, final IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor.beginTask("Uninstalling runtime instance from project " + iProject.getName() + "...", 100);
        if (!iProject.hasNature("org.eclipse.atf.core.ATFNature")) {
            iProgressMonitor.done();
            throw new CoreException((IStatus)new Status(4, "org.eclipse.atf.core", 0, "Error uninstalling runtime! Nature not found. Without the nature, the runtime cannot be unistalled.", null));
        }
        try {
            iProject.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                    int n = 100 / objectArray.length;
                    int n2 = 0;
                    while (n2 < objectArray.length) {
                        IRuntimeInstance iRuntimeInstance = (IRuntimeInstance)objectArray[n2];
                        IRuntime iRuntime = iRuntimeInstance.getType();
                        IRuntimeInstaller iRuntimeInstaller = iRuntime.getInstaller();
                        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, n);
                        subProgressMonitor.setTaskName("Uninstalling " + iRuntime.getName() + " runtime assets...");
                        iRuntimeInstaller.uninstall(iRuntimeInstance, iProject, (IProgressMonitor)subProgressMonitor);
                        ++n2;
                    }
                }
            }, iProgressMonitor);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        iProgressMonitor.done();
    }
}

