/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.runtime.adapter;

import java.util.Collection;
import org.eclipse.atf.runtime.IRuntime;
import org.eclipse.atf.runtime.adapter.BaseRuntimeInstallerAdapter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class FacetAwareRuntimeInstallerAdapter
extends BaseRuntimeInstallerAdapter {
    public IStatus installRuntime(IRuntime iRuntime) {
        Status status = new Status(0, "org.eclipse.atf.core", 0, "Install Success.", null);
        try {
            IFacetedProject iFacetedProject = ProjectFacetsManager.create((IProject)this.getProject());
            IProjectFacet iProjectFacet = ProjectFacetsManager.getProjectFacet((String)iRuntime.getId());
            IProjectFacetVersion iProjectFacetVersion = iProjectFacet.getLatestVersion();
            if (!iFacetedProject.hasProjectFacet(iProjectFacetVersion)) {
                status = iProjectFacetVersion.getConstraint().check((Collection)iFacetedProject.getProjectFacets());
                if (status.getSeverity() == 0) {
                    iFacetedProject.installProjectFacet(iProjectFacetVersion, null, null);
                } else if (status instanceof MultiStatus) {
                    status = new Status(4, "org.eclipse.atf.core", 0, "Error adding facet for runtime <" + iRuntime.getId() + ">: Prerequisite facet constraints were not satisfied", null);
                }
            }
        }
        catch (CoreException coreException) {
            status = new Status(4, "org.eclipse.atf.core", 0, "Error adding facet for runtime <" + iRuntime.getId() + ">", (Throwable)coreException);
        }
        return status;
    }

    public boolean isInstalled(IRuntime iRuntime) {
        try {
            IFacetedProject iFacetedProject = ProjectFacetsManager.create((IProject)this.getProject());
            IProjectFacet iProjectFacet = ProjectFacetsManager.getProjectFacet((String)iRuntime.getId());
            return iFacetedProject.hasProjectFacet(iProjectFacet);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
            return false;
        }
    }
}

